/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import net.yura.mobile.io.ServiceLink;
import net.yura.mobile.logging.Logger;

public class BTService
extends ServiceLink {
    protected DiscoveryAgent discoveryAgent;
    private UUID uuid;
    protected LocalDevice localDevice;
    protected StreamConnectionNotifier streamNotifier;
    protected boolean bRegistered = false;
    protected boolean bClient = false;

    public boolean registerClient(UUID aUuid) {
        if (this.bRegistered) {
            return false;
        }
        this.uuid = aUuid;
        this.bClient = true;
        if (BTService.isSupported()) {
            try {
                this.discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
                this.bRegistered = true;
            }
            catch (Exception ex) {
                Logger.warn(ex);
            }
        }
        return this.bRegistered;
    }

    public boolean registerServer(UUID aUuid, String serviceName) {
        if (this.bRegistered) {
            return false;
        }
        this.bClient = false;
        if (BTService.isSupported()) {
            try {
                LocalDevice.getLocalDevice().setDiscoverable(10390323);
                this.streamNotifier = (StreamConnectionNotifier)Connector.open((String)("btspp://localhost:" + aUuid.toString() + ";name=" + serviceName + ";authorize=false"));
                this.bRegistered = true;
            }
            catch (Exception ex) {
                Logger.warn(ex);
            }
        }
        return this.bRegistered;
    }

    protected StreamConnection openConnection() throws IOException {
        if (this.bClient) {
            if (this.discoveryAgent == null) {
                throw new IOException("BlueTooth Not Supported");
            }
            String connectionString = this.discoveryAgent.selectService(this.uuid, 0, false);
            if (connectionString == null) {
                throw new IOException("No Services Found");
            }
            return (StreamConnection)Connector.open((String)connectionString);
        }
        if (this.streamNotifier == null) {
            throw new IOException("BlueTooth Not Supported");
        }
        return this.streamNotifier.acceptAndOpen();
    }

    public boolean isRegistered() {
        return this.bRegistered;
    }

    protected static boolean isSupported() {
        return System.getProperty("bluetooth.api.version") != null || LocalDevice.getProperty((String)"bluetooth.api.version") != null;
    }
}

