/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UTF8InputStreamReader
extends Reader {
    private InputStream inputStream;
    private byte[] buffer = new byte[0];
    private int x;
    private int y;
    private int z;
    private int stage;

    public UTF8InputStreamReader(InputStream i) {
        this.inputStream = i;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int numChars = 0;
        while (numChars == 0) {
            int available;
            int l;
            if (this.buffer.length < len) {
                this.buffer = new byte[len];
            }
            if ((l = this.inputStream.read(this.buffer, 0, (available = this.inputStream.available()) > len ? len : (available == 0 ? 1 : available))) < 0) {
                return l;
            }
            block5: for (int i = 0; i < l; ++i) {
                int result = -1;
                if (this.stage == 0) {
                    int b = this.buffer[i] & 0xFF;
                    switch (b >>> 5) {
                        case 6: {
                            this.y = b & 0x1F;
                            this.stage = 1;
                            continue block5;
                        }
                        case 7: {
                            if ((b & 0x10) != 0) {
                                throw new IOException("UTF8Decoder does not handle 32-bit characters");
                            }
                            this.z = b & 0xF;
                            this.stage = 2;
                            continue block5;
                        }
                        default: {
                            result = (char)(b & 0x7F);
                            break;
                        }
                    }
                } else if (this.stage == 1) {
                    this.x = this.buffer[i] & 0x3F;
                    result = (char)(this.y << 6 | this.x);
                } else {
                    if (this.stage == 2) {
                        this.y = this.buffer[i] & 0x3F;
                        this.stage = 3;
                        continue;
                    }
                    if (this.stage == 3) {
                        this.x = this.buffer[i] & 0x3F;
                        result = (char)(this.z << 12 | this.y << 6 | this.x);
                    }
                }
                if (result == -1) {
                    throw new IOException();
                }
                cbuf[off + numChars] = (char)result;
                ++numChars;
                this.stage = 0;
            }
        }
        return numChars;
    }

    public void close() throws IOException {
        this.buffer = null;
        this.inputStream.close();
    }
}

