/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.io.kxml2.KXmlParser;
import net.yura.mobile.io.kxml2.KXmlSerializer;
import net.yura.mobile.logging.Logger;
import org.xmlpull.v1.XmlSerializer;

public class XMLUtil {
    public static final String TAG_HASHTABLE = "Hashtable";
    public static final String TAG_VECTOR = "Vector";
    public static final String TAG_ARRAY = "ArrayList";
    public static final String TAG_STRING = "String";
    public static final String TAG_INTEGER = "Integer";
    public static final String TAG_DOUBLE = "Double";
    public static final String TAG_FLOAT = "Float";
    public static final String TAG_BOOLEAN = "Boolean";
    public static final String TAG_SHORT = "Short";
    public static final String TAG_LONG = "Long";
    public static final String TAG_CHARACTER = "Character";
    public static final String TAG_BYTE = "Byte";
    public static final String TAG_NULL = "nulltype";
    private KXmlParser parser;

    public Object load(Reader reader) throws Exception {
        if (this.parser == null) {
            this.parser = new KXmlParser();
        }
        this.parser.setInput(reader);
        this.parser.nextTag();
        return this.readObject(this.parser);
    }

    public void save(OutputStream output, Object object) throws IOException {
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput(output, "UTF-8");
        serializer.startDocument("UTF-8", null);
        this.saveObject(serializer, object);
        serializer.endDocument();
        serializer.flush();
    }

    protected void saveVector(XmlSerializer serializer, Vector object) throws IOException {
        for (int c = 0; c < object.size(); ++c) {
            this.saveObject(serializer, object.elementAt(c));
        }
    }

    protected void saveArray(XmlSerializer serializer, Object[] object) throws IOException {
        for (int c = 0; c < object.length; ++c) {
            this.saveObject(serializer, object[c]);
        }
    }

    protected void saveHashtable(XmlSerializer serializer, Hashtable object) throws IOException {
        Object obj;
        Object key;
        Enumeration enu = object.keys();
        while (enu.hasMoreElements()) {
            key = enu.nextElement();
            obj = object.get(key);
            if (!(obj instanceof String) || !(key instanceof String)) continue;
            serializer.attribute(null, (String)key, (String)obj);
        }
        enu = object.keys();
        while (enu.hasMoreElements()) {
            key = enu.nextElement();
            obj = object.get(key);
            if (obj instanceof String && key instanceof String) continue;
            serializer.startTag(null, "entry");
            this.saveObject(serializer, key);
            this.saveObject(serializer, obj);
            serializer.endTag(null, "entry");
        }
    }

    protected static boolean isSimpleObject(Object object) {
        return object == null || object instanceof String || object instanceof Integer || object instanceof Double || object instanceof Long || object instanceof Float || object instanceof Short || object instanceof Byte || object instanceof Character || object instanceof Boolean;
    }

    protected void saveObject(XmlSerializer serializer, Object object) throws IOException {
        if (object instanceof Hashtable) {
            serializer.startTag(null, TAG_HASHTABLE);
            this.saveHashtable(serializer, (Hashtable)object);
            serializer.endTag(null, TAG_HASHTABLE);
        } else if (object instanceof Vector) {
            serializer.startTag(null, TAG_VECTOR);
            this.saveVector(serializer, (Vector)object);
            serializer.endTag(null, TAG_VECTOR);
        } else if (object instanceof Object[]) {
            serializer.startTag(null, TAG_ARRAY);
            this.saveArray(serializer, (Object[])object);
            serializer.endTag(null, TAG_ARRAY);
        } else {
            String tagName = XMLUtil.getObjectType(object);
            serializer.startTag(null, tagName);
            serializer.attribute(null, "value", String.valueOf(object));
            serializer.endTag(null, tagName);
        }
    }

    protected static String getObjectType(Object object) throws IOException {
        String tagName;
        if (object == null) {
            tagName = TAG_NULL;
        } else if (object instanceof String) {
            tagName = TAG_STRING;
        } else if (object instanceof Integer) {
            tagName = TAG_INTEGER;
        } else if (object instanceof Character) {
            tagName = TAG_CHARACTER;
        } else if (object instanceof Double) {
            tagName = TAG_DOUBLE;
        } else if (object instanceof Float) {
            tagName = TAG_FLOAT;
        } else if (object instanceof Boolean) {
            tagName = TAG_BOOLEAN;
        } else if (object instanceof Byte) {
            tagName = TAG_BYTE;
        } else if (object instanceof Short) {
            tagName = TAG_SHORT;
        } else if (object instanceof Long) {
            tagName = TAG_LONG;
        } else {
            Logger.warn("unknown object: " + object.getClass());
            String tagName2 = object.getClass().getName();
            throw new IOException();
        }
        return tagName;
    }

    protected Vector readVector(KXmlParser parser) throws Exception {
        Vector<Object> vector = new Vector<Object>();
        while (parser.nextTag() != 3) {
            Object object = this.readObject(parser);
            vector.addElement(object);
        }
        return vector;
    }

    protected Hashtable readHashtable(KXmlParser parser) throws Exception {
        Hashtable<Object, Object> map = new Hashtable<Object, Object>();
        int count = parser.getAttributeCount();
        for (int c = 0; c < count; ++c) {
            String key = parser.getAttributeName(c);
            String value = parser.getAttributeValue(c);
            map.put(key, value);
        }
        while (parser.nextTag() != 3) {
            Object key = null;
            Object value = null;
            int a = 0;
            while (parser.nextTag() != 3) {
                Object obj = this.readObject(parser);
                if (a == 0) {
                    key = obj;
                } else if (a == 1) {
                    value = obj;
                } else {
                    throw new RuntimeException();
                }
                ++a;
            }
            map.put(key, value);
        }
        return map;
    }

    protected Object readObject(KXmlParser parser) throws Exception {
        String name = parser.getName();
        if (TAG_VECTOR.equals(name)) {
            return this.readVector(parser);
        }
        if (TAG_ARRAY.equals(name)) {
            Vector vector = this.readVector(parser);
            Object[] array = new Object[vector.size()];
            vector.copyInto(array);
            return array;
        }
        if (TAG_HASHTABLE.equals(name) || "HashMap".equals(name)) {
            return this.readHashtable(parser);
        }
        String value = parser.getAttributeValue(null, "value");
        parser.skipSubTree();
        if (TAG_STRING.equals(name)) {
            return value;
        }
        if (TAG_INTEGER.equals(name)) {
            return Integer.valueOf(value);
        }
        if (TAG_DOUBLE.equals(name)) {
            return Double.valueOf(value);
        }
        if (TAG_FLOAT.equals(name)) {
            return Float.valueOf(value);
        }
        if (TAG_BOOLEAN.equals(name)) {
            return "true".equals(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (TAG_SHORT.equals(name)) {
            return new Short(Short.parseShort(value));
        }
        if (TAG_LONG.equals(name)) {
            return new Long(Long.parseLong(value));
        }
        if (TAG_CHARACTER.equals(name)) {
            return new Character(value.charAt(0));
        }
        if (TAG_BYTE.equals(name)) {
            return new Byte(Byte.parseByte(value));
        }
        if (TAG_NULL.equals(name)) {
            return null;
        }
        Logger.warn("unknown object: " + name);
        throw new IOException();
    }
}

