/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.logging;

import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.layout.FlowLayout;
import net.yura.mobile.logging.Logger;

public class DesktopLogger
extends Logger {
    private final int level;
    private Frame debugwindow;
    private TextArea text;
    private final Object uilock = new Object();

    public DesktopLogger(int desktopLevel) {
        this.level = desktopLevel;
        DesktopLogger.setLevel(4);
        DesktopLogger.setLevel(3);
        DesktopLogger.setLevel(2);
        DesktopLogger.setLevel(1);
        DesktopLogger.setLevel(0);
    }

    public void init() {
        this.debugwindow = new Frame("Debug");
        this.debugwindow.setName("Dialog");
        this.text = new TextArea();
        this.text.setFocusable(false);
        this.text.setLineWrap(true);
        Button close = new Button("Close");
        close.setActionCommand("close");
        close.addActionListener(this.debugwindow.getTitlePane());
        close.setMnemonic(-11);
        Panel p = new Panel(new FlowLayout());
        p.add(close);
        this.text.setFont(Font.getDefaultSystemFont());
        this.text.setForeground(-16777216);
        this.text.setBackground(-1);
        this.debugwindow.getContentPane().add(new ScrollPane(this.text));
        this.debugwindow.getContentPane().add((Component)p, 32);
        this.debugwindow.setBounds(10, 10, DesktopPane.getDesktopPane().getWidth() - 20, DesktopPane.getDesktopPane().getHeight() / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(String message, int level) {
        block8: {
            super.log(message, level);
            try {
                if (level < this.level) break block8;
                Object object = this.uilock;
                synchronized (object) {
                    if (this.debugwindow == null) {
                        this.init();
                    }
                    this.text.append(this.toString(level) + message + "\n");
                    if (!this.debugwindow.isVisible()) {
                        this.debugwindow.setVisible(true);
                    } else {
                        this.debugwindow.repaint();
                    }
                }
            }
            catch (Throwable th) {
                Logger.error(th);
            }
        }
    }
}

