/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.logging;

import java.io.PrintStream;

public class Logger {
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    public static final int FATAL = 4;
    private static final String[] LEVEL_NAMES = new String[]{"DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private static Logger logger = new Logger();
    private static int level;

    protected Logger() {
        level = 4;
        level = 3;
        level = 2;
        level = 1;
        level = 0;
    }

    public static void setLogger(Logger logger) {
        Logger.logger = logger;
    }

    public static void setLevel(int level) {
        Logger.level = level;
    }

    public static void debug(String message) {
        if (level <= 0) {
            logger.log(message, 0);
        }
    }

    public static void debug(Throwable exception) {
        if (level <= 0) {
            logger.log(exception, 0);
        }
    }

    public static void info(String message) {
        if (level <= 1) {
            logger.log(message, 1);
        }
    }

    public static void info(Throwable exception) {
        if (level <= 1) {
            logger.log(exception, 1);
        }
    }

    public static void warn(String message) {
        if (level <= 2) {
            logger.log(message, 2);
        }
    }

    public static void warn(Throwable exception) {
        if (level <= 2) {
            logger.log(exception, 2);
        }
    }

    public static void warn(boolean assertion) {
        if (level <= 2 && assertion) {
            throw new IllegalArgumentException("Assertion failed");
        }
    }

    public static void error(String message) {
        if (level <= 3) {
            logger.log(message, 3);
        }
    }

    public static void error(Throwable throwable) {
        if (level <= 3) {
            logger.log(throwable, 3);
        }
    }

    public static void dumpStack() {
        try {
            throw new Exception("Stack trace");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected String toString(int level) {
        return "[" + LEVEL_NAMES[level] + "] ";
    }

    protected synchronized void log(String message, int level) {
        PrintStream out = level < 2 ? System.out : System.err;
        out.println(this.toString(level) + message);
    }

    protected synchronized void log(Throwable throwable, int level) {
        System.err.println(this.toString(level) + " " + throwable);
        throwable.printStackTrace();
    }
}

