/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskIO;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.MapTranslator;

public class RiskUtil {
    public static final String RISK_VERSION_URL;
    public static final String RISK_LOBBY_URL;
    public static final String GAME_NAME;
    public static RiskIO streamOpener;
    private static final Properties settings;
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final int LIGHT_GRAY = -4144960;
    public static final int GRAY = -8355712;
    public static final int DARK_GRAY = -12566464;
    public static final int RED = -65536;
    public static final int PINK = -20561;
    public static final int ORANGE = -14336;
    public static final int YELLOW = -256;
    public static final int GREEN = -16711936;
    public static final int MAGENTA = -65281;
    public static final int CYAN = -16711681;
    public static final int BLUE = -16776961;
    static HashMap intToString;
    static HashMap stringToInt;

    public static InputStream openMapStream(String a) throws IOException {
        return streamOpener.openMapStream(a);
    }

    public static InputStream openStream(String a) throws IOException {
        return streamOpener.openStream(a);
    }

    public static ResourceBundle getResourceBundle(Class c, String n, Locale l) {
        return streamOpener.getResourceBundle(c, n, l);
    }

    public static void openURL(URL url) throws Exception {
        streamOpener.openURL(url);
    }

    public static void openDocs(String docs) throws Exception {
        streamOpener.openDocs(docs);
    }

    public static void saveFile(String file, RiskGame aThis) throws Exception {
        streamOpener.saveGameFile(file, aThis);
    }

    public static InputStream getLoadFileInputStream(String file) throws Exception {
        return streamOpener.loadGameFile(file);
    }

    public static void printStackTrace(Throwable ex) {
        Logger.getLogger(RiskUtil.class.getName()).log(Level.WARNING, null, ex);
    }

    static void add(int color, String name) {
        Integer c = new Integer(color);
        intToString.put(c, name);
        stringToInt.put(name, c);
    }

    public static String getStringForColor(int c) {
        String result = (String)intToString.get(new Integer(c));
        if (result != null) {
            return result;
        }
        return RiskUtil.getHexForColor(c);
    }

    public static int getColor(String nm) {
        Integer color = (Integer)stringToInt.get(nm);
        if (color != null) {
            return color;
        }
        try {
            Integer result = Integer.decode(nm);
            return 0xFF000000 | result;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static int getTextColorFor(int c) {
        int r = RiskUtil.getRed(c);
        int g = RiskUtil.getGreen(c);
        if (r > 240 || g > 240 || r > 150 && g > 150) {
            return -16777216;
        }
        return -1;
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb >> 0 & 0xFF;
    }

    public static int getAlpha(int rgb) {
        return rgb >> 24 & 0xFF;
    }

    public static String getHexForColor(int c) {
        return "#" + Integer.toHexString(c & 0xFFFFFF | 0x1000000).substring(1);
    }

    public static void donate() throws Exception {
        RiskUtil.openURL(new URL("http://domination.sourceforge.net/donate.shtml"));
    }

    public static void donatePayPal() throws Exception {
        RiskUtil.openURL(new URL("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=yura%40yura%2enet&item_name=" + GAME_NAME + "%20Donation&no_shipping=0&no_note=1&tax=0&currency_code=GBP&lc=GB&bn=PP%2dDonationsBF&charset=UTF%2d8"));
    }

    public static void loadPlayers(Risk risk, Class uiclass) {
        Preferences prefs = null;
        try {
            prefs = Preferences.userNodeForPackage(uiclass);
        }
        catch (Throwable th) {
            // empty catch block
        }
        for (int cc = 1; cc <= 6; ++cc) {
            String nameKey = "default.player" + cc + ".name";
            String colorKey = "default.player" + cc + ".color";
            String typeKey = "default.player" + cc + ".type";
            String name = risk.getRiskConfig(nameKey);
            String color = risk.getRiskConfig(colorKey);
            String type = risk.getRiskConfig(typeKey);
            if (prefs != null) {
                name = prefs.get(nameKey, name);
                color = prefs.get(colorKey, color);
                type = prefs.get(typeKey, type);
            }
            if ("".equals(name) || "".equals(color) || "".equals(type)) continue;
            risk.parser("newplayer " + type + " " + color + " " + name);
        }
    }

    public static void savePlayers(Risk risk, Class uiclass) {
        Preferences prefs = null;
        try {
            prefs = Preferences.userNodeForPackage(uiclass);
        }
        catch (Throwable th) {
            // empty catch block
        }
        if (prefs != null) {
            Vector players = risk.getGame().getPlayers();
            for (int cc = 1; cc <= 6; ++cc) {
                String nameKey = "default.player" + cc + ".name";
                String colorKey = "default.player" + cc + ".color";
                String typeKey = "default.player" + cc + ".type";
                Player player = cc <= players.size() ? (Player)players.elementAt(cc - 1) : null;
                String name = "";
                String color = "";
                String type = "";
                if (player != null) {
                    name = player.getName();
                    color = RiskUtil.getStringForColor(player.getColor());
                    type = Risk.getType(player.getType());
                }
                prefs.put(nameKey, name);
                prefs.put(colorKey, color);
                prefs.put(typeKey, type);
            }
            try {
                prefs.flush();
            }
            catch (Exception ex) {
                RiskUtil.printStackTrace(ex);
            }
        }
    }

    public static BufferedReader readMap(InputStream in) throws IOException {
        PushbackInputStream pushback = new PushbackInputStream(in, 3);
        int first = pushback.read();
        if (first == 239) {
            int second = pushback.read();
            if (second == 187) {
                int third = pushback.read();
                if (third == 191) {
                    return new BufferedReader(new InputStreamReader((InputStream)pushback, "UTF-8"));
                }
                pushback.unread(third);
            }
            pushback.unread(second);
        }
        pushback.unread(first);
        return new BufferedReader(new InputStreamReader((InputStream)pushback, "ISO-8859-1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable loadInfo(String fileName, boolean cards) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        int c = 0;
        while (true) {
            BufferedReader bufferin = null;
            try {
                bufferin = RiskUtil.readMap(RiskUtil.openMapStream(fileName));
                Vector<String> misss = null;
                if (cards) {
                    MapTranslator.setCards(fileName);
                    misss = new Vector<String>();
                }
                String input = bufferin.readLine();
                String mode = null;
                while (input != null) {
                    if (!input.equals("")) {
                        if (input.charAt(0) == ';') {
                            String comment = (String)info.get("comment");
                            String com = input.substring(1).trim();
                            comment = comment == null ? com : comment + "\n" + com;
                            info.put("comment", comment);
                        } else {
                            if (input.charAt(0) == '[' && input.charAt(input.length() - 1) == ']') {
                                mode = "newsection";
                            }
                            if ("files".equals(mode)) {
                                int space = input.indexOf(32);
                                String fm = input.substring(0, space);
                                String val = input.substring(space + 1);
                                info.put(fm, val);
                            } else {
                                if ("continents".equals(mode)) break;
                                if ("missions".equals(mode)) {
                                    StringTokenizer st = new StringTokenizer(input);
                                    String description = MapTranslator.getTranslatedMissionName(st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken());
                                    if (description == null) {
                                        StringBuffer d = new StringBuffer();
                                        while (st.hasMoreElements()) {
                                            d.append(st.nextToken());
                                            d.append(" ");
                                        }
                                        description = d.toString();
                                    }
                                    misss.add(description);
                                } else if ("newsection".equals(mode)) {
                                    mode = input.substring(1, input.length() - 1);
                                } else if (mode == null && input.indexOf(32) > 0) {
                                    info.put(input.substring(0, input.indexOf(32)), input.substring(input.indexOf(32) + 1));
                                }
                            }
                        }
                    }
                    input = bufferin.readLine();
                }
                if (!cards) break;
                info.put("missions", misss.toArray(new String[misss.size()]));
                misss = null;
                break;
            }
            catch (IOException ex) {
                System.out.println("Error trying to load: " + fileName);
                RiskUtil.printStackTrace(ex);
                if (c >= 5) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ex2) {}
            }
            finally {
                if (bufferin != null) {
                    try {
                        bufferin.close();
                    }
                    catch (Exception ex2) {}
                }
            }
            ++c;
        }
        return info;
    }

    public static OutputStream getOutputStream(File dir, String fileName) throws Exception {
        File outFile = new File(dir, fileName);
        File parent = outFile.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new RuntimeException("can not create dir " + parent);
        }
        return new FileOutputStream(outFile);
    }

    public static void rename(File oldFile, File newFile) {
        if (newFile.exists() && !newFile.delete()) {
            throw new RuntimeException("can not del dest file: " + newFile);
        }
        if (!oldFile.renameTo(newFile)) {
            try {
                RiskUtil.copy(oldFile, newFile);
                if (!oldFile.delete()) {
                    System.err.println("can not del source file: " + oldFile);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("rename failed: from: " + oldFile + " to: " + newFile, ex);
            }
        }
    }

    public static String replaceAll(String string, String notregex, String replacement) {
        return string.replaceAll(RiskUtil.quote(notregex), RiskUtil.quoteReplacement(replacement));
    }

    public static String quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void copy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdir();
                System.out.println("Directory copied from " + src + "  to " + dest);
            }
            String[] files = src.list();
            for (int c = 0; c < files.length; ++c) {
                File srcFile = new File(src, files[c]);
                File destFile = new File(dest, files[c]);
                RiskUtil.copy(srcFile, destFile);
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            System.out.println("File copied from " + src + " to " + dest);
        }
    }

    static {
        settings = new Properties();
        try {
            settings.load(RiskUtil.class.getResourceAsStream("settings.ini"));
        }
        catch (Exception ex) {
            throw new RuntimeException("can not find settings.ini file!", ex);
        }
        RISK_VERSION_URL = settings.getProperty("VERSION_URL");
        RISK_LOBBY_URL = settings.getProperty("LOBBY_URL");
        GAME_NAME = settings.getProperty("name");
        Risk.RISK_VERSION = settings.getProperty("version");
        String dmap = settings.getProperty("defaultmap");
        String dcards = settings.getProperty("defaultcards");
        RiskGame.setDefaultMapAndCards(dmap, dcards);
        intToString = new HashMap();
        stringToInt = new HashMap();
        RiskUtil.add(-16777216, "black");
        RiskUtil.add(-16776961, "blue");
        RiskUtil.add(-16711681, "cyan");
        RiskUtil.add(-12566464, "darkgray");
        RiskUtil.add(-8355712, "gray");
        RiskUtil.add(-16711936, "green");
        RiskUtil.add(-4144960, "lightgray");
        RiskUtil.add(-65281, "magenta");
        RiskUtil.add(-14336, "orange");
        RiskUtil.add(-20561, "pink");
        RiskUtil.add(-65536, "red");
        RiskUtil.add(-1, "white");
        RiskUtil.add(-256, "yellow");
    }
}

