/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.ai;

import java.util.Vector;
import net.yura.domination.engine.ai.AICrap;
import net.yura.domination.engine.core.Country;

public class AIEasy
extends AICrap {
    public String getPlaceArmies() {
        if (!this.game.NoEmptyCountries()) {
            return "autoplace";
        }
        Vector t = this.player.getTerritoriesOwned();
        String name = null;
        name = this.findAttackableTerritory(this.player);
        if (name == null) {
            return "placearmies " + ((Country)t.elementAt(0)).getColor() + " " + this.player.getExtraArmies();
        }
        if (this.game.getSetup()) {
            return "placearmies " + name + " " + this.player.getExtraArmies();
        }
        return "placearmies " + name + " 1";
    }

    public String getAttack() {
        Vector outputs = new Vector();
        outputs = this.findAttackableNeighbors(this.player.getTerritoriesOwned(), 0.0);
        if (outputs.size() > 0) {
            Attack move = (Attack)outputs.elementAt((int)Math.round(Math.random() * (double)(outputs.size() - 1)));
            return move.toString();
        }
        return "endattack";
    }

    public String getRoll() {
        int n = this.game.getAttacker().getArmies() - 1;
        if (n > 3) {
            return "roll 3";
        }
        return "roll " + n;
    }

    public Vector findAttackableNeighbors(Vector t, double ratio) {
        Vector<Attack> output = new Vector<Attack>();
        Vector n = new Vector();
        if (ratio < 0.0) {
            ratio = 0.0;
        }
        for (int a = 0; a < t.size(); ++a) {
            Country source = (Country)t.elementAt(a);
            if (source.getOwner() != this.player || source.getArmies() <= 1) continue;
            n = source.getNeighbours();
            for (int b = 0; b < n.size(); ++b) {
                Country target = (Country)n.elementAt(b);
                if (target.getOwner() == this.player || !((double)(source.getArmies() / target.getArmies()) > ratio)) continue;
                output.add(new Attack(source, target));
            }
        }
        return output;
    }

    public Vector getPossibleAttacks(Vector t) {
        Vector<Attack> output = new Vector<Attack>();
        Vector n = new Vector();
        for (int a = 0; a < t.size(); ++a) {
            Country source = (Country)t.elementAt(a);
            if (source.getOwner() != this.player || source.getArmies() <= 1) continue;
            n = source.getNeighbours();
            for (int b = 0; b < n.size(); ++b) {
                Country target = (Country)n.elementAt(b);
                if (target.getOwner() == this.player) continue;
                output.add(new Attack(source, target));
            }
        }
        return output;
    }

    public Vector filterAttacks(Vector options, int advantage) {
        Attack temp = null;
        Vector<Attack> moves = new Vector<Attack>();
        for (int j = 0; j < options.size(); ++j) {
            temp = (Attack)options.get(j);
            if (temp.source.getArmies() - temp.destination.getArmies() <= advantage) continue;
            moves.add(temp);
        }
        return moves;
    }

    protected class Attack {
        Country source;
        Country destination;

        public Attack(Country s, Country d) {
            this.source = s;
            this.destination = d;
        }

        public String toString() {
            if (this.source == null || this.destination == null) {
                return "";
            }
            return "attack " + this.source.getColor() + " " + this.destination.getColor();
        }
    }
}

