/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.ai;

import net.yura.domination.engine.Risk;
import net.yura.domination.engine.ai.AICrap;
import net.yura.domination.engine.ai.AIEasy;
import net.yura.domination.engine.ai.AIHard;
import net.yura.domination.engine.ai.AIHardCapital;
import net.yura.domination.engine.ai.AIHardMission;
import net.yura.domination.engine.core.RiskGame;

public class AIPlayer {
    public static AICrap aicrap = new AICrap();
    private static AIEasy aieasy = new AIEasy();
    private static AIEasy aihard = new AIHard();
    private static AIEasy aihardc = new AIHardCapital();
    private static AIEasy aihardm = new AIHardMission();
    private static int wait = 500;

    public static int getWait() {
        return wait;
    }

    public static void setWait(int w) {
        wait = w;
    }

    public static void play(Risk risk) {
        RiskGame game = risk.getGame();
        int skill = game.getCurrentPlayer().getType();
        AICrap usethisAI = null;
        if (skill == 3) {
            usethisAI = aicrap;
        } else if (skill == 1) {
            usethisAI = aieasy;
        } else if (skill == 2) {
            int mode = game.getGameMode();
            if (mode == 0) {
                usethisAI = aihard;
            } else if (mode == 2) {
                usethisAI = aihardc;
            } else if (mode == 3) {
                usethisAI = aihardm;
            }
        }
        String output = AIPlayer.getOutput(game, usethisAI);
        try {
            Thread.sleep(wait);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        risk.parser(output);
    }

    public static String getOutput(RiskGame game, AICrap usethisAI) {
        usethisAI.game = game;
        usethisAI.player = game.getCurrentPlayer();
        String output = null;
        switch (game.getState()) {
            case 1: {
                output = usethisAI.getTrade();
                break;
            }
            case 2: {
                output = usethisAI.getPlaceArmies();
                break;
            }
            case 3: {
                output = usethisAI.getAttack();
                break;
            }
            case 4: {
                output = usethisAI.getRoll();
                break;
            }
            case 5: {
                output = usethisAI.getBattleWon();
                break;
            }
            case 6: {
                output = usethisAI.getTacMove();
                break;
            }
            case 9: {
                output = usethisAI.getCapital();
                break;
            }
            case 7: {
                output = "endgo";
                break;
            }
            case 8: {
                break;
            }
            case 10: {
                output = usethisAI.getAutoDefendString();
                break;
            }
            default: {
                throw new RuntimeException("AI error: unknown state " + game.getState());
            }
        }
        if (output == null) {
            throw new NullPointerException("AI ERROR!");
        }
        return output;
    }
}

