/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.mini;

import net.yura.domination.lobby.mini.MiniLobbyClient;
import net.yura.lobby.model.Game;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.cellrenderer.DefaultListCellRenderer;
import net.yura.mobile.gui.components.Component;

public class GameRenderer
extends DefaultListCellRenderer {
    MiniLobbyClient lobby;
    Game game;

    public GameRenderer(MiniLobbyClient l) {
        this.lobby = l;
    }

    public Component getListCellRendererComponent(Component list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.game = (Game)value;
        this.setIcon(this.lobby.getIconForGame(this.game));
        return c;
    }

    public void paintComponent(Graphics2D g) {
        String action;
        super.paintComponent(g);
        g.setColor(this.getForeground());
        Font font = g.getFont();
        switch (this.game.getState(this.lobby.whoAmI())) {
            case 1: {
                action = "Join";
                break;
            }
            case 2: {
                action = "Leave";
                break;
            }
            case 4: {
                action = "Play";
                break;
            }
            case 3: {
                action = "Watch";
                break;
            }
            default: {
                action = null;
            }
        }
        if (action != null) {
            g.drawString(action, this.getWidth() - font.getWidth(action), (this.getHeight() - font.getHeight()) / 2);
        }
    }
}

