/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mapstore.Category;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapChooser;
import net.yura.mobile.gui.Animation;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.cellrenderer.DefaultListCellRenderer;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.ProgressBar;

public class MapRenderer
extends DefaultListCellRenderer {
    String line2;
    private ProgressBar bar = new ProgressBar();
    private Component list;
    private String context;
    Image play;
    Image download;
    Icon loading;
    MapChooser chooser;
    Map map;

    public MapRenderer(MapChooser chooser) {
        this.chooser = chooser;
        this.setName("ListRendererCollapsed");
        Sprite spin1 = MapRenderer.getSprite("/ms_strip.png", 8, 1);
        this.bar.setSprite(spin1);
        this.bar.workoutPreferredSize();
        this.play = Midlet.createImage((String)"/ms_play.png");
        this.download = Midlet.createImage((String)"/ms_download.png");
        this.loading = new Icon("/ms_icon_loading.png");
    }

    public static Sprite getSprite(String name, int cols, int rows) {
        Image img = Midlet.createImage((String)name);
        int w = img.getWidth() / cols;
        int h = img.getHeight() / rows;
        if (img.getWidth() % w != 0 || img.getHeight() % h != 0) {
            img = Image.createImage((Image)img, (int)0, (int)0, (int)(w * cols), (int)(h * rows), (int)0);
        }
        return new Sprite(img, w, h);
    }

    public void animate() {
        this.bar.animate();
        if (this.list != null) {
            this.list.repaint();
        }
    }

    public void setContext(String c) {
        this.context = c;
    }

    public String getContext() {
        return this.context;
    }

    public Component getListCellRendererComponent(Component list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.setVerticalTextPosition(16);
        this.list = list;
        this.line2 = null;
        this.map = null;
        String iconUrl = null;
        if (value instanceof Category) {
            Category category = (Category)value;
            this.setText(category.getName());
            this.setVerticalTextPosition(2);
            iconUrl = category.getIconURL();
        } else if (value instanceof Map) {
            String description;
            this.map = (Map)value;
            this.setText(this.map.getName());
            String author = this.map.getAuthorName();
            if (author != null && !"".equals(author)) {
                this.line2 = TranslationBundle.getBundle().getString("mapchooser.by").replaceAll("\\{0\\}", author);
            }
            if ((description = this.map.getDescription()) != null && !"".equals(description)) {
                this.line2 = (this.line2 == null ? "" : this.line2 + "\n") + description;
            }
            iconUrl = this.map.getPreviewUrl();
        }
        if (iconUrl != null) {
            this.setIcon(this.chooser.getIcon(value, this.context, iconUrl, this.loading.getIconWidth(), this.loading.getIconHeight()));
        } else {
            System.out.println("[MapRenderer] No PreviewUrl for map or category: " + value);
        }
        return c;
    }

    public void paintComponent(Graphics2D g) {
        Icon icon = this.getIcon();
        if (icon == null || icon.getImage() == null) {
            this.setIcon(this.loading);
        }
        super.paintComponent(g);
        if (this.line2 != null) {
            Icon i = this.getIcon();
            int state = this.getCurrentState();
            if ((state & 4) == 0 && (state & 8) == 0) {
                int color = this.theme.getForeground(2);
                g.setColor(color);
            }
            g.drawString(this.line2, this.padding + (i != null ? i.getIconWidth() + this.gap : 0), this.padding + this.getFont().getHeight() + this.gap);
        }
        if (this.map != null) {
            int gap = 5;
            String mapUID = MapChooser.getFileUID(this.map.getMapUrl());
            if (this.chooser.client.isDownloading(mapUID)) {
                int x = this.getWidth() - this.bar.getWidth() - gap;
                int y = gap;
                g.translate(x, y);
                this.bar.paintComponent(g);
                g.translate(-x, -y);
                Animation.registerAnimated((Component)this);
            } else if (this.chooser.willDownload(this.map)) {
                g.drawImage(this.download, this.getWidth() - this.download.getWidth() - gap, gap);
            } else {
                g.drawImage(this.play, this.getWidth() - this.play.getWidth() - gap, gap);
            }
        }
        this.setIcon(icon);
    }

    public void workoutMinimumSize() {
        super.workoutMinimumSize();
        if (this.line2 != null && this.getIcon() == null) {
            this.height = this.height + this.getFont().getHeight() + this.gap;
        }
    }
}

