/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.gen.XMLMapAccess;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.io.ServiceLink;
import net.yura.mobile.util.Url;

public class MapUpdateService
extends Observable {
    static final Logger logger = Logger.getLogger(MapUpdateService.class.getName());
    static MapUpdateService updateService;
    Vector mapsToUpdate = new Vector();

    private MapUpdateService() {
    }

    public static MapUpdateService getInstance() {
        if (updateService == null) {
            updateService = new MapUpdateService();
        }
        return updateService;
    }

    void notifyListeners() {
        this.setChanged();
        this.notifyObservers(new Integer(this.mapsToUpdate.size()));
    }

    public synchronized void addObserver(Observer o) {
        super.addObserver(o);
        o.update(this, new Integer(this.mapsToUpdate.size()));
    }

    public void init(Vector mapsUIDs, String url) {
        Vector<Map> maps = new Vector<Map>();
        for (int c = 0; c < mapsUIDs.size(); ++c) {
            String uid = (String)mapsUIDs.elementAt(c);
            Map map = MapChooser.createMap(uid);
            maps.add(map);
            url = url + (url.indexOf(63) < 0 ? (char)'?' : '&') + Url.encode((String)"mapfile") + "=" + Url.encode((String)uid);
        }
        System.out.println("URL " + url);
        try {
            ServiceLink.Task task = (ServiceLink.Task)new XMLMapAccess().load(new InputStreamReader(new URL(url).openStream(), "UTF-8"));
            this.gotResultXML(url, task, maps);
        }
        catch (Throwable ex) {
            logger.log(Level.INFO, "error in getting map versions", ex);
        }
    }

    public void gotResultXML(String url, ServiceLink.Task task, Vector maps) {
        Hashtable map = (Hashtable)task.getObject();
        Vector gotMaps = (Vector)map.get("maps");
        for (int c = 0; c < maps.size(); ++c) {
            Map themap;
            String ver;
            Map localMap = (Map)maps.elementAt(c);
            ArrayList<Map> theMaps = new ArrayList<Map>(1);
            for (int i = 0; i < gotMaps.size(); ++i) {
                Map themap2 = (Map)gotMaps.elementAt(i);
                String mapUID = MapChooser.getFileUID(themap2.getMapUrl());
                if (!mapUID.equals(localMap.getMapUrl())) continue;
                theMaps.add(themap2);
            }
            if (theMaps.size() != 1 || (ver = (themap = (Map)theMaps.get(0)).getVersion()) == null || "".equals(ver) || "1".equals(ver) || ver.equals(localMap.getVersion())) continue;
            this.mapsToUpdate.add(themap);
            this.notifyListeners();
        }
    }

    public void downloadFinished(String mapUID) {
        for (int c = 0; c < this.mapsToUpdate.size(); ++c) {
            Map map = (Map)this.mapsToUpdate.elementAt(c);
            String amapUID = MapChooser.getFileUID(map.getMapUrl());
            if (!mapUID.equals(amapUID)) continue;
            this.mapsToUpdate.removeElementAt(c);
            this.notifyListeners();
            return;
        }
    }

    public static void paintBadge(Graphics2D g, String badge, Border border) {
        if (!"0".equals(badge)) {
            int l;
            int r;
            int t;
            int b;
            Font font = g.getFont();
            int tw = font.getWidth(badge.length() == 1 ? " " + badge : badge);
            int th = font.getHeight();
            if (border == null) {
                b = 3;
                t = 3;
                r = 3;
                l = 3;
            } else {
                l = border.getLeft();
                r = border.getRight();
                t = border.getTop();
                b = border.getBottom();
            }
            int w = l + r + tw;
            int h = t + b + th;
            int x = -w;
            int y = 0;
            int[] clip = g.getClip();
            g.setClip(x, y, w, h);
            if (border == null) {
                g.setColor(-65536);
                g.fillOval(x, y, w, h);
            } else {
                g.translate(x + border.getLeft(), y + border.getTop());
                border.paintBorder(null, g, w - border.getLeft() - border.getRight(), h - border.getTop() - border.getBottom());
                g.translate(-x - border.getLeft(), -y - border.getTop());
            }
            g.setColor(-1);
            g.drawString(badge, 1 + x + (w - font.getWidth(badge)) / 2, 1 + y + (h - font.getHeight()) / 2);
            g.setClip(clip);
        }
    }
}

