/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.flashgui.GameFrame;

public class BattleDialog
extends JDialog
implements MouseListener {
    private GameFrame gui;
    private Risk myrisk;
    private BufferedImage c1img;
    private BufferedImage c2img;
    private int c1num;
    private int c2num;
    private BufferedImage Battle;
    private BufferedImage Back;
    private JButton button;
    private JButton retreat;
    private Country country1;
    private Country country2;
    private Color color1;
    private Color color2;
    private boolean canRetreat;
    private Timer timer;
    private int[] att;
    private int[] def;
    private int max;
    private int nod;
    private int noda;
    private int nodd;
    private BufferedImage[] attackerSpins;
    private BufferedImage[] defenderSpins;
    private ResourceBundle resb;
    private Polygon arrow;
    private JPanel battle;
    private static Random r = new Random();

    public BattleDialog(GameFrame parent, boolean modal, Risk r) {
        super((Frame)parent, modal);
        this.gui = parent;
        this.myrisk = r;
        this.setDefaultCloseOperation(0);
        this.Battle = RiskUIUtil.getUIImage(this.getClass(), "battle.jpg");
        this.Back = this.Battle.getSubimage(0, 0, 480, 350);
        int w = 29;
        int h = 29;
        this.attackerSpins = new BufferedImage[6];
        this.attackerSpins[0] = this.Battle.getSubimage(481, 43, w, h);
        this.attackerSpins[1] = this.Battle.getSubimage(481, 73, w, h);
        this.attackerSpins[2] = this.Battle.getSubimage(481, 103, w, h);
        this.attackerSpins[3] = this.Battle.getSubimage(541, 43, w, h);
        this.attackerSpins[4] = this.Battle.getSubimage(541, 73, w, h);
        this.attackerSpins[5] = this.Battle.getSubimage(541, 103, w, h);
        this.defenderSpins = new BufferedImage[6];
        this.defenderSpins[0] = this.Battle.getSubimage(511, 43, w, h);
        this.defenderSpins[1] = this.Battle.getSubimage(511, 73, w, h);
        this.defenderSpins[2] = this.Battle.getSubimage(511, 103, w, h);
        this.defenderSpins[3] = this.Battle.getSubimage(571, 43, w, h);
        this.defenderSpins[4] = this.Battle.getSubimage(571, 73, w, h);
        this.defenderSpins[5] = this.Battle.getSubimage(571, 103, w, h);
        this.initGUI();
        this.pack();
    }

    public void setup(int a, int b, BufferedImage ai, BufferedImage bi, Country country1, Country country2, Color c1, Color c2) {
        this.c1num = a;
        this.c2num = b;
        this.c1img = ai;
        this.c2img = bi;
        this.country1 = country1;
        this.country2 = country2;
        this.color1 = c1;
        this.color2 = c2;
        this.att = null;
        this.def = null;
        this.noda = 0;
        this.nodd = 0;
        this.reset();
    }

    public void reset() {
        this.button.setEnabled(false);
        this.retreat.setVisible(false);
        this.canRetreat = false;
        this.max = 0;
        this.setTitle(this.resb.getString("battle.title"));
    }

    private void initGUI() {
        this.resb = TranslationBundle.getBundle();
        this.setResizable(false);
        this.battle = new BattlePanel();
        this.battle.setLayout(null);
        this.battle.addMouseListener(this);
        Dimension bSize = new Dimension(480, 350);
        this.battle.setPreferredSize(bSize);
        this.battle.setMinimumSize(bSize);
        this.battle.setMaximumSize(bSize);
        int w = 88;
        int h = 31;
        this.button = GameFrame.makeRiskButton(this.Battle.getSubimage(196, 270, w, h), this.Battle.getSubimage(481, 270, w, h), this.Battle.getSubimage(481, 238, w, h), this.Battle.getSubimage(481, 302, w, h));
        this.button.setText(this.resb.getString("battle.roll"));
        this.button.setBounds(196, 270, 88, 31);
        this.retreat = GameFrame.makeRiskButton(this.Battle.getSubimage(487, 138, w, h), this.Battle.getSubimage(481, 206, w, h), this.Battle.getSubimage(481, 174, w, h), this.Battle.getSubimage(487, 138, w, h));
        this.retreat.setText(this.resb.getString("battle.retreat"));
        this.retreat.setBounds(342, 270, 88, 31);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BattleDialog.this.gui.go("roll " + BattleDialog.this.nod);
            }
        });
        this.retreat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BattleDialog.this.gui.go("retreat");
            }
        });
        this.battle.add(this.retreat);
        this.battle.add(this.button);
        this.getContentPane().add(this.battle);
        this.timer = new Timer(10, this.spinDiceAction());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (BattleDialog.this.canRetreat) {
                    BattleDialog.this.gui.go("retreat");
                }
            }
        });
        int x = 110;
        int y = 40;
        int[] xaCoords = new int[]{x + 60, x + 130, x + 130, x + 200, x + 130, x + 130, x + 60};
        int[] yaCoords = new int[]{y + 40, y + 40, y + 20, y + 60, y + 100, y + 80, y + 80};
        this.arrow = new Polygon(xaCoords, yaCoords, xaCoords.length);
    }

    public void setNODAttacker(int n) {
        this.att = null;
        this.def = null;
        this.noda = n;
        this.battle.repaint();
        this.timer.start();
    }

    public void setNODDefender(int n) {
        this.nodd = n;
    }

    public void showDiceResults(int[] atti, int[] defi) {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.noda = 0;
        this.nodd = 0;
        this.att = atti;
        this.def = defi;
        this.battle.repaint();
    }

    public Action spinDiceAction() {
        return new AbstractAction("spin dice action"){

            public void actionPerformed(ActionEvent e) {
                BattleDialog.this.drawDiceAnimated(BattleDialog.this.battle.getGraphics());
            }
        };
    }

    public void drawDiceAnimated(Graphics g) {
        if (this.noda != 0) {
            g.drawImage(this.attackerSpins[r.nextInt(6)], 116, 176, this);
            if (this.noda > 1) {
                g.drawImage(this.attackerSpins[r.nextInt(6)], 116, 207, this);
            }
            if (this.noda > 2) {
                g.drawImage(this.attackerSpins[r.nextInt(6)], 116, 238, this);
            }
        }
        if (this.nodd != 0) {
            g.drawImage(this.defenderSpins[r.nextInt(6)], 335, 176, this);
            if (this.nodd > 1) {
                g.drawImage(this.defenderSpins[r.nextInt(6)], 335, 207, this);
            }
            if (this.nodd > 2) {
                g.drawImage(this.defenderSpins[r.nextInt(6)], 335, 238, this);
            }
        }
    }

    public void needInput(int n, boolean c) {
        this.button.setEnabled(true);
        this.nod = this.max = n;
        this.canRetreat = c;
        this.att = null;
        this.def = null;
        if (this.canRetreat) {
            this.retreat.setVisible(true);
            this.setTitle(this.resb.getString("battle.select.attack"));
        } else {
            this.setTitle(this.resb.getString("battle.select.defend"));
        }
        this.battle.repaint();
    }

    public void drawDice(boolean isAttacker, int result, int dx, int dy, Graphics2D g) {
        g.translate(dx, dy);
        if (isAttacker) {
            g.drawImage((Image)this.Battle.getSubimage(481, 0, 21, 21), 0, 0, this);
        } else {
            g.drawImage((Image)this.Battle.getSubimage(481, 21, 21, 21), 0, 0, this);
        }
        int size = 3;
        g.setColor(new Color(255, 255, 255, 200));
        if (result == 0) {
            g.fillOval(9, 9, size, size);
        } else if (result == 1) {
            g.fillOval(3, 3, size, size);
            g.fillOval(15, 15, size, size);
        } else if (result == 2) {
            g.fillOval(3, 3, size, size);
            g.fillOval(9, 9, size, size);
            g.fillOval(15, 15, size, size);
        } else if (result == 3) {
            g.fillOval(3, 3, size, size);
            g.fillOval(15, 3, size, size);
            g.fillOval(15, 15, size, size);
            g.fillOval(3, 15, size, size);
        } else if (result == 4) {
            g.fillOval(3, 3, size, size);
            g.fillOval(15, 3, size, size);
            g.fillOval(15, 15, size, size);
            g.fillOval(3, 15, size, size);
            g.fillOval(9, 9, size, size);
        } else if (result == 5) {
            g.fillOval(3, 3, size, size);
            g.fillOval(15, 3, size, size);
            g.fillOval(15, 15, size, size);
            g.fillOval(3, 15, size, size);
            g.fillOval(9, 3, size, size);
            g.fillOval(9, 15, size, size);
        }
        g.translate(-dx, -dy);
    }

    public int insideButton(int x, int y) {
        int W = 21;
        int H = 21;
        int B = 0;
        if (x >= 120 && x < 120 + W && y >= 180 && y < 180 + H) {
            B = 1;
        } else if (x >= 120 && x < 120 + W && y >= 211 && y < 211 + H) {
            B = 2;
        } else if (x >= 120 && x < 120 + W && y >= 242 && y < 242 + H) {
            B = 3;
        } else if (x >= 339 && x < 339 + W && y >= 180 && y < 180 + H) {
            B = 4;
        } else if (x >= 339 && x < 339 + W && y >= 211 && y < 211 + H) {
            B = 5;
        } else if (x >= 339 && x < 339 + W && y >= 232 && y < 232 + H) {
            B = 6;
        }
        return B;
    }

    public void mouseClicked(MouseEvent e) {
        int click = this.insideButton(e.getX(), e.getY());
        if (this.max != 0 && this.canRetreat) {
            if (click == 1) {
                this.nod = 1;
            }
            if (click == 2 && this.max > 1) {
                this.nod = 2;
            }
            if (click == 3 && this.max > 2) {
                this.nod = 3;
            }
        } else if (this.max != 0) {
            if (click == 4) {
                this.nod = 1;
            }
            if (click == 5 && this.max > 1) {
                this.nod = 2;
            }
            if (click == 6 && this.max > 2) {
                this.nod = 3;
            }
        }
        this.battle.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    class BattlePanel
    extends JPanel {
        BattlePanel() {
        }

        public void paintComponent(Graphics g) {
            int[] atti = BattleDialog.this.att;
            int[] defi = BattleDialog.this.def;
            g.drawImage(BattleDialog.this.Back, 0, 0, this);
            if (BattleDialog.this.canRetreat) {
                g.drawImage(BattleDialog.this.Battle.getSubimage(481, 133, 98, 40), 336, 265, this);
            }
            g.drawImage(BattleDialog.this.c1img, 130 - BattleDialog.this.c1img.getWidth() / 2, 100 - BattleDialog.this.c1img.getHeight() / 2, this);
            g.drawImage(BattleDialog.this.c2img, 350 - BattleDialog.this.c2img.getWidth() / 2, 100 - BattleDialog.this.c2img.getHeight() / 2, this);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontRenderContext frc = g2.getFontRenderContext();
            Font font = g2.getFont();
            g2.setColor(Color.black);
            TextLayout tl = new TextLayout(BattleDialog.this.country1.getName(), font, frc);
            tl.draw(g2, (float)(130.0 - tl.getBounds().getWidth() / 2.0), 40.0f);
            tl = new TextLayout(BattleDialog.this.country2.getName(), font, frc);
            tl.draw(g2, (float)(350.0 - tl.getBounds().getWidth() / 2.0), 40.0f);
            tl = new TextLayout(BattleDialog.this.resb.getString("battle.select.dice"), font, frc);
            tl.draw(g2, (float)(240.0 - tl.getBounds().getWidth() / 2.0), 320.0f);
            g2.setColor(BattleDialog.this.color1);
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            ((RectangularShape)ellipse).setFrame(120.0, 90.0, 20.0, 20.0);
            g2.fill(ellipse);
            g2.setColor(BattleDialog.this.color2);
            ellipse = new Ellipse2D.Double();
            ((RectangularShape)ellipse).setFrame(340.0, 90.0, 20.0, 20.0);
            g2.fill(ellipse);
            g2.setColor(new Color(BattleDialog.this.color1.getRed(), BattleDialog.this.color1.getGreen(), BattleDialog.this.color1.getBlue(), 150));
            g2.fillPolygon(BattleDialog.this.arrow);
            g2.setColor(RiskUIUtil.getTextColorFor(BattleDialog.this.color1));
            int noa = BattleDialog.this.myrisk.hasArmiesInt(BattleDialog.this.c1num);
            if (noa < 10) {
                g2.drawString(String.valueOf(noa), 126, 105);
            } else if (noa < 100) {
                g2.drawString(String.valueOf(noa), 123, 105);
            } else {
                g2.drawString(String.valueOf(noa), 120, 105);
            }
            g2.setColor(RiskUIUtil.getTextColorFor(BattleDialog.this.color2));
            noa = BattleDialog.this.myrisk.hasArmiesInt(BattleDialog.this.c2num);
            if (noa < 10) {
                g2.drawString(String.valueOf(noa), 346, 105);
            } else if (noa < 100) {
                g2.drawString(String.valueOf(noa), 343, 105);
            } else {
                g2.drawString(String.valueOf(noa), 340, 105);
            }
            int deadDice = BattleDialog.this.myrisk.hasArmiesInt(BattleDialog.this.c2num);
            if (deadDice > BattleDialog.this.myrisk.getGame().getMaxDefendDice()) {
                deadDice = BattleDialog.this.myrisk.getGame().getMaxDefendDice();
            }
            if (BattleDialog.this.max != 0 && BattleDialog.this.canRetreat) {
                g.drawImage(BattleDialog.this.Battle.getSubimage(481, 0, 21, 21), 120, 180, this);
                if (BattleDialog.this.nod > 1) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(481, 0, 21, 21), 120, 211, this);
                } else if (BattleDialog.this.max > 1) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(502, 0, 21, 21), 120, 211, this);
                }
                if (BattleDialog.this.nod > 2) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(481, 0, 21, 21), 120, 242, this);
                } else if (BattleDialog.this.max > 2) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(502, 0, 21, 21), 120, 242, this);
                }
                g.drawImage(BattleDialog.this.Battle.getSubimage(502, 21, 21, 21), 339, 180, this);
                if (deadDice > 1) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(502, 21, 21, 21), 339, 211, this);
                }
                if (deadDice > 2) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(502, 21, 21, 21), 339, 242, this);
                }
            } else if (BattleDialog.this.max != 0) {
                g.drawImage(BattleDialog.this.Battle.getSubimage(481, 21, 21, 21), 339, 180, this);
                if (BattleDialog.this.nod > 1) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(481, 21, 21, 21), 339, 211, this);
                } else if (BattleDialog.this.max > 1) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(502, 21, 21, 21), 339, 211, this);
                }
                if (BattleDialog.this.nod > 2) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(481, 21, 21, 21), 339, 242, this);
                } else if (BattleDialog.this.max > 2) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(502, 21, 21, 21), 339, 242, this);
                }
            } else if (BattleDialog.this.max == 0 && BattleDialog.this.nodd == 0 && atti == null && defi == null) {
                g.drawImage(BattleDialog.this.Battle.getSubimage(502, 21, 21, 21), 339, 180, this);
                if (deadDice > 1) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(502, 21, 21, 21), 339, 211, this);
                }
                if (deadDice > 2) {
                    g.drawImage(BattleDialog.this.Battle.getSubimage(502, 21, 21, 21), 339, 242, this);
                }
                if (BattleDialog.this.noda == 0) {
                    int AdeadDice = BattleDialog.this.myrisk.hasArmiesInt(BattleDialog.this.c1num) - 1;
                    g.drawImage(BattleDialog.this.Battle.getSubimage(502, 0, 21, 21), 120, 180, this);
                    if (AdeadDice > 1) {
                        g.drawImage(BattleDialog.this.Battle.getSubimage(502, 0, 21, 21), 120, 211, this);
                    }
                    if (AdeadDice > 2) {
                        g.drawImage(BattleDialog.this.Battle.getSubimage(502, 0, 21, 21), 120, 242, this);
                    }
                }
            }
            BattleDialog.this.drawDiceAnimated(g);
            if (atti != null && defi != null) {
                int[] yCoords;
                int[] xCoords;
                if (defi[0] >= atti[0]) {
                    g2.setColor(Color.blue);
                    xCoords = new int[]{339, 339, 140};
                    yCoords = new int[]{180, 200, 190};
                    g2.fillPolygon(xCoords, yCoords, xCoords.length);
                } else {
                    g2.setColor(Color.red);
                    xCoords = new int[]{140, 140, 339};
                    yCoords = new int[]{180, 200, 190};
                    g2.fillPolygon(xCoords, yCoords, xCoords.length);
                }
                if (atti.length > 1 && defi.length > 1) {
                    if (defi[1] >= atti[1]) {
                        g2.setColor(Color.blue);
                        xCoords = new int[]{339, 339, 140};
                        yCoords = new int[]{211, 231, 221};
                        g2.fillPolygon(xCoords, yCoords, xCoords.length);
                    } else {
                        g2.setColor(Color.red);
                        xCoords = new int[]{140, 140, 339};
                        yCoords = new int[]{211, 231, 221};
                        g2.fillPolygon(xCoords, yCoords, xCoords.length);
                    }
                }
                if (atti.length > 2 && defi.length > 2) {
                    if (defi[2] >= atti[2]) {
                        g2.setColor(Color.blue);
                        xCoords = new int[]{339, 339, 140};
                        yCoords = new int[]{242, 262, 252};
                        g2.fillPolygon(xCoords, yCoords, xCoords.length);
                    } else {
                        g2.setColor(Color.red);
                        xCoords = new int[]{140, 140, 339};
                        yCoords = new int[]{242, 262, 252};
                        g2.fillPolygon(xCoords, yCoords, xCoords.length);
                    }
                }
                BattleDialog.this.drawDice(true, atti[0], 120, 180, g2);
                if (atti.length > 1) {
                    BattleDialog.this.drawDice(true, atti[1], 120, 211, g2);
                }
                if (atti.length > 2) {
                    BattleDialog.this.drawDice(true, atti[2], 120, 242, g2);
                }
                BattleDialog.this.drawDice(false, defi[0], 339, 180, g2);
                if (defi.length > 1) {
                    BattleDialog.this.drawDice(false, defi[1], 339, 211, g2);
                }
                if (defi.length > 2) {
                    BattleDialog.this.drawDice(false, defi[2], 339, 242, g2);
                }
            }
        }
    }
}

