/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskListener;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.guishared.PicturePanel;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.ui.flashgui.BattleDialog;
import net.yura.domination.ui.flashgui.GameFrame;
import net.yura.domination.ui.flashgui.MainMenu;
import net.yura.domination.ui.flashgui.NewGameFrame;
import net.yura.grasshopper.PopupBug;
import net.yura.swingme.core.CoreUtil;

public class FlashRiskAdapter
implements RiskListener {
    private MainMenu menu;
    private Risk myrisk;
    protected GameFrame gameFrame;
    private NewGameFrame newgameframe;
    private BattleDialog battledialog;
    protected PicturePanel pp;
    private int nod;
    private int nogames;

    public FlashRiskAdapter(Risk r) {
        this.myrisk = r;
        this.myrisk.addRiskListener(this);
        this.pp = new PicturePanel(this.myrisk);
        this.gameFrame = new GameFrame(this.myrisk, this.pp);
        this.battledialog = new BattleDialog(this.gameFrame, false, this.myrisk);
        this.gameFrame.setBattleDialog(this.battledialog);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.battledialog.getSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        this.battledialog.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    FlashRiskAdapter(MainMenu m, Risk r) {
        this(r);
        this.menu = m;
        this.newgameframe = new NewGameFrame(this.myrisk);
        if (RiskUIUtil.checkForNoSandbox()) {
            try {
                Preferences.userRoot();
            }
            catch (Throwable th) {
                // empty catch block
            }
            try {
                PopupBug.initSimple(RiskUtil.GAME_NAME, Risk.RISK_VERSION + " FlashGUI", TranslationBundle.getBundle().getLocale().toString());
            }
            catch (Throwable th) {
                System.out.println("Grasshopper not loaded");
            }
            try {
                CoreUtil.setupLogging();
            }
            catch (Throwable th) {
                RiskUtil.printStackTrace(th);
            }
        }
    }

    public void sendMessage(String output, boolean redrawNeeded, boolean repaintNeeded) {
        try {
            if (redrawNeeded) {
                this.gameFrame.repaintCountries();
            }
            if (repaintNeeded) {
                this.gameFrame.repaint();
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void sendDebug(String a) {
        try {
            PopupBug.log(a + System.getProperty("line.separator"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void showMessageDialog(String a) {
        if (this.gameFrame != null && this.gameFrame.isVisible()) {
            JOptionPane.showMessageDialog(this.gameFrame, a);
        } else if (this.menu != null && this.menu.isVisible()) {
            JOptionPane.showMessageDialog(this.menu, a);
        } else if (this.newgameframe != null && this.newgameframe.isVisible()) {
            JOptionPane.showMessageDialog(this.newgameframe, a);
        } else {
            JOptionPane.showMessageDialog(null, a);
        }
    }

    public void setGameStatus(String state) {
        try {
            this.gameFrame.setGameStatus(state);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void needInput(int s) {
        if (this.gameFrame.isVisible()) {
            if (s == 4) {
                this.battledialog.needInput(this.nod, true);
            } else if (s == 10) {
                this.battledialog.needInput(this.nod, false);
            }
            this.gameFrame.needInput(s);
        }
    }

    public void openBattle(int c1num, int c2num) {
        BufferedImage c1img = this.gameFrame.getCountryImage(c1num);
        BufferedImage c2img = this.gameFrame.getCountryImage(c2num);
        Country country1 = this.myrisk.getGame().getCountryInt(c1num);
        Country country2 = this.myrisk.getGame().getCountryInt(c2num);
        Color color1 = new Color(this.myrisk.getCurrentPlayerColor());
        Color color2 = new Color(this.myrisk.getColorOfOwner(c2num));
        this.battledialog.setup(c1num, c2num, c1img, c2img, country1, country2, color1, color2);
        this.battledialog.setVisible(true);
    }

    public void setNODAttacker(int n) {
        if (this.battledialog.isVisible()) {
            this.battledialog.setNODAttacker(n);
        }
    }

    public void setNODDefender(int n) {
        if (this.battledialog.isVisible()) {
            this.battledialog.setNODDefender(n);
        }
    }

    public void showDiceResults(int[] att, int[] def) {
        if (this.battledialog.isVisible()) {
            this.battledialog.showDiceResults(att, def);
        }
    }

    public void closeBattle() {
        if (this.battledialog.isVisible()) {
            this.battledialog.setVisible(false);
        }
    }

    public void showDice(int n, boolean w) {
        this.nod = n;
    }

    public void armiesLeft(int l, boolean s) {
        this.gameFrame.armiesLeft(l, s);
    }

    public void newGame(boolean localGame) {
        this.menu.hideJoinDialog(localGame);
        this.newgameframe.setup(localGame);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.newgameframe.getSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        this.newgameframe.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        RiskUIUtil.findParentFrame(this.menu).setVisible(false);
        this.newgameframe.setVisible(true);
        this.newgameframe.requestFocus();
    }

    public void noInput() {
        if (this.newgameframe.isVisible()) {
            this.newgameframe.noInput();
        } else {
            this.gameFrame.noInput();
        }
    }

    public void startGame(boolean s) {
        if (this.newgameframe.isVisible()) {
            this.newgameframe.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.menu.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            this.pp.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.gameFrame.setup(s);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.gameFrame.getSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        this.gameFrame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        if (this.newgameframe.isVisible()) {
            this.newgameframe.setVisible(false);
        } else {
            RiskUIUtil.findParentFrame(this.menu).setVisible(false);
        }
        this.gameFrame.setVisible(true);
        this.battledialog.setVisible(false);
        this.gameFrame.requestFocus();
    }

    public void closeGame() {
        if (this.gameFrame.isVisible()) {
            this.pp.stopAni();
            this.gameFrame.setVisible(false);
        } else {
            this.newgameframe.setVisible(false);
        }
        ++this.nogames;
        try {
            PopupBug.clearLog();
            PopupBug.log("game " + this.nogames + " closed, log cleared" + System.getProperty("line.separator"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.newgameframe.setCursor(Cursor.getPredefinedCursor(0));
        System.gc();
        RiskUIUtil.findParentFrame(this.menu).setVisible(true);
        this.menu.requestFocus();
        this.menu.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void serverState(boolean s) {
        this.menu.setServerRunning(s);
    }

    public void showMapPic(RiskGame p) {
        ImageIcon i = null;
        try {
            i = new ImageIcon(PicturePanel.getImage(p));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.newgameframe.setMap(i);
    }

    public void showCardsFile(String c, boolean m) {
        this.newgameframe.setCards(c, m);
    }

    public void addPlayer(int type, String name, int color, String ip) {
        this.newgameframe.addPlayer(type, name, new Color(color), ip);
    }

    public void delPlayer(String name) {
        this.newgameframe.delPlayer(name);
    }

    public void setSlider(int mustMove, int c1num, int c2num) {
        this.gameFrame.openMove(mustMove, c1num, c2num, false);
    }

    public GameFrame getGameFrame() {
        return this.gameFrame;
    }
}

