/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.flashgui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.MouseInputListener;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.translation.TranslationBundle;

public class JoinDialog
extends JDialog
implements MouseInputListener {
    private Risk myrisk;
    private BufferedImage joingame;
    private JTextField serverField;
    private ResourceBundle resb;
    private int button;
    private int currentButton;
    private int pressedButton;
    private int highlightButton;

    public JoinDialog(Frame parent, boolean modal, Risk r) {
        super(parent, modal);
        this.serverField = new JTextField(r.getRiskConfig("default.host"));
        this.resb = TranslationBundle.getBundle();
        this.myrisk = r;
        this.joingame = RiskUIUtil.getUIImage(this.getClass(), "joingame.jpg");
        this.initGUI();
        this.setResizable(false);
        this.pack();
    }

    private void initGUI() {
        this.setTitle(this.resb.getString("join.title"));
        this.serverField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                JoinDialog.this.myrisk.parser("join " + JoinDialog.this.serverField.getText());
            }
        });
        Dimension d = new Dimension(350, 190);
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setPreferredSize(d);
        layeredPane.setMinimumSize(d);
        layeredPane.setMaximumSize(d);
        joinPanel join = new joinPanel();
        join.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
        join.addMouseListener(this);
        join.addMouseMotionListener(this);
        this.serverField.setBounds(149, 49, 150, 25);
        this.serverField.setBorder(null);
        this.serverField.selectAll();
        this.serverField.setOpaque(false);
        layeredPane.add((Component)this.serverField, 0);
        layeredPane.add((Component)join, 1);
        this.getContentPane().add(layeredPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JoinDialog.this.exitForm();
            }
        });
    }

    public void exitForm() {
        this.setVisible(false);
        this.dispose();
    }

    public int insideButton(int x, int y) {
        int B = 0;
        if (x >= 51 && x < 156 && y >= 101 && y < 141) {
            B = 1;
        } else if (x >= 195 && x < 300 && y >= 101 && y < 141) {
            B = 2;
        }
        return B;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.highlightButton = 0;
        this.currentButton = this.insideButton(e.getX(), e.getY());
        if (this.currentButton != 0) {
            this.pressedButton = this.currentButton;
            this.button = this.currentButton;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.pressedButton == this.currentButton) {
            if (this.button == 1) {
                this.exitForm();
            } else if (this.button == 2) {
                this.myrisk.parser("join " + this.serverField.getText());
            }
        }
        if (this.button != 0) {
            this.button = 0;
        }
        this.highlightButton = this.currentButton;
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        int oldhighlightButton = this.highlightButton;
        int newhighlightButton = this.insideButton(e.getX(), e.getY());
        if (oldhighlightButton != newhighlightButton) {
            this.highlightButton = newhighlightButton;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.currentButton = this.insideButton(e.getX(), e.getY());
        if (this.pressedButton == this.currentButton) {
            if (this.button != this.pressedButton) {
                this.button = this.pressedButton;
                this.repaint();
            }
        } else if (this.button != 0) {
            this.button = 0;
            this.repaint();
        }
    }

    class joinPanel
    extends JPanel {
        joinPanel() {
        }

        public void paintComponent(Graphics g) {
            g.drawImage(JoinDialog.this.joingame, 0, 0, 350, 190, 0, 0, 350, 190, this);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontRenderContext frc = g2.getFontRenderContext();
            Font font = g2.getFont();
            g2.setColor(Color.black);
            if (JoinDialog.this.highlightButton == 1) {
                g.drawImage(JoinDialog.this.joingame, 43, 93, 163, 148, 350, 0, 470, 55, this);
            } else if (JoinDialog.this.highlightButton == 2) {
                g.drawImage(JoinDialog.this.joingame, 187, 93, 307, 148, 350, 110, 470, 165, this);
            } else if (JoinDialog.this.button == 1) {
                g.drawImage(JoinDialog.this.joingame, 43, 93, 163, 148, 350, 55, 470, 110, this);
            } else if (JoinDialog.this.button == 2) {
                g.drawImage(JoinDialog.this.joingame, 187, 93, 307, 148, 350, 165, 470, 220, this);
            }
            TextLayout tl = new TextLayout(JoinDialog.this.resb.getString("join.servername"), font, frc);
            tl.draw(g2, (float)(100.0 - tl.getBounds().getWidth() / 2.0), 65.0f);
            tl = new TextLayout(JoinDialog.this.resb.getString("join.cancel"), font, frc);
            tl.draw(g2, (float)(103.0 - tl.getBounds().getWidth() / 2.0), 125.0f);
            tl = new TextLayout(JoinDialog.this.resb.getString("join.connect"), font, frc);
            tl.draw(g2, (float)(247.0 - tl.getBounds().getWidth() / 2.0), 125.0f);
        }
    }
}

