/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.swinggui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.ai.AIPlayer;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.guishared.PicturePanel;
import net.yura.domination.ui.flashgui.MainMenu;
import net.yura.domination.ui.swinggui.CardsDialog;
import net.yura.domination.ui.swinggui.SwingGUITab;

public class TestPanel
extends JPanel
implements ActionListener,
SwingGUITab {
    private Risk myrisk;
    private JToolBar toolbar;
    private AbstractTableModel countriesModel;
    private AbstractTableModel continentsModel;
    private AbstractTableModel cardsModel;
    private AbstractTableModel cardsModel2;
    private AbstractTableModel playersModel;
    private PicturePanel pp;

    public TestPanel(Risk r, PicturePanel p) {
        this.myrisk = r;
        this.pp = p;
        this.setName("Testing");
        this.setOpaque(false);
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        JButton refresh = new JButton("Refresh");
        refresh.setActionCommand("refresh");
        refresh.addActionListener(this);
        this.toolbar.add(refresh);
        JButton allcards = new JButton("All Cards");
        allcards.setActionCommand("allcards");
        allcards.addActionListener(this);
        this.toolbar.add(allcards);
        this.toolbar.addSeparator();
        JButton flash = new JButton("Run FlashGUI with current backend");
        flash.setActionCommand("flash");
        flash.addActionListener(this);
        this.toolbar.add(flash);
        this.toolbar.addSeparator();
        JButton changeaiwait = new JButton("Change AI wait");
        changeaiwait.setActionCommand("aiwait");
        changeaiwait.addActionListener(this);
        this.toolbar.add(changeaiwait);
        this.countriesModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"Color/No.", "ID", "Name", "Continent", "Owner", "Armies", "No. Neighbours", "x", "y"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                Country[] countries;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (countries = game.getCountries()) != null) {
                    return countries.length;
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Country country = TestPanel.this.myrisk.getGame().getCountries()[row];
                switch (col) {
                    case 0: {
                        return new Integer(country.getColor());
                    }
                    case 1: {
                        return country.getIdString();
                    }
                    case 2: {
                        return country.getName();
                    }
                    case 3: {
                        return country.getContinent();
                    }
                    case 4: {
                        return country.getOwner();
                    }
                    case 5: {
                        return new Integer(country.getArmies());
                    }
                    case 6: {
                        return new Integer(country.getNeighbours().size());
                    }
                    case 7: {
                        return new Integer(country.getX());
                    }
                    case 8: {
                        return new Integer(country.getY());
                    }
                }
                throw new RuntimeException();
            }
        };
        this.continentsModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"No.", "ID", "Name", "Army Value", "No. Countries", "Color"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                Continent[] continents;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (continents = game.getContinents()) != null) {
                    return continents.length;
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Continent continent = TestPanel.this.myrisk.getGame().getContinents()[row];
                switch (col) {
                    case 0: {
                        return new Integer(row + 1);
                    }
                    case 1: {
                        return continent.getIdString();
                    }
                    case 2: {
                        return continent.getName();
                    }
                    case 3: {
                        return new Integer(continent.getArmyValue());
                    }
                    case 4: {
                        return new Integer(continent.getTerritoriesContained().size());
                    }
                    case 5: {
                        return RiskUtil.getStringForColor(continent.getColor());
                    }
                }
                throw new RuntimeException();
            }
        };
        this.cardsModel = new CardsTableModel(){

            List getCards() {
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null) {
                    Vector l = game.getCards();
                    return l == null ? Collections.EMPTY_LIST : l;
                }
                return Collections.EMPTY_LIST;
            }
        };
        this.cardsModel2 = new CardsTableModel(){

            List getCards() {
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null) {
                    Vector l = game.getUsedCards();
                    return l == null ? Collections.EMPTY_LIST : l;
                }
                return Collections.EMPTY_LIST;
            }
        };
        this.playersModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"Name", "Color", "Type", "Extra Armies", "No. Cards", "No. Countries", "No. Player Eliminated", "Capital", "Mission", "Address", "autodefend", "autoendgo"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                Vector players;
                RiskGame game = TestPanel.this.myrisk.getGame();
                if (game != null && (players = game.getPlayers()) != null) {
                    return players.size();
                }
                return 0;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Player player = (Player)TestPanel.this.myrisk.getGame().getPlayers().elementAt(row);
                switch (col) {
                    case 0: {
                        return player.getName();
                    }
                    case 1: {
                        return RiskUtil.getStringForColor(player.getColor());
                    }
                    case 2: {
                        switch (player.getType()) {
                            case 0: {
                                return "Human";
                            }
                            case 3: {
                                return "AI Crap";
                            }
                            case 1: {
                                return "AI Easy";
                            }
                            case 2: {
                                return "AI Hard";
                            }
                        }
                        throw new RuntimeException();
                    }
                    case 3: {
                        return new Integer(player.getExtraArmies());
                    }
                    case 4: {
                        return new Integer(player.getCards().size());
                    }
                    case 5: {
                        return new Integer(player.getNoTerritoriesOwned());
                    }
                    case 6: {
                        return new Integer(player.getPlayersEliminated().size());
                    }
                    case 7: {
                        return player.getCapital();
                    }
                    case 8: {
                        return player.getMission();
                    }
                    case 9: {
                        return player.getAddress();
                    }
                    case 10: {
                        return new Boolean(player.getAutoDefend());
                    }
                    case 11: {
                        return new Boolean(player.getAutoEndGo());
                    }
                }
                throw new RuntimeException();
            }
        };
        JTabbedPane views = new JTabbedPane();
        views.add("Countries", new JScrollPane(new JTable(this.countriesModel)));
        views.add("Continents", new JScrollPane(new JTable(this.continentsModel)));
        views.add("Cards", new JScrollPane(new JTable(this.cardsModel)));
        views.add("Spent Cards", new JScrollPane(new JTable(this.cardsModel2)));
        views.add("Players", new JScrollPane(new JTable(this.playersModel)));
        this.setLayout(new BorderLayout());
        this.add(views);
    }

    public void actionPerformed(ActionEvent a) {
        if (a.getActionCommand().equals("refresh")) {
            this.countriesModel.fireTableDataChanged();
            this.continentsModel.fireTableDataChanged();
            this.cardsModel.fireTableDataChanged();
            this.cardsModel2.fireTableDataChanged();
            this.playersModel.fireTableDataChanged();
            this.repaint();
        } else if (a.getActionCommand().equals("flash")) {
            MainMenu.newMainMenuFrame(this.myrisk, 2);
        } else if (a.getActionCommand().equals("aiwait")) {
            Object[] options;
            Object[] message = new Object[]{new JLabel("AI wait time (in milliseconds):"), new JSpinner(new SpinnerNumberModel(AIPlayer.getWait(), 0, 10000, 100))};
            int result = JOptionPane.showOptionDialog(this, message, "AI Options", 2, -1, null, options = new String[]{"OK", "cancel"}, options[0]);
            if (result == 0) {
                AIPlayer.setWait((Integer)((JSpinner)message[1]).getValue());
            }
        } else if (a.getActionCommand().equals("allcards")) {
            if (this.myrisk.getGame() != null && this.myrisk.getGame().getCards() != null) {
                Frame frame = RiskUIUtil.findParentFrame(this);
                CardsDialog cardsDialog = new CardsDialog(frame, this.pp, false, this.myrisk, false);
                Dimension frameSize = frame.getSize();
                Dimension aboutSize = cardsDialog.getPreferredSize();
                int x = frame.getLocation().x + (frameSize.width - aboutSize.width) / 2;
                int y = frame.getLocation().y + (frameSize.height - aboutSize.height) / 2;
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                cardsDialog.setLocation(x, y);
                cardsDialog.populate(this.myrisk.getGame().getCards());
                cardsDialog.setVisible(true);
            }
        } else {
            throw new RuntimeException("TestTab: unknown command found: " + a.getActionCommand());
        }
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public JMenu getMenu() {
        return null;
    }

    abstract class CardsTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"No.", "Type", "Country"};

        CardsTableModel() {
        }

        abstract List getCards();

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.getCards().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            Card card = (Card)this.getCards().get(row);
            switch (col) {
                case 0: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return card.getName();
                }
                case 2: {
                    return card.getCountry();
                }
            }
            throw new RuntimeException();
        }
    }
}

