/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.yura.grasshopper.ConsoleHandler;
import net.yura.grasshopper.LoggingOutputStream;
import net.yura.grasshopper.StdOutErrLevel;
import net.yura.grasshopper.TextHandler;

public abstract class BugManager {
    public static final String VER = "2.2";
    private Thread thread;
    private boolean happened;

    protected abstract void action(String var1);

    public boolean hasHappened() {
        return this.happened;
    }

    public static void interceptAndAlert(Writer a, BugManager b) {
        LogManager.getLogManager().reset();
        Logger logger = Logger.getLogger("");
        logger.addHandler(new TextHandler(a, Level.WARNING, b));
        logger.addHandler(new ConsoleHandler());
        System.setOut(new PrintStream(new LoggingOutputStream(StdOutErrLevel.STDOUT), true));
        System.setErr(new PrintStream(new LoggingOutputStream(StdOutErrLevel.STDERR), true));
    }

    public static PrintStream getSimplePrintStream(Writer sw) {
        return BugManager.getSimplePrintStream(sw, null, null);
    }

    private static PrintStream getSimplePrintStream(final Writer sw, FileDescriptor b, final BugManager ac) {
        final FileOutputStream file = b == null ? null : new FileOutputStream(b);
        return new PrintStream(new OutputStream(){
            private ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);

            public void write(byte[] bi) throws IOException {
                try {
                    if (file != null) {
                        file.write(bi);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.outputStream.write(bi);
            }

            public void write(byte[] bi, int off, int len) throws IOException {
                try {
                    if (file != null) {
                        file.write(bi, off, len);
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                this.outputStream.write(bi, off, len);
            }

            public void write(int bi) throws IOException {
                try {
                    if (file != null) {
                        file.write(bi);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.outputStream.write(bi);
            }

            public void flush() throws IOException {
                try {
                    if (file != null) {
                        file.flush();
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                String string = this.outputStream.toString();
                sw.write(string);
                this.outputStream.reset();
                if (ac != null) {
                    BugManager.action(ac, string);
                }
            }

            public void close() throws IOException {
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.outputStream = null;
            }
        }, true);
    }

    public static void action(final BugManager ac, final String cause) {
        ac.happened = true;
        if (ac.thread == null) {
            ac.thread = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                    ac.thread = null;
                    try {
                        ac.action(cause);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            ac.thread.start();
        }
    }
}

