/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.java1.gcf.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.StreamConnection;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.ConnectionImpl;

public class SocketConnectionImpl
extends ConnectionImpl
implements StreamConnection,
SocketConnection {
    public Socket socket;
    DataOutputStream outputStream;

    public void open(String url, int mode, boolean timeouts) throws IOException {
        int port;
        String host;
        if (new File("no.socket").exists()) {
            throw new IOException("socket blocked by no.socket file");
        }
        String proxy = ApplicationManager.getInstance().getProperty("me4se.socketproxy");
        int cut = url.lastIndexOf(58);
        if (cut >= 9) {
            host = url.substring(9, cut);
            port = Integer.parseInt(url.substring(cut + 1));
        } else {
            host = url.substring(9);
            port = 80;
        }
        if (proxy == null || proxy.trim().length() == 0) {
            this.socket = new Socket(host, port);
        } else {
            if (proxy.startsWith("socket://")) {
                proxy = proxy.substring(9);
            }
            cut = proxy.indexOf(58);
            this.socket = new Socket(proxy.substring(0, cut), Integer.parseInt(proxy.substring(cut + 1)));
            this.outputStream = new DataOutputStream(this.socket.getOutputStream());
            this.outputStream.writeUTF(host);
            this.outputStream.writeInt(port);
            this.outputStream.flush();
        }
    }

    public InputStream openInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        return this.openDataOutputStream();
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new DataOutputStream(this.socket.getOutputStream());
        }
        return this.outputStream;
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void setSocketOption(byte option, int value) throws IllegalArgumentException, IOException {
        switch (option) {
            case 0: {
                this.socket.setTcpNoDelay(option == 0);
                break;
            }
            case 2: {
                this.socket.setKeepAlive(option != 0);
                break;
            }
            case 1: {
                this.socket.setSoLinger(value != 0, value);
                break;
            }
            case 3: {
                this.socket.setReceiveBufferSize(value);
                break;
            }
            case 4: {
                this.socket.setSendBufferSize(value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getSocketOption(byte option) throws IllegalArgumentException, IOException {
        switch (option) {
            case 0: {
                return this.socket.getTcpNoDelay() ? 0 : 1;
            }
            case 2: {
                return this.socket.getKeepAlive() ? 1 : 0;
            }
            case 1: {
                return this.socket.getSoLinger();
            }
            case 3: {
                return this.socket.getReceiveBufferSize();
            }
            case 4: {
                return this.socket.getSendBufferSize();
            }
        }
        throw new IllegalArgumentException();
    }

    public String getLocalAddress() throws IOException {
        return this.socket.getLocalAddress().toString();
    }

    public int getLocalPort() throws IOException {
        return this.socket.getLocalPort();
    }

    public String getAddress() throws IOException {
        return this.socket.getRemoteSocketAddress().toString();
    }

    public int getPort() throws IOException {
        return this.socket.getPort();
    }
}

