package net.yura.grasshopper;

import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public abstract class BugManager {
    
        public final static String VER="2.2";

        protected abstract void action(String cause);

        public boolean hasHappened() {
            return happened;
        }
        
        public static void interceptAndAlert(final Writer a,final BugManager b) {
            
            LogManager.getLogManager().reset(); // remove all handlers
            Logger logger = Logger.getLogger("");
            //logger.setLevel(Level.ALL); // this will print LOADS of shit in Swing

            logger.addHandler( new TextHandler(a,Level.WARNING,b) );
            logger.addHandler( new ConsoleHandler() );

            // redirect System.out and System.err to Logging
            System.setOut( new PrintStream( new LoggingOutputStream( StdOutErrLevel.STDOUT ) , true) );
            System.setErr( new PrintStream( new LoggingOutputStream( StdOutErrLevel.STDERR ) , true) );

            //System.setOut( SimplePrintStream.getSimplePrintStream( a, FileDescriptor.out ,null) );
            //System.setErr( SimplePrintStream.getSimplePrintStream( a, FileDescriptor.err , b ) );
            
            //System.err.println( "getHandlers: " + java.util.Arrays.asList( Logger.getLogger("").getHandlers() ) );
            // Java SE [java.util.logging.ConsoleHandler@26c1186f]
            // Android [com.android.internal.logging.AndroidHandler@4074f658]

            //System.err.println( "getLevelProperty: " + LogManager.getLogManager().getProperty( java.util.logging.ConsoleHandler.class.getName() +".level") ); // INFO
            
            //Thread.setDefaultUncaughtExceptionHandler( new Thread.UncaughtExceptionHandler() {
            //    public void uncaughtException(Thread t, Throwable e) {
            //        java.util.logging.Logger.getLogger("").log(Level.SEVERE, null, e);
            //    }
            //} );
        }

	public static PrintStream getSimplePrintStream(final Writer sw) {
		return getSimplePrintStream(sw, null, null);
	}

        private static PrintStream getSimplePrintStream(final Writer sw,final FileDescriptor b, final BugManager ac) {

                final OutputStream file = b==null?null:new FileOutputStream(b);
                // !!! ### !!!! #### !!! ### !!!! #### !!! ### !!!! #### !!! ### !!!! ####
                // when the file is System.out/System.err and java is run with javaw (without console)
                // then doing things to the file will throw Exceptions, so we need to catch them
                // !!! ### !!!! #### !!! ### !!!! #### !!! ### !!!! #### !!! ### !!!! ####

		return new PrintStream(new OutputStream() {
                    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);
                    public void write(byte[] bi) throws IOException {
                        try {
                            if (file!=null) file.write(bi);
                        }
                        catch (Throwable th) { }
                        outputStream.write(bi);
                    }
                    public void write(byte[] bi, int off, int len) throws IOException {
                        try {
                            if (file!=null) file.write(bi, off, len);
                        }
                        catch (Throwable th) { }
                        outputStream.write(bi, off, len);
                    }
                    public void write(int bi) throws IOException {
                        try {
                            if (file!=null) file.write(bi);
                        }
                        catch (Throwable th) { }
                        outputStream.write(bi);
                    }
                    public void flush() throws IOException {
                        try {
                            if (file!=null) file.flush();
                        }
                        catch (Throwable th) { }
                        String string = outputStream.toString();
                        sw.write( string );
                        outputStream.reset();
                        if (ac!=null) action(ac,string);
                    }
                    public void close() throws IOException {
                        try {
                            if (file!=null) file.close();
                        }
                        catch (Throwable th) { }
                        outputStream = null;
                    }
                }, true );
	}

    private Thread thread;
    private boolean happened;
    
    public static void action(final BugManager ac,final String cause) {

        ac.happened = true;
        
        if (ac.thread==null) {
            ac.thread = new Thread() {
                public void run() {
                    try {
                        Thread.sleep(1000); // sleep in case we get several printout for this error
                    }
                    catch (Throwable ex) { }
                    ac.thread = null;
                    try {
                        ac.action(cause);
                    }
                    catch (Throwable ex) { }
                }
            };
            ac.thread.start();
        }
    }


}
