package net.yura.grasshopper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.StringBody;

/**
 * @author Yura Mamyrin
 */
public class BugSubmitterMultipart {

    static void send(String url, Hashtable map) throws IOException {
        
        // create the multipart request and add the parts to it
        MultipartEntity requestContent = new MultipartEntity();
        
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = (Map.Entry) it.next();
            String key = String.valueOf( next.getKey() );
            Object value = next.getValue();
            
            if (value instanceof File) {
                requestContent.addPart(key, new LogFileBody( (File)value ) );

//                can not use this as unknown length fails on Android
//                requestContent.addPart(key, new InputStreamBody( new FileInputStream( (File)value ) , null ) );
//                can not use this as length may not match when writing file
//                requestContent.addPart(key, new FileBody( (File)value ) {
//                        public String getFilename() { return null; }
//                });
            }
            else {
                requestContent.addPart(key, new StringBody( String.valueOf(value) ));
            }
        }

        // get Screenshots of windows now
        byte[][] images = BugUIInfo.getFrames();
        for (int c=0;c<images.length;c++) {

            // we need to use img0 - img9 for the name of this field as this is what we set up in default.trc
            // upload_img0: gif jpg jpeg png xxx
            // ...
            // upload_img9: gif jpg jpeg png xxx
            requestContent.addPart("img"+c, new ByteArrayBody(images[c], "frame_"+c+".png"));
        }
        doPost(url, requestContent);
    }

    
    /**
     * this is a copy and paste from net.yura.domination.tools.mapeditor.MapsTools#doPost
     */
    public static void doPost(String url, MultipartEntity requestContent) throws IOException {

            	URLConnection conn = new URL(url).openConnection();
        	conn.setDoOutput(true);

                org.apache.http.Header contentType = requestContent.getContentType();
                conn.setRequestProperty(contentType.getName(), contentType.getValue());

                // this seems to be null and does not seem to be needed
                //org.apache.http.Header contentEncoding = requestContent.getContentEncoding();
                //conn.setRequestProperty(contentEncoding.getName(), contentEncoding.getValue());

                //conn.setRequestProperty("content-type","multipart/form-data");
                conn.setRequestProperty("Content-Length", String.valueOf(requestContent.getContentLength()) );

                OutputStream out = conn.getOutputStream();
                requestContent.writeTo( out );
        	out.close();

        	// Get the response
                //StringBuffer buffer = new StringBuffer();
        	BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        	String line;
        	while ((line = rd.readLine()) != null) {
		//	buffer.append(line);
                //        buffer.append("\n");
        	}
        	rd.close();
		//return buffer.toString();
                // do NOT read the responce into a buffer, as we do not need it anyway
    }
    
}
