package net.yura.grasshopper;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

/**
 * @author Yura Mamyrin
 */
public class BugSystemInfo {

    public static String appName,version,locale;

    public static Hashtable addSystemInfo() {


        String systemLocale,localhost,systemProperties,lookandfeel;

        try {
            systemLocale = java.util.Locale.getDefault().toString();
        }
        catch (Throwable th) {
            systemLocale = th.toString();
        }

        try {
            localhost = java.net.InetAddress.getLocalHost().toString();
        }
        catch (Throwable e) {
            localhost = e.toString();
        }

        try {
            Properties props = System.getProperties();
            Iterator i = props.entrySet().iterator();
            StringBuffer sb = new StringBuffer();
            while (i.hasNext()) {
                sb.append( i.next() +"\n");
            }
            systemProperties = sb.toString();
        }
        catch (Throwable e) {
            systemProperties = e.toString();
        }

        lookandfeel = BugUIInfo.getLookAndFeel();

        Hashtable map = new Hashtable();
        map.put("systemLocale",systemLocale);
        map.put("localhost",localhost);
        map.put("systemProperties",systemProperties);
        map.put("lookandfeel",lookandfeel);

        map.put("submitDate",new java.util.Date().toString());

        return map;

    }


}
