package net.yura.grasshopper;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import android.util.Log;

/**
 * @author Yura Mamyrin
 * @See com.android.internal.logging.AndroidHandler
 */
public class ConsoleHandler extends Handler {

    /**
     * Constructs a new instance of the Android log handler.
     */
    public ConsoleHandler() {
        setFormatter( new ReallySimpleFormatter() );
    }

    @Override
    public void close() {
        // No need to close, but must implement abstract method.
    }

    @Override
    public void flush() {
        // No need to flush, but must implement abstract method.
    }

    @Override
    public void publish(LogRecord record) {
        // YURA this is how we set the level, not Log.isLoggable(tag, level)
        if (!isLoggable(record)) {
            return;
        }
        try {
            int level = getAndroidLevel(record.getLevel());
            String tag = record.getLoggerName();

            if (tag == null) {
                // Anonymous logger.
                tag = "null";    
            } else {
                // Tags must be <= 23 characters.
                int length = tag.length();
                if (length > 23) {
                    // Most loggers use the full class name. Try dropping the
                    // package.
                    int lastPeriod = tag.lastIndexOf(".");
                    if (length - lastPeriod - 1 <= 23) {
                        tag = tag.substring(lastPeriod + 1);
                    } else {
                        // Use last 23 chars.
                        tag = tag.substring(tag.length() - 23);
                    }
                }
            }

// for some reason i cant find a way to control this, so we have got rid of it
//            if (!Log.isLoggable(tag, level)) {
//                return;
//            }

            String message = getFormatter().format(record);
            Log.println(level, tag, message);
        } catch (RuntimeException e) {
            Log.e("AndroidHandler", "Error logging message.", e);
        }
    }

    /**
     * Converts a {@link java.util.logging.Logger} logging level into an Android one.
     * 
     * @param level The {@link java.util.logging.Logger} logging level.
     * 
     * @return The resulting Android logging level. 
     */
    static int getAndroidLevel(Level level) {
        int value = level.intValue();
        if (value >= 1100 ) {
            return Log.ASSERT;
        }
        else if (value >= 1000 ) { // SEVERE(1000)
            return Log.ERROR;
        } 
        else if (value >= 900) { // WARNING(900)
            return Log.WARN;
        }
        else if (value >= 700) { // INFO(800) and CONFIG(700)
            return Log.INFO;
        }
        else if (value >= 400) { // FINE(500) and FINER(400)
            return Log.DEBUG;
        }
        else { // FINEST(300)
            return Log.VERBOSE;
        }
    }
    
}
