package net.yura.grasshopper;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;

/**
 * @author Yura Mamyrin
 */
public class BugUIInfo {

    public static byte[][] getFrames() {
        Window[] frames;
        try {
            frames = Window.getWindows(); // only JAVA-1.6, then again Multipart sending does not work in 1.4
        }
        catch (Throwable th) {
            frames = Frame.getFrames();
        }
        Vector images = new Vector();
        for (int c=0;c<frames.length;c++) {
            Window frame = frames[c];
            if (frame.isVisible()) {
                BufferedImage img = new BufferedImage(frame.getWidth(), frame.getHeight(), BufferedImage.TYPE_INT_BGR);
                Graphics g = img.getGraphics();
                frame.paintAll( g ); // paint does not work as only gets lightweight components, paintAll gets ALL components
                // TODO: on Zinas mac it does not work either
                g.dispose();
                
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    ImageIO.write(img, "PNG", out);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                images.add( out.toByteArray() );
            }
        }
        return (byte[][])images.toArray( new byte[images.size()][] );
    }

    public static String getLookAndFeel() {
        try {
            return javax.swing.UIManager.getLookAndFeel().toString();
        }
        catch(Throwable th) {
            return th.toString();
        }
    }

}
