package net.yura.translation;

import java.awt.Graphics;
import net.yura.swing.YuraTextEditor;
import javax.swing.JPanel;
import javax.swing.JLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JOptionPane;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JTree;

public class DoublePanel extends JPanel implements ActionListener {

    private JLabel name;
    private PartnerNode partner;
    private Mtcomm mycomm;
    private MyNode message;
    private JTree tree;
    private YuraTextEditor top;
    private YuraTextEditor bottom;
    private Locale localetop;
    private Locale localebottom;

    public DoublePanel(JTree t) {
        
        tree = t;

        setLayout(new BorderLayout());

        name = new JLabel();

        top = new YuraTextEditor();
        bottom = new YuraTextEditor() {

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);

                if (bottom.isEditMode()) {
                    String string = String.valueOf(localebottom);
                    g.setFont( getFont().deriveFont(100f) );
                    g.setColor( new Color(0xFFDDDDDD) );
                    g.drawString(string, (int) (getWidth()-g.getFontMetrics().stringWidth(string))/2, (int) (getHeight()-g.getFontMetrics().getHeight())/2 + g.getFontMetrics().getHeight() );
                }
            }
            
        };

        addButtons(top);
        addButtons(bottom);

        top.addActionListener(this);
        bottom.addActionListener(this);

        top.setLabel("default");

        JPanel box2 = new JPanel(new GridLayout(2, 1, 10, 10));
        box2.add(top);
        box2.add(bottom);
        box2.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 10, 10, 10));

        add(name, BorderLayout.NORTH);
        add(box2);

    }

    private void addButtons(YuraTextEditor ytp) {

        JButton save = new JButton("Save");
        save.setActionCommand("save");

        JButton revert = new JButton("Revert");
        revert.setActionCommand("revert");

        JButton reload = new JButton("Reload");
        reload.setActionCommand("reload");

        JButton setnull = new JButton("Remove");
        setnull.setActionCommand("setnull");

        ytp.add(save);
        ytp.add(revert);
        ytp.add(reload);
        ytp.add(setnull);
    }

    public void reuse(MyNode a, PartnerNode p, Locale l1, Locale l2, Mtcomm com) throws Exception {

        name.setText("<html><b>&nbsp;&nbsp;" + a.getName() + " (" + p + ")</b></html>");
        partner = p;
        mycomm = com;
        message = a;

        localetop = l1;
        top.setText(message.getMessage(mycomm, partner, localetop)); // TODO network request and UI operation in same thread?!

        resetLocale(l2);

    }

    public void resetLocale(Locale a) throws Exception {

        localebottom = a;

        bottom.setLabel("in " + localebottom);
        
        bottom.setTextLocale(localebottom);
        
        bottom.setText(message.getMessage(mycomm, partner, localebottom)); // TODO network request and UI operation in same thread?!
        
    }

    public void revert() {

        top.revert();
        bottom.revert();
    }

    public PartnerNode getID() {

        return partner;

    }

    public boolean checkChange() {

        return (top.checkChange()
                || bottom.checkChange());

    }

    public void saveChanges() throws Exception {


        saveChanges(top);
        saveChanges(bottom);

    }

    public void setWrap(boolean a) {

        top.setWrap(a);
        bottom.setWrap(a);

    }

    public void actionPerformed(ActionEvent ae) {


        if (ae.getActionCommand().equals("reload")) {

            try {

                if (ae.getSource() == top) {

                    message.reload(mycomm, partner, localetop);

                    top.setText(message.getMessage(mycomm, partner, localetop));

                }
                else if (ae.getSource() == bottom) {

                    message.reload(mycomm, partner, localebottom);

                    bottom.setText(message.getMessage(mycomm, partner, localebottom));

                }


            }
            catch (Exception e) {
                e.printStackTrace();
                showError("unable to reload: " + e.getMessage());

            }

        }
        else if (ae.getActionCommand().equals("revert")) {

            ((YuraTextEditor) ae.getSource()).revert();

        }
        else if (ae.getActionCommand().equals("save")) {

            try {

                saveChanges((YuraTextEditor) ae.getSource());

            }
            catch (Exception e) {

                e.printStackTrace();
                showError("unable to save: " + e.getMessage());

            }

            tree.repaint();


        }
        else if (ae.getActionCommand().equals("setnull")) {

            try {


                if (ae.getSource() == top) {

                    message.saveMessage(mycomm, partner, localetop, null, localebottom);

                    top.setText(null);

                }
                else if (ae.getSource() == bottom) {

                    message.saveMessage(mycomm, partner, localebottom, null, localebottom);

                    bottom.setText(null);

                }


                tree.repaint();

            }
            catch (Exception e) {
                e.printStackTrace();
                showError("unable to set to null: " + e.getMessage());
            }

        }
        else {

            throw new RuntimeException("unknown command " + ae.getActionCommand());

        }
    }

    public void showError(String a) {

        JOptionPane.showMessageDialog(this, a, "error!", JOptionPane.ERROR_MESSAGE);

    }

    public void saveChanges(YuraTextEditor a) throws Exception {

        if (a.checkChange()) {

            message.saveMessage(mycomm, partner, (a == top) ? (localetop) : (localebottom), a.getText(), localebottom);

            // resets the background color to white
            a.setText(a.getText());

        }

    }
}
