package net.yura.translation.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class XMLProperties extends PropertiesComm {

    public XMLProperties() throws Exception {
        super();
    }

    public void setupFilter(JFileChooser fc) {
        FileFilter ff = new FileFilter() {

            public boolean accept(File f) {
                return (f.isDirectory() || (f.getName().toLowerCase().endsWith(".xml")));
            }

            public String getDescription() {
                return "Java XML Properties Files (*.xml)";
            }
        };
        fc.addChoosableFileFilter(ff);
        fc.setFileFilter(ff);
    }

    public Properties load(FileInputStream in) throws Exception {

        Properties p = new Properties();
        p.loadFromXML(in);
        return p;

    }

    public void store(Properties p, FileOutputStream out, String a) throws Exception {

        p.storeToXML(out, a + "\n" + toString());

    }

    public String toString() {

        return "JAVA 1.5 XML Properties plugin";

    }
}
