/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.yura.translation.plugins.xcode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import net.yura.translation.Result;
import net.yura.util.StringsProperties;

/**
 *
 * @author user30
 */
class Localization {

    private final File file, translation;
    private final StringsProperties strings, translations;
    private final Hashtable<String, Vector<Map.Entry<String, Nib>>> map;
    private final Hashtable<String, String> values;
    private final Vector<Nib> nibs;

    private Localization(String path, String name, boolean defaultLocale) {
        //TODO: Badoo.xcodeproj specific
        this.file = new File(path + "/" + name, "Localizable.strings");
        this.translation = new File(path + "/translation" , name.substring(0, name.indexOf('.')) + ".strings");
        this.strings = new StringsProperties();
        this.translations = defaultLocale?null:new StringsProperties();
        this.nibs = new Vector<Nib>();
        this.map = new Hashtable<String, Vector<Map.Entry<String, Nib>>>();
        this.values = new Hashtable<String, String>();
    }

    //contructor for default locale
    public Localization(File dir) throws IOException {
        this(dir.getParent(), dir.getName(),true);
        strings.loadFromStrings(new FileInputStream(file));
        //TODO: Badoo.xcodeproj specific
        dir = new File(dir.getParentFile().getAbsoluteFile() + "/Classes", dir.getName());
        final File[] files = dir.listFiles(new FilenameFilter() {

            public boolean accept(File dir, String name) {
                return name.endsWith(".xib");
            }
        });
        if (files != null) {
            final ProgressMonitor p = new ProgressMonitor(null, "Loading files required for localization...", dir.getName(), 0, files.length);
            p.setMillisToDecideToPopup(0);
            p.setMillisToPopup(0);
            p.setProgress(1);
            Thread[] threads = new Thread[files.length];

            final Vector<String> errors = new Vector<String>();

            for (int i = 0; i < files.length; i++) {
                final File file = files[i];
                threads[i] = new Thread() {

                    public void run() {
                        try {
                            nibs.add(new Nib(file, Localization.this));
                            p.setProgress(nibs.size());
                            p.setNote(file.getName());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            errors.add( file.getName()+" "+e.toString() );
                        }
                    }
                };
                threads[i].start();
            }
            for (int i = 0; i < threads.length; i++) {
                try {
                    threads[i].join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            if (!errors.isEmpty()) {
                // clear progress box
                p.close();
                String error="Error, this normally means you do not have xcode installed!";
                for (String e:errors) {
                    error = error+"\n"+e;
                }
                JOptionPane.showMessageDialog(null,error);
            }
        }
    }

    public static Localization fromLocale(Locale locale, Localization defaultLocalization) {
        String file = defaultLocalization.file.getParentFile().getName();
        if (file.indexOf('.') > 0) { // remove the .lproj from the file name
            file = file.substring(0, file.indexOf('.'));
        }
        return file.equalsIgnoreCase( Project.toString(locale)) ? defaultLocalization : new Localization(locale, defaultLocalization);
    }

    //contructor for non-default locale
    private Localization(final Locale locale, Localization defaultLocalization) {
        this(defaultLocalization.file.getParentFile().getParent(), Project.toString(locale) + ".lproj",false);
        try {
            if (translation.exists()) {
                translations.loadFromStrings(new FileInputStream(translation));
            }
            if (file.exists()) {

                strings.loadFromStrings(new FileInputStream(file));

                List<String> removeKeys = new ArrayList<String>();
                Set<String> keys = (Set<String>)(Object)translations.keySet(); // stringPropertyNames is only in java 1.6
                for (String key:keys) {
                    if (strings.getProperty(key)==null) {
                        removeKeys.add(key);
                    }
                }
                if (!removeKeys.isEmpty()) {
                    System.out.println("removing old keys from what has been translated in locale "+locale+" "+removeKeys);
                    for (String key:removeKeys) {
                        translations.remove(key);
                    }
                }

                /*
                StringsProperties s = new StringsProperties();
                s.loadFromStrings(new FileInputStream(file));
                //add only translated properties that havent changed in the deafult localization
                for (Iterator<Map.Entry<Object, Object>> i = translations.entrySet().iterator(); i.hasNext();) {
                    Map.Entry entry = i.next();
                    String key = entry.getKey().toString();
                    // if we have translated this exact string before then we copy it over otherwise we do not
                    if (entry.getValue().equals(defaultLocalization.strings.getProperty(key))) {
                        String a = s.getProperty(key);
                        if (a!=null) {
                            strings.setProperty(key, a);
                        }
                        else {
                            System.out.println("ERROR!!! key: "+key+" has already been translated but can not be found for locale "+locale);
                        }
                    }
                }
                */
            }
            //copy nibs from default locale
            if (!defaultLocalization.nibs.isEmpty()) {
                final ProgressMonitor p = new ProgressMonitor(null, "Loading files required for localization...", file.getParentFile().getName(), 0, defaultLocalization.nibs.size());
                p.setMillisToDecideToPopup(0);
                p.setMillisToPopup(0);
                p.setProgress(1);
                Thread[] threads = new Thread[defaultLocalization.nibs.size()];
                for (int i = 0; i < defaultLocalization.nibs.size(); i++) {
                    final Nib nib = defaultLocalization.nibs.elementAt(i);
                    threads[i] = new Thread() {

                        public void run() {
                            try {
                                nibs.add(new Nib(nib, locale, Localization.this));
                                p.setProgress(nibs.size());
                                p.setNote(nib.getName());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    threads[i].start();
                    //DISABLE MULTITHREADING - HACK TO FIX SHARED NIB BUG
                    try {
                        threads[i].join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    //END
                }
                for (int i = 0; i < threads.length; i++) {
                    try {
                        threads[i].join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    StringsProperties getTranslations() {
        return translations;
    }

    public Enumeration propertyNames() {
        return new Enumeration() {

            boolean hasMore = true;
            Enumeration e = strings.propertyNames();

            public boolean hasMoreElements() {
                boolean b = e.hasMoreElements();
                if (!b && hasMore) {
                    //enumerate nib property names after the string file
                    e = map.keys();
                    b = e.hasMoreElements();
                    hasMore = false;
                }
                return b;
            }

            public Object nextElement() {
                return e.nextElement();
            }
        };
    }

    synchronized void addPropertyForNib(final String key, final String value, final Nib nib, String name) {
        String property = values.get(value);
        Vector<Map.Entry<String, Nib>> v;
        //if this is the first key with this value
        if (property == null) {
            //generate user friendly key and map to value
            property = "xib." + name.substring(0, name.length() - 3).replace("BMA", "").replace("Controller", "") + value.substring(0, Math.min(8, value.indexOf(' ') == -1 ? value.length() : value.indexOf(' '))).replace(".", "") + " (" + key.substring(0, key.indexOf('.')) + ")";
            v = new Vector<Map.Entry<String, Nib>>();
            map.put(property, v);
            //map value to key to test for shared values
            values.put(value, property);
        }
        else if (!property.startsWith("xib.shared.")) {
            //move property to shared nib tree
            v = map.remove(property);
            property = "xib.shared" + property.substring(property.indexOf('.', 4));
            map.put(property, v);
            values.put(value, property);
        }
        else {
            //get the shared nib key properties
            v = map.get(property);
        }
        //add the property to the key
        v.add(new Map.Entry<String, Nib>() {

            private String k = key;
            private Nib n = nib;

            public String getKey() {
                return k;
            }

            public Nib getValue() {
                return n;
            }

            public Nib setValue(Nib value) {
                return n = value;
            }
        });
    }

    public String getProperty(String key) {
        String p = strings.getProperty(key);
        if (p == null) {
            Vector<Map.Entry<String, Nib>> v = map.get(key);
            if (v != null) {
                p = v.firstElement().getValue().getProperty(v.firstElement().getKey());
            }
        }
        return p;
    }

    public void setProperty(String key, String value, Localization defaultLocale, Project project) throws IOException {
        //if not a nib property just add to strings file
        if (!key.startsWith("xib.")) {
            if (value != null) {
                strings.setProperty(key, value);
                String whatHasBeenTranslated = defaultLocale.getProperty(key);
                if (translations!=null && whatHasBeenTranslated!=null) {
                    translations.setProperty(key, whatHasBeenTranslated );
                }
            }
            else {
                strings.remove(key);
                if (translations!=null) {
                    translations.remove(key);
                }
            }
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                project.localizationAdded(file);
            }
            strings.storeToStrings(new FileOutputStream(file), null);
        }
        else {
            //set the property in all nibs that share the value
            Vector<Map.Entry<String, Nib>> v = map.get(key);
            System.out.println(String.valueOf(v));
            if (v != null) {
                ProgressMonitor p = new ProgressMonitor(null, "Saving " + file.getParentFile().getName() + "...", null, 0, v.size());
                int i = 0;
                for (Enumeration<Map.Entry<String, Nib>> e = v.elements(); e.hasMoreElements();) {
                    Map.Entry<String, Nib> entry = e.nextElement();
                    p.setNote(entry.getValue().getName());
                    entry.getValue().setProperty(entry.getKey(), value, translations, project);
                    p.setProgress(++i);
                }
            }
        }
        if (translations!=null) {
            translations.storeToStrings(new FileOutputStream(translation), null);
        }
    }
    
    public static void search(Locale l,String s,Vector r, StringsProperties strings) {
            for (Iterator it = strings.entrySet().iterator();it.hasNext();) {
                java.util.Map.Entry me = (java.util.Map.Entry) it.next();
                String key = (String) me.getKey();
                String value = (String) me.getValue();
                if (value.toLowerCase().indexOf(s) > -1) {
                    r.add( new Result(key,l,null) );
                }
            }
    }

    public void findString(Locale l, String s, Vector r, Localization defaultl) {

        if (s==null&&this==defaultl) return; // do not search the default, as it will never have anything missing

        //search the strings file
        if (s!=null) {
            search(l, s, r, strings);
        }
        else {
            for (Iterator it = defaultl.strings.entrySet().iterator();it.hasNext();) {
                java.util.Map.Entry me = (java.util.Map.Entry) it.next();
                String key = (String) me.getKey();
                String value = (String) me.getValue();
                // if the value of the default is not the same as the one we have translated
                if (!value.equals( translations.get(key) )) {
                    r.add( new Result(key,l,null) );
                }
            }
        }



        //search the nibs
        for (Iterator<Map.Entry<String, Vector<Map.Entry<String, Nib>>>> i = map.entrySet().iterator(); i.hasNext();) {
            Map.Entry<String, Vector<Map.Entry<String, Nib>>> entry = i.next();
            for (Enumeration<Map.Entry<String, Nib>> e = entry.getValue().elements(); e.hasMoreElements();) {
                Map.Entry<String, Nib> property = e.nextElement();
                String value = property.getValue().getProperty(property.getKey());
                if (
                        (s==null&&value==null)||
                        (value != null && value.toLowerCase().indexOf(s) > -1)
                ){
                    r.add( new Result(entry.getKey(), l, null) );
                }
            }
        }
    }

    public boolean isEmpty() {
        return strings.isEmpty(); // TODO do we want to check if any nibs have string too??
    }
}
