package net.yura.translation.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import net.yura.socketserver.ClientSession;
import net.yura.socketserver.SocketServer;
import net.yura.socketserver.SocketSession;
import net.yura.translation.Mtcomm;
import net.yura.translation.plugins.NetComm;
import net.yura.translation.plugins.xcode.XcodeComm;

/**
 * @author Yura
 */
public class XcodeServer {
    
    public static class MyClientSession implements ClientSession {

        static Mtcomm comm;
        PrivateKey key;
        
        ObjectOutputStream out;
        ObjectInputStream in;
        
        public void setInputStream(InputStream in) {
            try {
                this.in = new ObjectInputStream(in);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public void setOutputStream(OutputStream out) {
            try {
                this.out = new ObjectOutputStream(out);


                // now send the public key to the client!
                KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
                kpg.initialize(1024);
                KeyPair kp = kpg.generateKeyPair();
                PublicKey pubk = kp.getPublic();
                key = kp.getPrivate();

                this.out.writeObject(pubk);

            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public Object readObject() throws IOException {
            try {
                return in.readObject();
            }
            catch (ClassNotFoundException ex) {
                throw new IOException(ex);
            }
        }

        public void writeObject(Object o) throws IOException {
            out.writeObject(o);
        }

        public void handleObject(Object o, SocketSession ss) {

		try {

			NetComm.TheMethod message = (NetComm.TheMethod)o;

			String method = message.name;
			Object[] args = message.params;

			if (method.equals("Hello")) {

				Cipher cipher = Cipher.getInstance("RSA");

				cipher.init(Cipher.DECRYPT_MODE, key );

				byte[] name = cipher.doFinal( (byte[])args[0] );
				byte[] pass = cipher.doFinal( (byte[])args[1] );
				Class myclass = Class.forName( (String)args[3] );

				//Mtcomm myobject = (Mtcomm)myclass.newInstance();

				String username = new String(name);
                                String password = new String(pass);

                                if (!"yura".equals(username) || !"test".equals(password)) throw new Exception("login FAIL");
                                
				if (!args[2].equals( "1" )) { throw new Exception("client server version missmatch"); }

				//comm = myobject;

                                //comm.load();
                                
				ss.sendObject("OK");

			}
			else {

				Method[] methods = comm.getClass().getMethods();

				for (int c=0;c<methods.length;c++) {

					if (methods[c].getName().equals(method) && paramMatch(methods[c].getParameterTypes(), args) ) {
						ss.sendObject( methods[c].invoke(comm,args) );
						return;
					}

				}

				throw new Exception("cant find method: "+method);
			}

		}
		catch (Exception e) {
                    System.out.println("error handling object: "+o);
			e.printStackTrace();
			ss.sendObject(e);
		}
            
        }

        private boolean paramMatch(Class<?>[] parameterTypes, Object[] args) {
            
            if (parameterTypes.length == 0 && (args==null || args.length==0)) {
                return true;
            }
            if (parameterTypes.length != args.length) {
                return false;
            }
            for (int c=0;c<parameterTypes.length;c++) {
                if(args[c]!=null && !translateFromPrimitive(parameterTypes[c]).isInstance( args[c] )) {
                    return false;
                }
            }
            return true;
        }
        
    }
    
    /**
     *  If this specified class represents a primitive type (int, float, etc.) then
     *  it is translated into its wrapper type (Integer, Float, etc.).  If the
     *  passed class is not a primitive then it is just returned.
     */
    public static Class<?> translateFromPrimitive( Class<?> primitive )
    {
        if( !primitive.isPrimitive() )
            return( primitive );

        if( Boolean.TYPE.equals( primitive ) )
            return( Boolean.class );
        if( Character.TYPE.equals( primitive ) )
            return( Character.class );
        if( Byte.TYPE.equals( primitive ) )
            return( Byte.class );
        if( Short.TYPE.equals( primitive ) )
            return( Short.class );
        if( Integer.TYPE.equals( primitive ) )
            return( Integer.class );
        if( Long.TYPE.equals( primitive ) )
            return( Long.class );
        if( Float.TYPE.equals( primitive ) )
            return( Float.class );
        if( Double.TYPE.equals( primitive ) )
            return( Double.class );

        throw new RuntimeException( "Error translating type:" + primitive );
    }
    
    
    public static void main(String[] args) throws Exception {
        
        SocketServer myServer = new SocketServer();
        myServer.setName("Xcode Server");
        myServer.setPort(8096);
        myServer.setClientSessionClass( MyClientSession.class );
        myServer.startServer();
        

        String theFile="I:/6_Yura/Work/java/badoo/repo/iPhone/Badoo.xcodeproj";
        if (args.length != 0) {
            StringBuilder builder = new StringBuilder();
            for (int c=0;c<args.length;c++) {
                builder.append(args[c]);
                if (c < (args.length-1)) {
                    builder.append(" ");
                }
            }
            theFile = builder.toString();
        }

        File selectedFile = new File(theFile);
        if (selectedFile.exists()) {
            File file = new File(selectedFile.getParentFile(), "en.lproj");
            MyClientSession.comm = new XcodeComm();
            ((XcodeComm)MyClientSession.comm).load(selectedFile, file);
        }
        else {
            System.out.println("pls provide *.xcodeproj file as command line arg");
            System.exit(1);
        }
        
    }
    
}
