package net.yura.grasshopper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.content.AbstractContentBody;

/**
 * @author Yura Mamyrin
 */
public class LogFileBody extends AbstractContentBody {

    File file;
    long length = -1;
    
    public LogFileBody(File file) {
        super("text/plain");
        this.file = file;
    }
    
    public String getFilename() {
        return null;
    }

    public String getCharset() {
        return "US-ASCII";
    }

    public String getTransferEncoding() {
        return MIME.ENC_8BIT;
    }

    public long getContentLength() {
        if (length == -1) {
            length = file.length();
        }
        return length;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream in = new FileInputStream(this.file);
        try {
            
            long totalLength = getContentLength();
            long totalWritten = 0;
            
            byte[] tmp = new byte[2048]; // 4096
            int l;
            while ((l = in.read(tmp)) != -1) {
                if ( totalWritten+l > totalLength ) {
                    out.write(tmp, 0, (int)(totalLength - totalWritten) );
                    break;
                }
                else {
                    totalWritten = totalWritten + l;
                    out.write(tmp, 0, l);
                }
            }
            out.flush();
        }
        finally {
            in.close();
        }
    }
}
