package net.yura.grasshopper;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

/**
 * @author Yura Mamyrin
 */
public class ReallySimpleFormatter extends Formatter {

    // Line separator string.  This is the value of the line.separator
    // property at the moment that the SimpleFormatter was created.
    private String lineSeparator = System.getProperty("line.separator");

    /**
     * Format the given LogRecord.
     * @param record the log record to be formatted.
     * @return a formatted log record
     */
    public synchronized String format(LogRecord record) {
	StringBuffer sb = new StringBuffer();

	sb.append(record.getLevel().getName()); // getLocalizedName
        sb.append(": ");

        String message = formatMessage(record);
        if (message!=null || record.getThrown()==null) {
            sb.append(message);
            sb.append(lineSeparator);
        }
        
        
	if (record.getThrown() != null) {
	    try {
	        StringWriter sw = new StringWriter();
	        PrintWriter pw = new PrintWriter(sw);
	        record.getThrown().printStackTrace(pw);
	        pw.close();
		sb.append(sw.toString());
	    } catch (Exception ex) {
	    }
	}

	return sb.toString();
    }
}

