package net.yura.grasshopper;

import java.io.Writer;
import java.util.logging.ErrorManager;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/**
 * @author Yura Mamyrin
 */
public class TextHandler extends Handler {

    private boolean doneHeader;
    private Writer writer;
    private Level pushLevel;
    private BugManager sps;
    
    public TextHandler(Writer writer,Level pushLevel,BugManager sps) {
        this.writer = writer;
        this.pushLevel = pushLevel;
        this.sps = sps;
        setFormatter( new ReallySimpleFormatter() );
    }
    
    public void publish(LogRecord record) {
	if (!isLoggable(record)) {
	    return;
	}
	String msg;
	try {
 	    msg = getFormatter().format(record);
	} catch (Exception ex) {
	    // We don't want to throw an exception here, but we
	    // report the exception to any registered ErrorManager.
	    reportError(null, ex, ErrorManager.FORMAT_FAILURE);
	    return;
	}

	try {
	    if (!doneHeader) {
	        writer.write(getFormatter().getHead(this));
		doneHeader = true;
	    }
	    writer.write(msg);
            writer.flush(); // in case this is used for files, we want to flush each record
            
	} catch (Exception ex) {
	    // We don't want to throw an exception here, but we
	    // report the exception to any registered ErrorManager.
	    reportError(null, ex, ErrorManager.WRITE_FAILURE);
	}
        
        if (record.getLevel().intValue() >= pushLevel.intValue()) {
            BugManager.action(sps, record.getLevel()+" "+record.getMillis()+" "+record.getMessage()+" "+record.getThrown() );
        }
    }

    public void flush() {
// we flush after each record is written, so we do not need to flush here
//        try {
//            writer.flush();
//        } catch (Exception ex) {	
//            // We don't want to throw an exception here, but we
//            // report the exception to any registered ErrorManager.
//            reportError(null, ex, ErrorManager.FLUSH_FAILURE);
//        }
    }

    public void close() throws SecurityException {
        try {
            if (!doneHeader) {
                writer.write(getFormatter().getHead(this));
                doneHeader = true;
            }
            writer.write(getFormatter().getTail(this));
            writer.flush();
            writer.close();
        } catch (Exception ex) {
            // We don't want to throw an exception here, but we
            // report the exception to any registered ErrorManager.
            reportError(null, ex, ErrorManager.CLOSE_FAILURE);
        }
        writer = null;
    }
    
}
