package net.yura.grasshopper;

import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;

/**
 *
 * @author Yura Mamyrin
 */
public class LogTest extends TestCase {
    
    public LogTest(String testName) {
        super(testName);
    }
    
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static void testLog() throws Exception {
        System.out.println("test log");

        Thread.sleep(100);
        
        System.out.println("hello world! 1");
        System.out.print("hello ");
        System.out.print("world! ");
        System.out.print("2");
        System.out.println();
        
        System.out.print("hello line 1\nhello line 2\nhello line 3\n");

        // hard-coded to linux new line
        System.out.print("bip\n");
        
        // hard-coded to windows new line
        System.out.print("bop\r\n");

        Thread.sleep(100);
        
        System.err.println("hello world! 3");
        System.err.print("hello ");
        System.err.print("world! ");
        System.err.print("4");
        System.err.println();
        
        // hard-coded to linux new line
        System.err.print("bip");
        System.err.print("\n");
        
        // hard-coded to windows new line
        System.err.print("bop");
        System.err.print("\r\n");
        
        try {
            throw new RuntimeException("ah nose");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        
        Thread thread = new Thread() {
            public void run() {
                if (true) throw new RuntimeException("how could you let this happen???");
            }
        };
        
        thread.start();
        thread.join();
        
        
        Thread.sleep(100);
        
    }
    
    
    public static void testLogger() throws Exception {
        System.out.println("test logger");
        
        Thread.sleep(100);
        
        Logger logger = Logger.getLogger(LogTest.class.getName());
        
        logger.finest("the finest message");
        logger.finer("the finer message");
        logger.fine("the fine message");
        logger.config("the config message");
        logger.info("the info message");
        
        Thread.sleep(100);
        
        logger.warning("the warning message");
        logger.severe("the severe message");

        Exception exception = new Exception("an exception");
        
        logger.throwing(null, null, exception ); // done at finest level
        
        Thread.sleep(100);
        
        logger.log(Level.FINEST, "the finest message", exception);
        logger.log(Level.FINER, "the finer message", exception);
        logger.log(Level.FINE, "the fine message", exception);
        logger.log(Level.CONFIG, "the config message", exception);
        logger.log(Level.INFO, "the info message", exception);
        
        Thread.sleep(100);
        
        logger.log(Level.WARNING, "the warning message", exception);
        logger.log(Level.SEVERE, "the severe message", exception);
        
        Thread.sleep(100);
    }
}
