/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.yura.swing;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TreeCombo extends JComboBox {

    static final int OFFSET = 16;

    public TreeCombo() {
        setRenderer(new ListEntryRenderer());
    }

    public TreeCombo(TreeModel aTreeModel) {
        this();
        setModel(aTreeModel);
    }

    public void setModel(TreeModel aTreeModel) {
        super.setModel(new TreeToListModel(aTreeModel));
    }

    class TreeToListModel extends AbstractListModel implements
            ComboBoxModel, TreeModelListener {

        TreeModel source;
        boolean invalid = true;
        Object currentValue;
        Vector cache = new Vector();

        public TreeToListModel(TreeModel aTreeModel) {
            source = aTreeModel;
            aTreeModel.addTreeModelListener(this);
            setRenderer(new ListEntryRenderer());
        }

        public void setSelectedItem(Object anObject) {
            if ((currentValue != null && !currentValue.equals(anObject)) ||
                    currentValue == null && anObject != null) {
                currentValue = anObject;

                Enumeration enum1 = cache.elements();
                while (enum1.hasMoreElements()) {
                    Object le = enum1.nextElement();
                    if (le.equals(anObject)) {
                        currentValue = le;
                        break;
                    }
                }
            }

            fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return currentValue;
        }

        public int getSize() {
            validate();
            return cache.size();
        }

        public Object getElementAt(int index) {
            return cache.elementAt(index);
        }

        public void treeNodesChanged(TreeModelEvent e) {
            invalid = true;
        }

        public void treeNodesInserted(TreeModelEvent e) {
            invalid = true;
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            invalid = true;
        }

        public void treeStructureChanged(TreeModelEvent e) {
            invalid = true;
        }

        void validate() {
            if (invalid) {
                cache = new Vector();
                cacheTree(source.getRoot());
                if (cache.size() > 0) {
                    currentValue = cache.elementAt(0);
                }
                invalid = false;
                fireContentsChanged(this, 0, 0);
            }
        }

        void cacheTree(Object anObject) {

            if (source.isLeaf(anObject)) {
                cache.addElement(anObject);
            }
            else {
                int c = source.getChildCount(anObject);
                int i;
                Object child;
                cache.addElement(anObject);
                for (i = 0; i < c; i++) {
                    child = source.getChild(anObject, i);
                    cacheTree(child);
                }

            }
        }

    }

    static Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    class ListEntryRenderer extends JLabel implements ListCellRenderer {

        Icon leafIcon = (Icon) UIManager.get("Tree.expandedIcon");//SwingSet.sharedInstance().loadImageIcon("images/document.gif","Document");
        Icon nodeIcon = (Icon) UIManager.get("Tree.collapsedIcon");//SwingSet.sharedInstance().loadImageIcon("images/folder.gif","Folder");

        public ListEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(
                JList listbox,
                Object value,
                int index,
                boolean isSelected,
                boolean cellHasFocus) {



            DefaultMutableTreeNode treeEntry = (DefaultMutableTreeNode) value;

            //ListEntry listEntry = (ListEntry) value;
            if (treeEntry != null) {
                Border border;
                setText(treeEntry.toString());
                setIcon(treeEntry.isLeaf() ? leafIcon : nodeIcon );
                if (index != -1) {
                    border = new EmptyBorder(0, OFFSET * treeEntry.getLevel(), 0, 0);
                } else {
                    border = emptyBorder;
                }

                if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                    if (index == -1) {
                        this.setOpaque(false);
                    } else {
                        this.setOpaque(true);
                    }
                } else {
                    this.setOpaque(true);
                }

                this.setBorder(border);
                if (isSelected) {


                    this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));

                    this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else {
                    this.setBackground(UIManager.getColor("ComboBox.background"));
                    this.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
            } else {
                setText("");
            }
            return this;
        }
    }
}
