package net.yura.translation;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.MutableTreeNode;
import java.util.Locale;
import java.util.HashMap;
import java.util.Collections;
import java.util.Enumeration;

public class MyNode extends DefaultMutableTreeNode {

	private boolean hasmessage;
	private HashMap map;

	private boolean haschildren;
	private boolean needchildren;

	private boolean workneeded;

	// used when getting nodes from the plugin
	public MyNode(String name, boolean hasm, boolean hasch) {

		super(name);

		hasmessage = hasm;

		haschildren = hasch;

		setup();

	}

	// used when adding new nodes
	protected MyNode(String name, boolean a) {

		super(name);

		if (a) {
			hasmessage = true;
			map = new HashMap();
		}
		else {

			haschildren = true;

		}
	}

	private void setup() {


		if (haschildren && isLeaf() ) {

			add( new MyNode(null,false,false) );
			needchildren = true;
		}

		if (hasmessage && map==null) {

			map = new HashMap();

		}


	}

	public void removeAllChildren() {

		if (haschildren) {

			super.removeAllChildren();
			setup();

		}

	}

	public void add(MutableTreeNode newChild) {

		if (this.children!=null) {
                    MyNode newNode = ((MyNode)newChild);
                    for (int c=0;c<children.size();c++) {
                        MyNode child = (MyNode)children.elementAt(c);
                        if (child.getUserObject().equals( newNode.getUserObject() )) {
                            
                            if ( !child.hasMessage() && newNode.hasMessage() ) {
				child.hasmessage = true;
				child.setup();
                            }
                            if ( !child.hasChildren() && newNode.hasChildren() ) {
				child.haschildren = true;
				child.setup();
                            }
                            
                            return;
                        }
                    }
                }

		super.add(newChild);
		Collections.sort(this.children,MessageTool.CASE_POSTERIORITY_ORDER);

	}

	public void setHasChildren(boolean b) { // only used for true for now

		haschildren = b;

	}

	public void setHasMessage(boolean b) { // only used for true for now

		hasmessage = b;
		setup();

	}

	public boolean hasMessage() {

		return hasmessage;

	}

	public boolean hasChildren() {

		return haschildren;

	}

	public boolean workNeeded() {

		return workneeded;

	}

	public void setWorkNeeded(boolean a) {

		workneeded=a;

	}

	public String reload(Mtcomm mycomm, PartnerNode p,Locale l) throws Exception {

		String m = mycomm.getMessage(this,p,l);
		map.put(l,m);

		return m;

	}

	public String getMessage(Mtcomm mycomm, PartnerNode p,Locale l) throws Exception {

		if (map.containsKey(l)) {

			return (String)map.get(l);

		}
		else {

			return reload(mycomm,p,l);
		}

	}

	public void saveMessage(Mtcomm mycomm, PartnerNode p, Locale l,String m,Locale currentlocale) throws Exception {

		mycomm.saveMessage(this,p,l,m);

		map.put(l,m);

                // too complex to work out exactly for each case what to do, so we just always check
		checkBackWorkNeeded(mycomm,currentlocale);

	}

	private void checkBackWorkNeeded(Mtcomm mycomm,Locale currentlocale) throws Exception {

                mycomm.setupMissingTranslation( this, currentlocale );

                if (workneeded) {
                    checkBackWorkNeededSetTrue();
		}
                else {
                    MyNode p = (MyNode)getParent();
                    if (p!=null && p.workNeeded()) {
                            p.checkBackWorkNeeded(mycomm,currentlocale);
                    }
                }
	}

	private void checkBackWorkNeededSetTrue() {
		workneeded = true;
		MyNode p = (MyNode)getParent();
		if (p!=null && !p.workNeeded()) {
			p.checkBackWorkNeededSetTrue();
		}
	}

	public void loadChildren(Mtcomm mycomm,Locale currentlocale) throws Exception {

		if (needchildren) {

			needchildren = false;

			//super.removeAllChildren();
			remove(0);

			mycomm.addChildren(this);

			if (workneeded && haschildren) {

				Enumeration en = children();

				while (en.hasMoreElements()) {

					MyNode node = (MyNode)en.nextElement();

					mycomm.setupMissingTranslation( node, currentlocale );
				}

			}

		}
	}

	/*
	 * This could maybe done better if u start at the leafs
	 * but then again that would make is slower with big open trees with little changes
	 */
	public void nodeWorkRefresh(Mtcomm mycomm,Locale currentlocale) throws Exception {

                // this is potentially long task, as it is recursive, so it may get Interrupted
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }

		boolean before = workneeded;

		mycomm.setupMissingTranslation( this, currentlocale );

		if (
			((before && !workneeded) || workneeded) &&
			!needchildren &&
			haschildren
		) {

			Enumeration en = children();

			while (en.hasMoreElements()) {

				MyNode node = (MyNode)en.nextElement();

				node.nodeWorkRefresh(mycomm, currentlocale);
			}

		}
	}

	public String getName() {

		TreeNode[] path = getPath();

		StringBuffer buffer = new StringBuffer();

		for (int c=1; c<path.length;c++) {

			buffer.append(path[c]);
			if (c<path.length-1) { buffer.append("."); }

		}

		return buffer.toString();

	}

	public MyNode getChild(String s) {

		if ( isLeaf() ) { return null; }

		int a = Collections.binarySearch(this.children, s, MessageTool.CASE_POSTERIORITY_ORDER);

		if (a<0) { return null; }

		return (MyNode)this.children.elementAt(a);

	}
}
