package net.yura.translation.plugins;



import java.io.*;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.yura.util.StringsProperties;

public class StringsComm extends PropertiesComm {

    public void setupFilter(JFileChooser fc) {
        FileFilter ff = new FileFilter() {

            public boolean accept(File f) {
                return (f.isDirectory() || (f.getName().toLowerCase().endsWith(".strings")));
            }

            public String getDescription() {
                return "Strings Files (*.strings)";
            }
        };
        fc.addChoosableFileFilter(ff);
        fc.setFileFilter(ff);
    }

    public Properties load(FileInputStream in) throws Exception {

        StringsProperties sp = new StringsProperties();
        sp.loadFromStrings(in);
        return sp;
    }

    public void store(Properties p, FileOutputStream out, String a) throws Exception {

        ((StringsProperties)p).storeToStrings(out, a + "\n" + toString());
    }

    public String toString() {

        return "Apple Strings plugin";

    }
}
