package net.yura.translation.plugins;

import junit.framework.TestCase;

/**
 * @author Yura Mamyrin
 */
public class AuthenticationTest extends TestCase {

    /**
     * Test of getUsername method, of class NetComm.
     */
    public void testGetUsername() {
        System.out.println("getUsername");

        assertEquals( "" , NetComm.getUsername(":bob@host:8080") );
        assertEquals( "" , NetComm.getUsername(":1:2@host:8080") );
        assertEquals( "" , NetComm.getUsername(":1@2@host:8080") );
        assertEquals( "" , NetComm.getUsername("host:8080") );
        assertEquals( "" , NetComm.getUsername("host") ); // HOST
        assertEquals( "fred" , NetComm.getUsername("fred:bob@host:8080") );
        assertEquals( "fred" , NetComm.getUsername("fred:1:2@host:8080") );
        assertEquals( "fred" , NetComm.getUsername("fred:1@2@host:8080") );
        assertEquals( "fred" , NetComm.getUsername("fred@host:8080") );
        assertEquals( "fred" , NetComm.getUsername("fred@host") );
        assertEquals( "fred" , NetComm.getUsername("fred@") ); // USERNAME
        assertEquals( "" , NetComm.getUsername("") );
        assertEquals( "fred" , NetComm.getUsername("fred@:8080") );
        assertEquals( "" , NetComm.getUsername(":bob@:8080") );
        assertEquals( "" , NetComm.getUsername(":bob@") ); // PASSWORD
        assertEquals( "" , NetComm.getUsername(":8080") ); // PORT
        assertEquals( "fred" , NetComm.getUsername("fred:bob@host:ip:v6:8080") );
    }

    /**
     * Test of getPassword method, of class NetComm.
     */
    public void testGetPassword() {
        System.out.println("getPassword");

        assertEquals( "bob" , NetComm.getPassword(":bob@host:8080") );
        assertEquals( "1:2" , NetComm.getPassword(":1:2@host:8080") );
        assertEquals( "1@2" , NetComm.getPassword(":1@2@host:8080") );
        assertEquals( "" , NetComm.getPassword("host:8080") );
        assertEquals( "" , NetComm.getPassword("host") );
        assertEquals( "bob" , NetComm.getPassword("fred:bob@host:8080") );
        assertEquals( "1:2" , NetComm.getPassword("fred:1:2@host:8080") );
        assertEquals( "1@2" , NetComm.getPassword("fred:1@2@host:8080") );
        assertEquals( "" , NetComm.getPassword("fred@host:8080") );
        assertEquals( "" , NetComm.getPassword("fred@host") );
        assertEquals( "" , NetComm.getPassword("fred@") );
        assertEquals( "" , NetComm.getPassword("") );
        assertEquals( "" , NetComm.getPassword("fred@:8080") );
        assertEquals( "bob" , NetComm.getPassword(":bob@:8080") );
        assertEquals( "bob" , NetComm.getPassword(":bob@") );
        assertEquals( "" , NetComm.getPassword(":8080") );
        assertEquals( "bob" , NetComm.getPassword("fred:bob@host:ip:v6:8080") );
    }

    /**
     * Test of getServer method, of class NetComm.
     */
    public void testGetServer() {
        System.out.println("getServer");

        assertEquals( "host" , NetComm.getServer(":bob@host:8080") );
        assertEquals( "host" , NetComm.getServer(":1:2@host:8080") );
        assertEquals( "host" , NetComm.getServer(":1@2@host:8080") );
        assertEquals( "host" , NetComm.getServer("host:8080") );
        assertEquals( "host" , NetComm.getServer("host") );
        assertEquals( "host" , NetComm.getServer("fred:bob@host:8080") );
        assertEquals( "host" , NetComm.getServer("fred:1:2@host:8080") );
        assertEquals( "host" , NetComm.getServer("fred:1@2@host:8080") );
        assertEquals( "host" , NetComm.getServer("fred@host:8080") );
        assertEquals( "host" , NetComm.getServer("fred@host") );
        assertEquals( "" , NetComm.getServer("fred@") );
        assertEquals( "" , NetComm.getServer("") );
        assertEquals( "" , NetComm.getServer("fred@:8080") );
        assertEquals( "" , NetComm.getServer(":bob@:8080") );
        assertEquals( "" , NetComm.getServer(":bob@") );
        assertEquals( "" , NetComm.getServer(":8080") );
        assertEquals( "host:ip:v6" , NetComm.getServer("fred:bob@host:ip:v6:8080") );
    }

    /**
     * Test of getPort method, of class NetComm.
     */
    public void testGetPort() {
        System.out.println("getPort");

        assertEquals( "8080" , NetComm.getPort(":bob@host:8080") );
        assertEquals( "8080" , NetComm.getPort(":1:2@host:8080") );
        assertEquals( "8080" , NetComm.getPort(":1@2@host:8080") );
        assertEquals( "8080" , NetComm.getPort("host:8080") );
        assertEquals( "" , NetComm.getPort("host") );
        assertEquals( "8080" , NetComm.getPort("fred:bob@host:8080") );
        assertEquals( "8080" , NetComm.getPort("fred:1:2@host:8080") );
        assertEquals( "8080" , NetComm.getPort("fred:1@2@host:8080") );
        assertEquals( "8080" , NetComm.getPort("fred@host:8080") );
        assertEquals( "" , NetComm.getPort("fred@host") );
        assertEquals( "" , NetComm.getPort("fred@") );
        assertEquals( "" , NetComm.getPort("") );
        assertEquals( "8080" , NetComm.getPort("fred@:8080") );
        assertEquals( "8080" , NetComm.getPort(":bob@:8080") );
        assertEquals( "" , NetComm.getPort(":bob@") );
        assertEquals( "8080" , NetComm.getPort(":8080") );
        assertEquals( "8080" , NetComm.getPort("fred:bob@host:ip:v6:8080") );
    }

}
