/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package net.yura.translation.plugins.xcode;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import net.yura.translation.Result;
import net.yura.util.CommentStrippingReader;
import net.yura.util.StringsProperties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.plist.PropertyListConfiguration;

/**
 *
 * @author user30
 */
class Project {

    private final Locale DEFAULT;
    private final File file, screen, description;
    private final PropertyListConfiguration properties = new PropertyListConfiguration();
    private final HashMap<Locale, Localization> map = new HashMap();
    private final StringsProperties screens = new StringsProperties();
    private final StringsProperties descriptions = new StringsProperties();
    private long lastKeyAdded;

    public Project(File xcodeproj, File lproj) throws IOException {
        
        String name = lproj.getName();
        name = name.substring(0, name.length()-6);
        
        String[] names = name.split("-");
        switch (names.length) {
            case 1: DEFAULT = new Locale(names[0]); break;
            case 2: DEFAULT = new Locale(names[0],names[1]); break;
            case 3: DEFAULT = new Locale(names[0],names[1],names[2]); break;
            default: throw new RuntimeException();
        }
        
        this.file = new File(xcodeproj, "project.pbxproj");
        File translationDir = new File(xcodeproj.getParentFile(),"translation");
        new File(translationDir, "screens").mkdirs();

        screen = new File(translationDir, "screens.strings");
        if (screen.exists()) {
            screens.loadFromStrings(new FileInputStream(screen));
        }

        description = new File(translationDir, "descriptions.strings");
        if (description.exists()) {
            descriptions.loadFromStrings(new FileInputStream(description));
        }

        try {
            properties.load(new CommentStrippingReader(new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"))));
            map.put(null, new Localization(lproj));
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    public String getProperty(String name, Locale locale) {
        if (XcodeComm.SCREEN_LOCALE.equals(locale)) {
            return screens.getProperty(name);
        }
        if (XcodeComm.DESCRIPTION_LOCALE.equals(locale)) {
            return descriptions.getProperty(name);
        }
        return getLocalization(locale).getProperty(name);
    }

    public Localization getLocalization(Locale locale) {
        Localization localization = map.get(locale);
        if (localization == null) {
            localization = Localization.fromLocale(locale, map.get(null));
            map.put(locale, localization);
        }
        return localization;
    }

    public File[] getScreens(String key) {
        String filenames[] = screens.getProperty(key, "").split(",");
        File[] files = new File[filenames.length == 1 && filenames[0].length() == 0 ? 0 : filenames.length];
        for (int i = 0; i < files.length; i++) {
            files[i] = new File(screen.getParent() + "/screens", filenames[i]);
        }
        return files;
    }

    public void addScreen(String name,byte[] bytes) throws IOException {
        File destFile = getScreenFile(name);
        FileOutputStream fos = new FileOutputStream(destFile);
        fos.write(bytes);
        fos.close(); 
    }
    public boolean fileExists(String name) {
        return getScreenFile(name).exists();
    }
    public File getScreenFile(String name) {
        return new File( new File(screen.getParentFile(),"/screens") , name);
    }
    
    public void addScreen(File file) throws IOException {

        File destFile = getScreenFile(file.getName());

        if (!destFile.exists()) {
            destFile.createNewFile();

            FileChannel source = null;
            FileChannel destination = null;
            try {
                source = new FileInputStream(file).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                destination.transferFrom(source, 0, source.size());
            }
            finally {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
            }

        }

/*
        Process process = Runtime.getRuntime().exec(new String[]{"cp", "-n", file.getAbsolutePath(), screen.getParent() + "/screens"});
        while (true) {
            try {
                process.waitFor();
                break;
            }
            catch (InterruptedException e) {
            }
        }
*/
        // NOT SURE WHY THIS WAS HERE??
        // this was also matching too many string, as text.info is NOT the same as text.info.screen
        //for (Enumeration e = propertyNames(); e.hasMoreElements();) {
        //    String key = e.nextElement().toString();
        //    if (key.startsWith(prefix)) {
//                screens.setProperty(prefix, file.getName() + "," + screens.getProperty(prefix, ""));
        //    }
        //}
//        screens.storeToStrings(new FileOutputStream(screen), null);
    }
/*
    public void removeScreen(String key, File file) {
        try {
            String v = screens.getProperty(key, "").replace(file.getName() + ",", "");
            if(v.length()==0)
                screens.remove(key);
            else
                screens.setProperty(key, v);
            screens.storeToStrings(new FileOutputStream(screen), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
*/
    public void setProperty(String key, Locale l, String value, boolean spellingOnly) throws Exception {
        if (XcodeComm.SCREEN_LOCALE.equals(l)) {
            if (value==null || "".equals(value)) {
                if ("".equals(value)) {
                    System.err.println("[WARN] trying to save a empty string to screens key: "+key+" saving null instead");
                }
                screens.remove(key);
            }
            else {
                screens.setProperty(key, value);
            }
            screens.storeToStrings(new FileOutputStream(screen), null);
            return;
        }

        if (XcodeComm.DESCRIPTION_LOCALE.equals(l)) {
            if (value==null || "".equals(value)) {
                if ("".equals(value)) {
                    System.err.println("[WARN] trying to save a empty string to descriptions key: "+key+" saving null instead");
                }
                descriptions.remove(key);
            }
            else {
                descriptions.setProperty(key, value);
            }
            descriptions.storeToStrings(new FileOutputStream(description), null);
            return;
        }
        
        Localization localization = map.get(l);
        Localization defaultLocale = map.get(null);
        
        if (localization == defaultLocale && spellingOnly) {
            String oldString = defaultLocale.getProperty(key);
            localization.setProperty(key, value, defaultLocale, this);

            Locale[] locales = getLocales();
            for (Locale locale:locales) {
                localization = getLocalization(locale);
                if (localization!=null) { // should never be null, but just in case
                    String whatWasTranslated = localization.getTranslations().getProperty(key);
                    //if (oldString.equals(whatWasTranslated)) {
                        String string = localization.getProperty(key);
                        if (string!=null) {
                            localization.setProperty(key, string, defaultLocale, this);
                        }
                    //}
                }
            }
        }
        else {
            localization.setProperty(key, value, defaultLocale, this);
        }

        if (lastKeyAdded > 0) {
            properties.save(file);
            lastKeyAdded = 0;
        }
    }

    public void findString(String string, Vector results) throws Exception {
        
        Localization defaultLocale = map.get(null);
        defaultLocale.findString(null, string, results, defaultLocale ); // search default first

        Locale[] locales = getLocales();
        for (Locale locale:locales) {
            if (XcodeComm.SCREEN_LOCALE.equals(locale)) {
                if (string!=null) {
                    Localization.search(locale, string, results, screens);
                }
                else {
                    for (Enumeration<String> it = defaultLocale.propertyNames();it.hasMoreElements();) {
                        String key = it.nextElement();
                        if (screens.get(key)==null) {
                            results.add(new Result(key, locale, null));
                        }
                    }
                }
            }
            else {
                Localization localization = getLocalization(locale);
                if (!localization.isEmpty()) {
                    localization.findString(locale, string, results, defaultLocale );
                }
            }
        }
        // OLD method, does not search everything
        //for (Map.Entry<Locale, Localization> entry : map.entrySet()) {
        //    entry.getValue().findString(entry.getKey(), string, results,  map.get(null) );
        //}
    }

    public Enumeration propertyNames() {
        return map.get(null).propertyNames();
    }

    private String fileAdded(File file) {
        String key = Long.toString(Math.max(lastKeyAdded + 1, lastKeyAdded = System.currentTimeMillis()), 16).toUpperCase();
        properties.setProperty("objects." + key + ".isa", "PBXFileReference");
        properties.setProperty("objects." + key + ".name", file.getParentFile().getName().substring(0, file.getParentFile().getName().indexOf('.')));
        properties.setProperty("objects." + key + ".path", file.getPath().substring(file.getParentFile().getParent().length() + 1));
        properties.setProperty("objects." + key + ".sourceTree", "<group>");
        for (Iterator i = properties.getKeys("objects."); i.hasNext();) {
            String k = i.next().toString();
            if (k.endsWith("name") && properties.getProperty(k).equals(file.getName())) {
                properties.addProperty(k.substring(0, k.lastIndexOf('.')) + ".children", key);
                break;
            }
        }
        return key;
    }

    void localizationAdded(File file) {
        String key = fileAdded(file);
        properties.setProperty("objects." + key + ".fileEncoding", "10");
        properties.setProperty("objects." + key + ".lastKnownFileType", "text.plist.strings");
    }

    void nibAdded(File file) {
        String key = fileAdded(file);
        properties.setProperty("objects." + key + ".lastKnownFileType", "file.xib");
    }
    
    public Locale[] getLocales() {

        List alist = new ArrayList( Arrays.asList( Locale.getAvailableLocales() ) );
        
        Locale tl = new Locale("tl"); // Tagalog
        if (!alist.contains(tl)) {
            alist.add(tl);
        }
        Locale hi = new Locale("hi"); // Hindi
        if (!alist.contains(hi)) {
            alist.add(hi);
        }
        Locale nb = new Locale("nb"); // Norwegian Bokmål
        if (!alist.contains(nb)) {
            alist.add(nb);
        }
        Locale bs = new Locale("bs"); // Bosnian
        if (!alist.contains(bs)) {
            alist.add(bs);
        }

        // if we have the default in this list, then remove it
        alist.remove(DEFAULT);

        // sort
        Collections.sort(alist, new Comparator() {
            public int compare(Object o1, Object o2) {
                // put screens locale at the end
                //if (o1 == SCREEN_LOCALE && o2 == SCREEN_LOCALE) return 0;
                //if (o1 == SCREEN_LOCALE) return 1;
                //if (o2 == SCREEN_LOCALE) return -1;
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });

        alist.add(XcodeComm.SCREEN_LOCALE);

        // add screens locale to the end
        Locale l[] = new Locale[alist.size()];
        alist.toArray(l);
        return l;
    }
    
    /**
     * Mac OS uses "-" and not "_"
     */
    public static String toString(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();

        if ("zh".equals(language) && "CN".equals(country) && "".equals(variant)) {
            return "zh-Hans"; // Chinese (Simplified)
        }
        if ("zh".equals(language) && "TW".equals(country) && "".equals(variant)) {
            return "zh-Hant"; // Chinese (Traditional)
        }

        boolean l = language.length() != 0;
        boolean c = country.length() != 0;
        boolean v = variant.length() != 0;
        StringBuilder result = new StringBuilder(language);
        if (c||(l&&v)) {
            result.append('-').append(country); // This may just append '_'
        }
        if (v&&(l||c)) {
            result.append('-').append(variant);
        }
        return result.toString();
    }

    
}
