/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.yura.lobby.gen.ProtoLobby;
import net.yura.mobile.io.proto.CodedOutputStream;

public class ProtoAccess
extends ProtoLobby {
    ObjectProvider objectProvider;

    public ProtoAccess(ObjectProvider op) {
        this.objectProvider = op;
    }

    protected Object getObjectId(Object object) {
        return this.objectProvider.getObjectId(object);
    }

    protected Object getObjetById(Object id, Class clas) {
        return this.objectProvider.getObjetById(id, clas);
    }

    protected int getObjectTypeEnum(Object obj) {
        if (obj instanceof Map) {
            return 12;
        }
        if (obj instanceof List) {
            return 10;
        }
        return super.getObjectTypeEnum(obj);
    }

    protected int computeVectorSize(Object list) {
        List vector = (List)list;
        int size = 0;
        for (int c = 0; c < vector.size(); ++c) {
            int s = this.computeAnonymousObjectSize(vector.get(c));
            size += CodedOutputStream.computeBytesSize((int)1, (int)s);
        }
        return size;
    }

    protected int computeHashtableSize(Object map) {
        Map hashtable = (Map)map;
        int totalSize = 0;
        Iterator enu = hashtable.keySet().iterator();
        while (enu.hasNext()) {
            Object key = enu.next();
            Object value = hashtable.get(key);
            int keySize = this.computeAnonymousObjectSize(key);
            int valueSize = this.computeAnonymousObjectSize(value);
            int size1 = CodedOutputStream.computeBytesSize((int)1, (int)keySize);
            int size2 = CodedOutputStream.computeBytesSize((int)2, (int)valueSize);
            int s = CodedOutputStream.computeBytesSize((int)1, (int)(size1 + size2));
            totalSize += s;
        }
        return totalSize;
    }

    protected void encodeVector(CodedOutputStream out, Object list) throws IOException {
        List vector = (List)list;
        for (int c = 0; c < vector.size(); ++c) {
            Object obj = vector.get(c);
            out.writeBytes(1, this.computeAnonymousObjectSize(obj));
            this.encodeAnonymousObject(out, obj);
        }
    }

    protected void encodeHashtable(CodedOutputStream out, Object map) throws IOException {
        Map hashtable = (Map)map;
        Iterator enu = hashtable.keySet().iterator();
        while (enu.hasNext()) {
            Object key = enu.next();
            Object value = hashtable.get(key);
            int keySize = this.computeAnonymousObjectSize(key);
            int valueSize = this.computeAnonymousObjectSize(value);
            int size1 = CodedOutputStream.computeBytesSize((int)1, (int)keySize);
            int size2 = CodedOutputStream.computeBytesSize((int)2, (int)valueSize);
            out.writeBytes(1, size1 + size2);
            out.writeBytes(1, keySize);
            this.encodeAnonymousObject(out, key);
            out.writeBytes(2, valueSize);
            this.encodeAnonymousObject(out, value);
        }
    }

    public static interface ObjectProvider {
        public Object getObjectId(Object var1);

        public Object getObjetById(Object var1, Class var2);
    }
}

