/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TcpClient
implements Runnable {
    protected static final Logger LOG;
    private static final long INITIAL_RECONNECT_INTERVAL = 500L;
    private static final long MAXIMUM_RECONNECT_INTERVAL = 30000L;
    private static final int READ_BUFFER_SIZE = 0x100000;
    private static final int WRITE_BUFFER_SIZE = 0x100000;
    private long reconnectInterval = 500L;
    private ByteBuffer readBuf = ByteBuffer.allocateDirect(0x100000);
    private ByteBuffer writeBuf = ByteBuffer.allocateDirect(0x100000);
    private final Thread thread = new Thread(null, this, "TCP-Client", 100000000L);
    private String address;
    private int port;
    private Selector selector;
    private SocketChannel channel;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private AtomicLong bytesOut = new AtomicLong(0L);
    private AtomicLong bytesIn = new AtomicLong(0L);
    static final /* synthetic */ boolean $assertionsDisabled;

    public void init() {
        if (!$assertionsDisabled && this.address == null) {
            throw new AssertionError((Object)"server address missing");
        }
    }

    public void start() {
        LOG.info("starting event loop");
        this.thread.start();
    }

    public void join() throws InterruptedException {
        if (Thread.currentThread().getId() != this.thread.getId()) {
            this.thread.join();
        }
    }

    public void stop() {
        LOG.info("stopping event loop");
        this.thread.interrupt();
        this.selector.wakeup();
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBuffer buffer) throws InterruptedException, IOException {
        if (!this.connected.get()) {
            throw new IOException("not connected");
        }
        ByteBuffer byteBuffer = this.writeBuf;
        synchronized (byteBuffer) {
            int bytesTotal;
            int bytesOp;
            if (this.writeBuf.remaining() < buffer.remaining()) {
                this.writeBuf.flip();
                bytesOp = 0;
                bytesTotal = 0;
                while (this.writeBuf.hasRemaining() && (bytesOp = this.channel.write(this.writeBuf)) > 0) {
                    bytesTotal += bytesOp;
                }
                this.writeBuf.compact();
            }
            if (Thread.currentThread().getId() != this.thread.getId()) {
                while (this.writeBuf.remaining() < buffer.remaining()) {
                    this.writeBuf.wait();
                }
            } else if (this.writeBuf.remaining() < buffer.remaining()) {
                throw new IOException("send buffer full");
            }
            this.writeBuf.put(buffer);
            this.writeBuf.flip();
            bytesOp = 0;
            bytesTotal = 0;
            while (this.writeBuf.hasRemaining() && (bytesOp = this.channel.write(this.writeBuf)) > 0) {
                bytesTotal += bytesOp;
            }
            this.writeBuf.compact();
            if (this.writeBuf.hasRemaining()) {
                SelectionKey key = this.channel.keyFor(this.selector);
                key.interestOps(key.interestOps() | 4);
                this.selector.wakeup();
            }
        }
    }

    protected abstract void onRead(ByteBuffer var1) throws Exception;

    protected abstract void onConnected() throws Exception;

    protected abstract void onDisconnected();

    private void configureChannel(SocketChannel channel) throws IOException {
        channel.configureBlocking(false);
        channel.socket().setSendBufferSize(0x100000);
        channel.socket().setReceiveBufferSize(0x100000);
        channel.socket().setKeepAlive(true);
        channel.socket().setReuseAddress(true);
        channel.socket().setSoLinger(false, 0);
        channel.socket().setSoTimeout(0);
        channel.socket().setTcpNoDelay(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.info("event loop running");
        try {
            while (!Thread.interrupted()) {
                try {
                    this.selector = Selector.open();
                    this.channel = SocketChannel.open();
                    this.configureChannel(this.channel);
                    this.channel.connect(new InetSocketAddress(this.address, this.port));
                    this.channel.register(this.selector, 8);
                    while (!this.thread.isInterrupted() && this.channel.isOpen()) {
                        if (this.selector.select() <= 0) continue;
                        this.processSelectedKeys(this.selector.selectedKeys());
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, "io exception", e);
                }
                catch (UnresolvedAddressException e) {
                    LOG.log(Level.INFO, "exception", e);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "exception", e);
                }
                finally {
                    this.connected.set(false);
                    this.onDisconnected();
                    this.writeBuf.clear();
                    this.readBuf.clear();
                    if (this.channel != null) {
                        this.channel.close();
                    }
                    if (this.selector != null) {
                        this.selector.close();
                    }
                    LOG.info("connection closed");
                }
                try {
                    Thread.sleep(this.reconnectInterval);
                    if (this.reconnectInterval < 30000L) {
                        this.reconnectInterval *= 2L;
                    }
                    LOG.info("reconnecting to " + this.address + ":" + this.port);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "unrecoverable error", e);
        }
        LOG.info("event loop terminated");
    }

    private void processSelectedKeys(Set keys) throws Exception {
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            SelectionKey key = (SelectionKey)itr.next();
            if (key.isReadable()) {
                this.processRead(key);
            }
            if (key.isWritable()) {
                this.processWrite(key);
            }
            if (key.isConnectable()) {
                this.processConnect(key);
            }
            if (key.isAcceptable()) {
                // empty if block
            }
            itr.remove();
        }
    }

    private void processConnect(SelectionKey key) throws Exception {
        SocketChannel ch = (SocketChannel)key.channel();
        if (ch.finishConnect()) {
            LOG.info("connected to " + this.address + ":" + this.port);
            key.interestOps(key.interestOps() ^ 8);
            key.interestOps(key.interestOps() | 1);
            this.reconnectInterval = 500L;
            this.connected.set(true);
            this.onConnected();
        }
    }

    private void processRead(SelectionKey key) throws Exception {
        ReadableByteChannel ch = (ReadableByteChannel)((Object)key.channel());
        int bytesOp = 0;
        int bytesTotal = 0;
        while (this.readBuf.hasRemaining() && (bytesOp = ch.read(this.readBuf)) > 0) {
            bytesTotal += bytesOp;
        }
        if (bytesTotal > 0) {
            this.readBuf.flip();
            this.onRead(this.readBuf);
            this.readBuf.compact();
        } else if (bytesOp == -1) {
            LOG.info("peer closed read channel");
            ch.close();
        }
        this.bytesIn.addAndGet(bytesTotal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWrite(SelectionKey key) throws IOException {
        WritableByteChannel ch = (WritableByteChannel)((Object)key.channel());
        ByteBuffer byteBuffer = this.writeBuf;
        synchronized (byteBuffer) {
            this.writeBuf.flip();
            int bytesOp = 0;
            int bytesTotal = 0;
            while (this.writeBuf.hasRemaining() && (bytesOp = ch.write(this.writeBuf)) > 0) {
                bytesTotal += bytesOp;
            }
            this.bytesOut.addAndGet(bytesTotal);
            if (this.writeBuf.remaining() == 0) {
                key.interestOps(key.interestOps() ^ 4);
            }
            if (bytesTotal > 0) {
                this.writeBuf.notify();
            } else if (bytesOp == -1) {
                LOG.info("peer closed write channel");
                ch.close();
            }
            this.writeBuf.compact();
        }
    }

    public void setAddress(String address, int port) {
        this.address = address;
        this.port = port;
    }

    public long getBytesOut() {
        return this.bytesOut.get();
    }

    public long getBytesIn() {
        return this.bytesIn.get();
    }

    public static void main(String[] args) throws Exception {
        final TcpClient client = new TcpClient(){

            protected void onRead(ByteBuffer buf) throws Exception {
                buf.position(buf.limit());
            }

            protected void onDisconnected() {
            }

            protected void onConnected() throws Exception {
            }
        };
        client.setAddress("127.0.0.1", 20001);
        client.start();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                LOG.info("out bytes: " + client.bytesOut.get());
                LOG.info("in bytes:  " + client.bytesIn.get());
            }
        }, 5000L, 5000L);
        while (!client.isConnected()) {
            Thread.sleep(500L);
        }
        LOG.info("starting server flood");
        ByteBuffer buf = ByteBuffer.allocate(65535);
        Random rnd = new Random();
        while (true) {
            short len = (short)rnd.nextInt(32765);
            byte[] bytes = new byte[len];
            rnd.nextBytes(bytes);
            buf.putShort(len);
            buf.put(bytes);
            buf.flip();
            try {
                client.send(buf);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "exception: " + e.getMessage());
                while (!client.isConnected()) {
                    Thread.sleep(1000L);
                }
            }
            buf.clear();
            Thread.sleep(10L);
        }
    }

    static {
        $assertionsDisabled = !TcpClient.class.desiredAssertionStatus();
        LOG = Logger.getLogger(TcpClient.class.getName());
    }
}

