/*
 * Decompiled with CFR 0.152.
 */
package net.yura.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cache {
    static final Logger logger = Logger.getLogger(Cache.class.getName());
    public static final boolean DEBUG = false;
    File cacheDir;

    public Cache(String appName) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        this.cacheDir = new File(new File(tmpDir), appName + ".cache");
        if (!this.cacheDir.isDirectory() && !this.cacheDir.mkdirs()) {
            throw new RuntimeException("can not make cache dir: " + this.cacheDir);
        }
    }

    private File getFileName(String uid) {
        try {
            String fileName = URLEncoder.encode(uid, "UTF-8");
            return new File(this.cacheDir, fileName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void put(String key, byte[] value) {
        File file = this.getFileName(key);
        if (file.exists()) {
            logger.log(Level.WARNING, "[yura.net Cache] already has file: {0}", key);
        } else {
            try {
                FileOutputStream out = new FileOutputStream(file);
                out.write(value);
                out.close();
            }
            catch (Exception ex) {
                boolean exists = file.exists();
                boolean deleted = false;
                if (exists) {
                    deleted = file.delete();
                }
                logger.log(Level.WARNING, "failed to save data to file: " + file + " exists=" + exists + " deleted=" + deleted + " key: " + key + " in dir " + this.cacheDir + " exists=" + this.cacheDir.exists(), ex);
            }
        }
    }

    public InputStream get(String key) {
        File file = this.getFileName(key);
        if (file.exists()) {
            try {
                file.setLastModified(System.currentTimeMillis());
                return new FileInputStream(file);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public boolean containsKey(String key) {
        File file = this.getFileName(key);
        return file.exists();
    }
}

