/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination;

import java.util.WeakHashMap;
import javax.microedition.lcdui.Image;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.components.Component;

public class ImageManager {
    public final WeakHashMap images = new WeakHashMap();
    public final int w;
    public final int h;

    public ImageManager(int width, int height) {
        this.w = width;
        this.h = height;
    }

    public void put(Object key, LazyIcon icon) {
        this.images.put(key, icon);
    }

    public LazyIcon get(Object key) {
        LazyIcon icon = (LazyIcon)((Object)this.images.get(key));
        if (icon != null) {
            this.put(key, icon);
        }
        return icon;
    }

    public LazyIcon newIcon(Object key) {
        LazyIcon icon = new LazyIcon(this.w, this.h);
        this.put(key, icon);
        return icon;
    }

    public void gotImg(Object key, Image img) {
        LazyIcon icon = this.get(key);
        if (icon != null) {
            if (img != null) {
                icon.setImage(img);
            } else {
                this.images.remove(key);
            }
        }
    }

    public static class LazyIcon
    extends Icon {
        Image img;

        public LazyIcon(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public void setImage(Image img) {
            this.img = img;
        }

        public void paintIcon(Component c, Graphics2D g, int x, int y) {
            if (this.img != null) {
                g.drawScaledImage(this.img, x, y, this.width, this.height);
            }
        }

        public Image getImage() {
            return this.img;
        }
    }
}

