/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.RiskObjectOutputStream;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Mission;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.translation.MapTranslator;
import net.yura.domination.engine.translation.TranslationBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiskGame
implements Serializable {
    private static final long serialVersionUID = 8L;
    public static final String SAVE_VERSION = String.valueOf(8L);
    public static final String NETWORK_VERSION = "11";
    public static final int MAX_PLAYERS = 6;
    public static final Continent ANY_CONTINENT = new Continent("any", "any", 0, 0);
    public static final int STATE_NEW_GAME = 0;
    public static final int STATE_TRADE_CARDS = 1;
    public static final int STATE_PLACE_ARMIES = 2;
    public static final int STATE_ATTACKING = 3;
    public static final int STATE_ROLLING = 4;
    public static final int STATE_BATTLE_WON = 5;
    public static final int STATE_FORTIFYING = 6;
    public static final int STATE_END_TURN = 7;
    public static final int STATE_GAME_OVER = 8;
    public static final int STATE_SELECT_CAPITAL = 9;
    public static final int STATE_DEFEND_YOURSELF = 10;
    public static final int MODE_DOMINATION = 0;
    public static final int MODE_CAPITAL = 2;
    public static final int MODE_SECRET_MISSION = 3;
    public static final int CARD_INCREASING_SET = 0;
    public static final int CARD_FIXED_SET = 1;
    public static final int CARD_ITALIANLIKE_SET = 2;
    public static final int MAX_CARDS = 5;
    private static String defaultMap;
    private static String defaultCards;
    private Random r;
    private String mapfile;
    private String cardsfile;
    private int setup;
    private Vector Players;
    private Country[] Countries;
    private Continent[] Continents;
    private Vector Cards;
    private Vector usedCards;
    private Vector Missions;
    private Player currentPlayer;
    private int gameState;
    private int cardState;
    private int mustmove;
    private boolean capturedCountry;
    private boolean tradeCap;
    private int gameMode;
    private Country attacker;
    private Country defender;
    private int attackerDice;
    private int defenderDice;
    private transient int battleRounds;
    private String ImagePic;
    private String ImageMap;
    private String previewPic;
    private Map properties;
    private Vector replayCommands;
    private int maxDefendDice;
    private int cardMode;
    private boolean runmaptest = false;
    private boolean recycleCards = false;

    public RiskGame() throws Exception {
        this.setMapfile("default");
        this.setCardsfile("default");
        this.setup = 0;
        this.Players = new Vector();
        this.currentPlayer = null;
        this.gameState = 0;
        this.cardState = 0;
        this.replayCommands = new Vector();
        this.r = new Random();
    }

    public void addCommand(String a) {
        this.replayCommands.add(a);
    }

    public Vector getCommands() {
        return this.replayCommands;
    }

    public void setCommands(Vector replayCommands) {
        this.replayCommands = replayCommands;
    }

    public int getMaxDefendDice() {
        return this.maxDefendDice;
    }

    public boolean addPlayer(int type, String name, int color, String a) {
        if (this.gameState == 0) {
            for (int c = 0; c < this.Players.size(); ++c) {
                if (!name.equals(((Player)this.Players.elementAt(c)).getName()) && color != ((Player)this.Players.elementAt(c)).getColor()) continue;
                return false;
            }
            Player player = new Player(type, name, color, a);
            this.Players.add(player);
            return true;
        }
        return false;
    }

    public boolean delPlayer(String name) {
        if (this.gameState == 0) {
            int n = -1;
            for (int c = 0; c < this.Players.size(); ++c) {
                if (!name.equals(((Player)this.Players.elementAt(c)).getName())) continue;
                n = c;
            }
            if (n == -1) {
                return false;
            }
            this.Players.removeElementAt(n);
            this.Players.trimToSize();
            return true;
        }
        return false;
    }

    public void startGame(int mode, int card, boolean recycle, boolean threeDice) throws Exception {
        if (this.gameState == 0) {
            this.gameMode = mode;
            this.cardMode = card;
            this.recycleCards = recycle;
            int n = this.maxDefendDice = threeDice ? 3 : 2;
            if (this.mapfile != null && this.cardsfile != null) {
                this.loadMap();
                try {
                    this.loadCards(false);
                }
                catch (Exception e) {
                    if (this.runmaptest) {
                        throw new Exception("LOAD FILE ERROR: " + e.getMessage() + "\n(This normally means you have selected the wrong set of cards for this map)", e);
                    }
                    return;
                }
                if (this.runmaptest) {
                    this.testMap();
                }
            }
            if (this.Countries == null) {
                return;
            }
            if (this.gameMode == 3 && this.Missions.size() < this.Players.size()) {
                return;
            }
            int armies = (10 - this.Players.size()) * Math.round((float)this.Countries.length * 0.12f);
            for (int c = 0; c < this.Players.size(); ++c) {
                ((Player)this.Players.elementAt(c)).addArmies(armies);
            }
            this.gameState = 2;
            this.capturedCountry = false;
            this.tradeCap = false;
        }
    }

    public void testMap() throws Exception {
        for (int c = 0; c < this.Countries.length; ++c) {
            Country c1 = this.Countries[c];
            Vector c1neighbours = c1.getNeighbours();
            if (c1neighbours.contains(c1)) {
                throw new Exception("Error: " + c1.getName() + " neighbours with itself");
            }
            for (int a = 0; a < c1neighbours.size(); ++a) {
                Country c2 = (Country)c1neighbours.elementAt(a);
                Vector c2neighbours = c2.getNeighbours();
                boolean ok = false;
                for (int b = 0; b < c2neighbours.size(); ++b) {
                    Country c3 = (Country)c2neighbours.elementAt(b);
                    if (c1 != c3) continue;
                    ok = true;
                }
                if (ok) continue;
                throw new Exception("Borders error with: " + this.Countries[c].getName() + " (" + this.Countries[c].getColor() + ") and " + ((Country)c1neighbours.elementAt(a)).getName() + " (" + ((Country)c1neighbours.elementAt(a)).getColor() + ")");
            }
        }
    }

    public Player setCurrentPlayer(String name) {
        for (int c = 0; c < this.Players.size(); ++c) {
            if (!((Player)this.Players.elementAt(c)).getName().equals(name)) continue;
            this.currentPlayer = (Player)this.Players.elementAt(c);
        }
        return this.currentPlayer;
    }

    public String getRandomPlayer() {
        return ((Player)this.Players.elementAt(this.r.nextInt(this.Players.size()))).getName();
    }

    public String getDesrvedCard() {
        if (this.capturedCountry && this.Cards.size() > 0) {
            Card c = (Card)this.Cards.elementAt(this.r.nextInt(this.Cards.size()));
            if (c.getCountry() == null) {
                return "wildcard";
            }
            return c.getCountry().getColor() + "";
        }
        return "";
    }

    public boolean isCapturedCountry() {
        return this.capturedCountry;
    }

    public Player endGo() {
        if (this.gameState == 7) {
            int c;
            do {
                for (c = 0; c < this.Players.size(); ++c) {
                    if (this.currentPlayer == (Player)this.Players.elementAt(c) && this.Players.size() == c + 1) {
                        this.currentPlayer = (Player)this.Players.elementAt(0);
                        c = this.Players.size();
                        continue;
                    }
                    if (this.currentPlayer != (Player)this.Players.elementAt(c) || this.Players.size() == c + 1) continue;
                    this.currentPlayer = (Player)this.Players.elementAt(c + 1);
                    c = this.Players.size();
                }
            } while (this.setup == this.Players.size() && this.currentPlayer.getNoTerritoriesOwned() <= 0);
            if (this.setup == this.Players.size() && (this.gameMode != 2 || this.currentPlayer.getCapital() != null)) {
                this.workOutEndGoStats(this.currentPlayer);
                this.currentPlayer.nextTurn();
                if (this.currentPlayer.getNoTerritoriesOwned() < 9) {
                    this.currentPlayer.addArmies(3);
                } else {
                    this.currentPlayer.addArmies(this.currentPlayer.getNoTerritoriesOwned() / 3);
                }
                for (c = 0; c < this.Continents.length; ++c) {
                    if (!this.Continents[c].isOwned(this.currentPlayer)) continue;
                    this.currentPlayer.addArmies(this.Continents[c].getArmyValue());
                }
            }
            this.gameState = this.setup == this.Players.size() && this.gameMode == 2 && this.currentPlayer.getCapital() == null ? 9 : (!this.canTrade() ? 2 : 1);
            this.capturedCountry = false;
            this.tradeCap = false;
            return this.currentPlayer;
        }
        return null;
    }

    public int trade(Card card1, Card card2, Card card3) {
        if (this.gameState != 1) {
            return 0;
        }
        if (this.tradeCap && this.currentPlayer.getCards().size() < 5) {
            throw new RuntimeException("trying to do a trade when less then 5 cards and tradeCap is on");
        }
        int armies = this.getTradeAbsValue(card1.getName(), card2.getName(), card3.getName(), this.cardMode);
        if (armies <= 0) {
            return 0;
        }
        if (this.cardMode == 0) {
            this.cardState = armies;
        }
        this.currentPlayer.tradeInCards(card1, card2, card3);
        Vector used = this.getUsedCards();
        used.add(card1);
        used.add(card2);
        used.add(card3);
        this.currentPlayer.addArmies(armies);
        if (!this.canTrade() || this.tradeCap && this.currentPlayer.getCards().size() < 5) {
            this.gameState = 2;
            this.tradeCap = false;
        }
        return this.cardState;
    }

    public int getTradeAbsValue(String c1, String c2, String c3, int cardMode) {
        String n4;
        int armies = 0;
        if (!c1.equals("wildcard")) {
            n4 = c3;
            c3 = c1;
            c1 = n4;
        }
        if (!c2.equals("wildcard")) {
            n4 = c3;
            c3 = c2;
            c2 = n4;
        }
        if (!c1.equals("wildcard")) {
            n4 = c2;
            c2 = c1;
            c1 = n4;
        }
        if (cardMode == 0) {
            if (c1.equals("wildcard") || c1.equals(c2) && c1.equals(c3) || !c1.equals(c2) && !c1.equals(c3) && !c2.equals(c3)) {
                armies = this.getNewCardState();
            }
        } else if (cardMode == 1) {
            if ((c1.equals(c2) || c1.equals("wildcard")) && c2.equals(c3)) {
                armies = c3.equals("Infantry") ? 4 : (c3.equals("Cavalry") ? 6 : (c3.equals("Cannon") ? 8 : 12));
            } else if (c1.equals("wildcard") && c2.equals("wildcard") || !c1.equals(c2) && !c2.equals(c3) && !c1.equals(c3)) {
                armies = 10;
            }
        } else {
            armies = c1.equals(c2) && c1.equals(c3) ? (c1.equals("Cavalry") ? 8 : (c1.equals("Infantry") ? 6 : (c1.equals("Cannon") ? 4 : 0))) : (!c1.equals(c2) && !c2.equals(c3) && !c1.equals(c3) && !c1.equals("wildcard") ? 10 : (c1.equals("wildcard") && c2.equals(c3) ? 12 : 0));
        }
        return armies;
    }

    public boolean canTrade() {
        return this.getBestTrade(this.currentPlayer.getCards(), 0, null) > 0;
    }

    public int getBestTrade(List<Card> cards, int tradesToScan, Card[] bestResult) {
        return this.getBestTrade(cards, new boolean[cards.size()], tradesToScan, cards.size(), bestResult, 0);
    }

    private int getBestTrade(List<Card> cards, boolean[] used, int tradesToScan, int cardsRemaining, Card[] bestResult, int start) {
        cardsRemaining -= 3;
        int bestValue = 0;
        int orig = tradesToScan;
        HashSet<IntermediateResult> seen = null;
        Card carda = null;
        Card cardb = null;
        Card cardc = null;
        for (int a = start; a < cards.size() - 2; ++a) {
            if (used[a]) continue;
            carda = cards.get(a);
            for (int b = a + 1; b < cards.size() - 1; ++b) {
                if (used[b]) continue;
                cardb = cards.get(b);
                for (int c = b + 1; c < cards.size(); ++c) {
                    if (used[c]) continue;
                    cardc = cards.get(c);
                    --tradesToScan;
                    int value = this.getTradeAbsValue(carda.getName(), cardb.getName(), cardc.getName(), this.getCardMode());
                    if (value == 0) {
                        if (tradesToScan >= 0 || bestValue <= 0) continue;
                        return bestValue;
                    }
                    if (cardsRemaining >= 3 && orig > 0) {
                        IntermediateResult ir = new IntermediateResult();
                        ir.types = new String[3];
                        ir.types[0] = carda.getName();
                        ir.types[1] = cardb.getName();
                        ir.types[2] = cardc.getName();
                        Arrays.sort(ir.types);
                        if (seen == null) {
                            seen = new HashSet<IntermediateResult>();
                        }
                        if (!seen.add(ir)) continue;
                        used[a] = true;
                        used[b] = true;
                        used[c] = true;
                        value += this.getBestTrade(cards, used, tradesToScan, cardsRemaining, null, start + 1);
                        used[a] = false;
                        used[b] = false;
                        used[c] = false;
                    }
                    if (value > bestValue) {
                        bestValue = value;
                        if (bestResult != null) {
                            bestResult[0] = cards.get(a);
                            bestResult[1] = cards.get(b);
                            bestResult[2] = cards.get(c);
                        }
                    }
                    if (tradesToScan >= 0) continue;
                    return bestValue;
                }
            }
        }
        return bestValue;
    }

    public int getNewCardState() {
        if (this.cardState < 4) {
            return this.cardState + 4;
        }
        if (this.cardState < 12) {
            return this.cardState + 2;
        }
        if (this.cardState < 15) {
            return this.cardState + 3;
        }
        return this.cardState + 5;
    }

    public boolean checkTrade(Card card1, Card card2, Card card3) {
        return this.getTradeAbsValue(card1.getName(), card2.getName(), card3.getName(), this.cardMode) > 0;
    }

    public boolean endTrade() {
        if (this.canEndTrade()) {
            this.gameState = 2;
            if (this.tradeCap) {
                throw new RuntimeException("endTrade worked when tradeCap was true");
            }
            return true;
        }
        return false;
    }

    public boolean canEndTrade() {
        return this.gameState == 1 && (this.cardMode == 2 || this.currentPlayer.getCards().size() < 5);
    }

    public int placeArmy(Country t, int n) {
        int done = 0;
        if (this.gameState == 2) {
            if (this.setup != this.Players.size()) {
                if (n != 1) {
                    return 0;
                }
                if (t.getOwner() == this.currentPlayer) {
                    if (this.NoEmptyCountries()) {
                        t.addArmy();
                        this.currentPlayer.loseExtraArmy(1);
                        done = 1;
                    }
                } else if (t.getOwner() == null) {
                    t.setOwner(this.currentPlayer);
                    this.currentPlayer.newCountry(t);
                    t.addArmy();
                    this.currentPlayer.loseExtraArmy(1);
                    done = 1;
                }
            } else if (t.getOwner() == this.currentPlayer && this.currentPlayer.getExtraArmies() >= n) {
                this.currentPlayer.currentStatistic.addReinforcements(n);
                t.addArmies(n);
                this.currentPlayer.loseExtraArmy(n);
                done = 1;
            }
            if (done == 1) {
                if (this.setup == this.Players.size()) {
                    this.gameState = this.currentPlayer.getExtraArmies() == 0 ? 3 : 2;
                } else {
                    if (this.currentPlayer.getExtraArmies() == 0) {
                        ++this.setup;
                    }
                    this.gameState = 7;
                }
                if (this.checkPlayerWon()) {
                    done = 2;
                }
            }
        }
        return done;
    }

    public int getEmptyCountry() {
        int nEmpty = -1;
        if (this.gameState == 2) {
            int a = this.r.nextInt(this.Countries.length);
            boolean done = false;
            for (int c = a; c < this.Countries.length; ++c) {
                if (this.Countries[c].getOwner() == null) {
                    nEmpty = this.Countries[c].getColor();
                    break;
                }
                if (c == this.Countries.length - 1 && !done) {
                    c = -1;
                    done = true;
                    continue;
                }
                if (c == this.Countries.length - 1 && done) break;
            }
        }
        return nEmpty;
    }

    public boolean attack(Country t1, Country t2) {
        boolean result = false;
        if (this.gameState == 3 && t1 != null && t2 != null && t1.getOwner() == this.currentPlayer && t2.getOwner() != this.currentPlayer && t1.isNeighbours(t2) && t1.getArmies() > 1) {
            this.currentPlayer.currentStatistic.addAttack();
            t2.getOwner().currentStatistic.addAttacked();
            result = true;
            this.attacker = t1;
            this.defender = t2;
            this.battleRounds = 0;
            this.gameState = 4;
        }
        return result;
    }

    public boolean endAttack() {
        if (this.gameState == 3) {
            this.gameState = 6;
            return true;
        }
        return false;
    }

    public boolean rollA(int dice1) {
        if (this.gameState == 4) {
            if (this.attacker.getArmies() > 4 ? dice1 <= 0 || dice1 > 3 : dice1 <= 0 || dice1 > this.attacker.getArmies() - 1) {
                return false;
            }
            this.attackerDice = dice1;
            this.currentPlayer = this.defender.getOwner();
            this.gameState = 10;
            return true;
        }
        return false;
    }

    public boolean rollD(int dice2) {
        if (this.gameState == 10) {
            if (this.defender.getArmies() > this.maxDefendDice ? dice2 <= 0 || dice2 > this.maxDefendDice : dice2 <= 0 || dice2 > this.defender.getArmies()) {
                return false;
            }
            this.currentPlayer = this.attacker.getOwner();
            this.defenderDice = dice2;
            return true;
        }
        return false;
    }

    public int getAttackerDice() {
        return this.attackerDice;
    }

    public int getDefenderDice() {
        return this.defenderDice;
    }

    public int getBattleRounds() {
        return this.battleRounds;
    }

    public int[] battle(int[] attackerResults, int[] defenderResults) {
        int[] result = new int[]{0, 0, 0, 0, 0, 0};
        if (this.gameState == 10) {
            ++this.battleRounds;
            for (int c = 0; c < Math.min(attackerResults.length, defenderResults.length); ++c) {
                if (attackerResults[c] > defenderResults[c]) {
                    this.defender.looseArmy();
                    this.defender.getOwner().currentStatistic.addCasualty();
                    this.attacker.getOwner().currentStatistic.addKill();
                    result[2] = result[2] + 1;
                    continue;
                }
                this.attacker.looseArmy();
                this.attacker.getOwner().currentStatistic.addCasualty();
                this.defender.getOwner().currentStatistic.addKill();
                result[1] = result[1] + 1;
            }
            if (this.defender.getArmies() == 0) {
                this.attacker.getOwner().currentStatistic.addCountriesWon();
                this.defender.getOwner().currentStatistic.addCountriesLost();
                result[5] = this.attacker.getArmies() - 1;
                this.capturedCountry = true;
                Player lostPlayer = this.defender.getOwner();
                lostPlayer.lostCountry(this.defender);
                this.currentPlayer.newCountry(this.defender);
                this.defender.setOwner(this.attacker.getOwner());
                result[3] = 1;
                this.gameState = 5;
                result[4] = this.mustmove = attackerResults.length;
                if (lostPlayer.getNoTerritoriesOwned() == 0) {
                    result[3] = 2;
                    this.currentPlayer.addPlayersEliminated(lostPlayer);
                    while (lostPlayer.getCards().size() > 0) {
                        this.currentPlayer.giveCard(lostPlayer.takeCard());
                    }
                    if (this.cardMode != 2 && this.currentPlayer.getCards().size() > 5) {
                        this.tradeCap = true;
                    }
                }
            } else if (this.attacker.getArmies() == 1) {
                this.gameState = 3;
                this.currentPlayer.currentStatistic.addRetreat();
            } else {
                this.gameState = 4;
            }
            this.defenderDice = 0;
            this.attackerDice = 0;
            result[0] = 1;
        }
        return result;
    }

    public int moveArmies(int noa) {
        if (this.gameState == 5 && this.mustmove > 0 && noa >= this.mustmove && noa < this.attacker.getArmies()) {
            this.attacker.removeArmies(noa);
            this.defender.addArmies(noa);
            this.gameState = this.tradeCap ? 1 : 3;
            this.attacker = null;
            this.defender = null;
            this.mustmove = 0;
            return this.checkPlayerWon() ? 2 : 1;
        }
        return 0;
    }

    public int moveAll() {
        if (this.gameState == 5 && this.mustmove > 0) {
            return this.attacker.getArmies() - 1;
        }
        return -1;
    }

    public int getMustMove() {
        return this.mustmove;
    }

    public boolean retreat() {
        if (this.gameState == 4) {
            this.currentPlayer.currentStatistic.addRetreat();
            this.gameState = 3;
            this.attacker = null;
            this.defender = null;
            return true;
        }
        return false;
    }

    public boolean moveArmy(Country t1, Country t2, int noa) {
        if (this.gameState == 6 && t1 != null && t2 != null && t1.getOwner() == this.currentPlayer && t2.getOwner() == this.currentPlayer && t1.isNeighbours(t2) && t1.getArmies() > noa && noa > 0) {
            t1.removeArmies(noa);
            t2.addArmies(noa);
            this.gameState = 7;
            this.checkPlayerWon();
            return true;
        }
        return false;
    }

    public boolean noMove() {
        if (this.gameState == 6) {
            this.gameState = 7;
            return true;
        }
        return false;
    }

    public void workOutEndGoStats(Player p) {
        int countries = p.getNoTerritoriesOwned();
        int armies = p.getNoArmies();
        int continents = this.getNoContinentsOwned(p);
        int conectedEmpire = this.getConnectedEmpire(p).size();
        int cards = p.getCards().size();
        p.currentStatistic.endGoStatistics(countries, armies, continents, conectedEmpire, cards);
    }

    public List getConnectedEmpire(Player p) {
        Vector t = (Vector)p.getTerritoriesOwned().clone();
        Vector<Country> a = new Vector<Country>();
        Vector b = new Vector();
        while (!t.isEmpty()) {
            Country country = (Country)t.remove(0);
            a.add(country);
            this.getConnectedEmpire(t, a, country.getNeighbours(), p);
            if (a.size() > b.size()) {
                b = a;
            }
            a = new Vector();
        }
        return b;
    }

    public void getConnectedEmpire(List t, List a, List n, Player p) {
        for (int i = 0; i < n.size(); ++i) {
            if (((Country)n.get(i)).getOwner() != p || !t.contains(n.get(i))) continue;
            Country country = (Country)n.get(i);
            t.remove(country);
            a.add(country);
            this.getConnectedEmpire(t, a, country.getNeighbours(), p);
        }
    }

    public boolean setCapital(Country c) {
        if (this.gameState == 9 && this.gameMode == 2 && c.getOwner() == this.currentPlayer && this.currentPlayer.getCapital() == null) {
            this.currentPlayer.setCapital(c);
            for (int b = 0; b < this.Cards.size(); ++b) {
                if (c != ((Card)this.Cards.elementAt(b)).getCountry()) continue;
                this.Cards.removeElementAt(b);
            }
            this.gameState = 7;
            return true;
        }
        return false;
    }

    public boolean checkPlayerWon() {
        boolean result = false;
        int won = 0;
        for (int c = 0; c < this.Continents.length; ++c) {
            if (!this.Continents[c].isOwned(this.currentPlayer)) continue;
            ++won;
        }
        if (won == this.Continents.length) {
            result = true;
        } else if (this.setup == this.Players.size() && this.gameMode == 2 && this.currentPlayer.getCapital() != null) {
            int capitalcount = 0;
            if (this.currentPlayer == this.currentPlayer.getCapital().getOwner()) {
                for (int c = 0; c < this.Players.size(); ++c) {
                    if (!this.currentPlayer.getTerritoriesOwned().contains(((Player)this.Players.elementAt(c)).getCapital())) continue;
                    ++capitalcount;
                }
            }
            if (capitalcount == this.Players.size()) {
                result = true;
            }
        } else if (this.setup == this.Players.size() && this.gameMode == 3) {
            Mission m = this.currentPlayer.getMission();
            if (m.getPlayer() != null && m.getPlayer() != this.currentPlayer && m.getPlayer().getNoTerritoriesOwned() == 0 && this.currentPlayer.getPlayersEliminated().contains(m.getPlayer())) {
                result = true;
            } else if (m.getNoofcountries() != 0 && m.getNoofarmies() != 0 && (m.getPlayer() == null || m.getPlayer().getNoTerritoriesOwned() == 0 || m.getPlayer() == this.currentPlayer) && m.getNoofcountries() <= this.currentPlayer.getNoTerritoriesOwned()) {
                int n = 0;
                for (int c = 0; c < this.currentPlayer.getNoTerritoriesOwned(); ++c) {
                    if (((Country)this.currentPlayer.getTerritoriesOwned().elementAt(c)).getArmies() < m.getNoofarmies()) continue;
                    ++n;
                }
                if (n >= m.getNoofcountries()) {
                    result = true;
                }
            } else if (m.getContinent1() != null && this.checkPlayerOwnesContinentForMission(m.getContinent1(), 1) && this.checkPlayerOwnesContinentForMission(m.getContinent2(), 2) && this.checkPlayerOwnesContinentForMission(m.getContinent3(), 3)) {
                result = true;
            }
        }
        if (result) {
            this.gameState = 8;
        }
        return result;
    }

    private boolean checkPlayerOwnesContinentForMission(Continent c, int n) {
        if (ANY_CONTINENT.equals(c)) {
            return this.getNoContinentsOwned(this.currentPlayer) >= n;
        }
        if (c != null) {
            return c.isOwned(this.currentPlayer);
        }
        return true;
    }

    public boolean canContinue() {
        if (this.gameState == 8 && this.gameMode != 0 && this.gameMode != 1) {
            int oldGameMode = this.gameMode;
            this.gameMode = 0;
            boolean playerWon = this.checkPlayerWon();
            this.gameMode = oldGameMode;
            return !playerWon;
        }
        return false;
    }

    public boolean continuePlay() {
        if (this.canContinue()) {
            this.gameMode = 0;
            this.gameState = this.tradeCap ? 1 : (this.currentPlayer.getExtraArmies() == 0 ? 3 : 2);
            return true;
        }
        return false;
    }

    public int getClosestCountry(int x, int y) {
        Country closestCountryCanvas = null;
        int closestDistance = Integer.MAX_VALUE;
        for (int index = 0; index < this.Countries.length; ++index) {
            int distance = this.Countries[index].getDistanceTo(x, y);
            if (distance >= closestDistance) continue;
            closestCountryCanvas = this.Countries[index];
            closestDistance = distance;
        }
        return closestCountryCanvas.getColor();
    }

    public void loadMap() throws Exception {
        this.loadMap(true, null);
    }

    public void loadMap(boolean cleanLoad, BufferedReader bufferin) throws Exception {
        Vector<Object> Continents;
        Vector<Object> Countries;
        MapTranslator.setMap(this.mapfile);
        StringTokenizer st = null;
        if (cleanLoad) {
            Countries = new Vector();
            Continents = new Vector();
        } else {
            Countries = new Vector<Country>(Arrays.asList(this.Countries));
            Continents = new Vector<Continent>(Arrays.asList(this.Continents));
        }
        int countryCount = 0;
        if (bufferin == null) {
            bufferin = RiskUtil.readMap(RiskUtil.openMapStream(this.mapfile));
        }
        String input = bufferin.readLine();
        String mode = "none";
        while (input != null) {
            if (!input.equals("") && input.charAt(0) != ';') {
                if (input.charAt(0) == '[' && input.charAt(input.length() - 1) == ']') {
                    mode = "newsection";
                } else {
                    st = new StringTokenizer(input);
                }
                if (mode.equals("files")) {
                    if (input.startsWith("pic ")) {
                        this.ImagePic = input.substring(4);
                    } else if (input.startsWith("map ")) {
                        this.ImageMap = input.substring(4);
                    } else if (!input.startsWith("crd ") && !input.startsWith("prv ")) {
                        throw new Exception("error with files section in map file: " + input);
                    }
                } else if (mode.equals("continents")) {
                    String id = st.nextToken();
                    String name = MapTranslator.getTranslatedMapName(id).replaceAll("_", " ");
                    int noa = Integer.parseInt(st.nextToken());
                    int color = ColorUtil.getColor(st.nextToken());
                    if (color == 0) {
                        color = RiskGame.getRandomColor();
                    }
                    if (st.hasMoreTokens()) {
                        throw new Exception("unknown item found in map file: " + st.nextToken());
                    }
                    if (cleanLoad) {
                        Continent continent = new Continent(id, name, noa, color);
                        Continents.add(continent);
                    }
                } else if (mode.equals("countries")) {
                    Country country;
                    int color = Integer.parseInt(st.nextToken());
                    String id = st.nextToken();
                    String name = MapTranslator.getTranslatedMapName(id).replaceAll("_", " ");
                    int continent = Integer.parseInt(st.nextToken());
                    int x = Integer.parseInt(st.nextToken());
                    int y = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        throw new Exception("unknown item found in map file: " + st.nextToken());
                    }
                    if (++countryCount != color) {
                        throw new Exception("unexpected number found in map file: " + color);
                    }
                    if (cleanLoad) {
                        country = new Country();
                        Countries.add(country);
                        ((Continent)Continents.elementAt(continent - 1)).addTerritoriesContained(country);
                    } else {
                        country = (Country)Countries.get(color - 1);
                    }
                    country.setColor(color);
                    country.setContinent((Continent)Continents.elementAt(continent - 1));
                    country.setIdString(id);
                    country.setName(name);
                    country.setX(x);
                    country.setY(y);
                } else if (mode.equals("borders")) {
                    int country = Integer.parseInt(st.nextToken());
                    while (st.hasMoreElements()) {
                        ((Country)Countries.elementAt(country - 1)).addNeighbour((Country)Countries.elementAt(Integer.parseInt(st.nextToken()) - 1));
                    }
                } else if (mode.equals("newsection")) {
                    mode = input.substring(1, input.length() - 1);
                    if (mode.equals("files")) {
                        this.ImagePic = null;
                        this.ImageMap = null;
                    } else if (!(mode.equals("continents") || mode.equals("countries") || mode.equals("borders"))) {
                        throw new Exception("unknown section found in map file: " + mode);
                    }
                }
            }
            input = bufferin.readLine();
        }
        bufferin.close();
        if (cleanLoad) {
            this.Countries = Countries.toArray(new Country[Countries.size()]);
            this.Continents = Continents.toArray(new Continent[Continents.size()]);
        }
    }

    public boolean setMapfile(String f) throws Exception {
        if (f.equals("default")) {
            f = defaultMap;
        }
        BufferedReader bufferin = RiskUtil.readMap(RiskUtil.openMapStream(f));
        this.runmaptest = false;
        this.previewPic = null;
        this.properties = new HashMap();
        String input = bufferin.readLine();
        String mode = null;
        boolean yesmap = false;
        boolean returnvalue = false;
        boolean yescards = false;
        while (input != null) {
            if (!input.equals("") && input.charAt(0) != ';') {
                if (input.charAt(0) == '[' && input.charAt(input.length() - 1) == ']') {
                    mode = "newsection";
                }
                if ("files".equals(mode)) {
                    if (input.startsWith("pic ")) {
                        this.ImagePic = input.substring(4);
                    } else if (input.startsWith("prv ")) {
                        this.previewPic = input.substring(4);
                    } else if (input.startsWith("crd ")) {
                        yescards = true;
                        returnvalue = this.setCardsfile(input.substring(4));
                    }
                } else if ("borders".equals(mode)) {
                    yesmap = true;
                } else if ("newsection".equals(mode)) {
                    mode = input.substring(1, input.length() - 1);
                } else if (mode == null) {
                    int space = input.indexOf(32);
                    if (input.equals("test")) {
                        this.runmaptest = true;
                    } else if (space >= 0) {
                        String key = input.substring(0, space);
                        String value = input.substring(space + 1);
                        this.properties.put(key, value);
                    }
                }
            }
            input = bufferin.readLine();
        }
        if (!yesmap) {
            throw new Exception("error with map file");
        }
        if (!yescards) {
            throw new Exception("cards file not specified in map file");
        }
        this.mapfile = f;
        bufferin.close();
        return returnvalue;
    }

    public void setMemoryLoad() {
        this.mapfile = null;
        this.cardsfile = null;
        this.ImagePic = null;
        this.ImageMap = null;
    }

    public void setupNewMap() {
        this.Countries = new Country[0];
        this.Continents = new Continent[0];
        this.Cards = new Vector();
        this.usedCards = new Vector();
        this.Missions = new Vector();
        this.properties = new HashMap();
        this.runmaptest = false;
        this.previewPic = null;
        this.setMemoryLoad();
    }

    public void setCountries(Country[] a) {
        this.Countries = a;
    }

    public void setContinents(Continent[] a) {
        this.Continents = a;
    }

    public void loadCards(boolean rawLoad) throws Exception {
        StringTokenizer st = null;
        this.Cards = new Vector();
        this.usedCards = new Vector();
        this.Missions = new Vector();
        BufferedReader bufferin = RiskUtil.readMap(RiskUtil.openMapStream(this.cardsfile));
        String input = bufferin.readLine();
        String mode = "none";
        while (input != null) {
            if (!input.equals("") && input.charAt(0) != ';') {
                if (input.charAt(0) == '[' && input.charAt(input.length() - 1) == ']') {
                    mode = "newsection";
                } else {
                    st = new StringTokenizer(input);
                }
                if (mode.equals("cards")) {
                    String name = st.nextToken();
                    if (name.equals("wildcard")) {
                        Card card = new Card(name, null);
                        this.Cards.add(card);
                    } else if (name.equals("Cavalry") || name.equals("Infantry") || name.equals("Cannon")) {
                        int country = Integer.parseInt(st.nextToken());
                        Card card = new Card(name, this.Countries[country - 1]);
                        this.Cards.add(card);
                    } else {
                        throw new Exception("unknown item found in cards file: " + name);
                    }
                    if (st.hasMoreTokens()) {
                        throw new Exception("unknown item found in cards file: " + st.nextToken());
                    }
                } else if (mode.equals("missions")) {
                    String description;
                    int s1 = Integer.parseInt(st.nextToken());
                    Player p = s1 == 0 || s1 > this.Players.size() ? null : (Player)this.Players.elementAt(s1 - 1);
                    int noc = Integer.parseInt(st.nextToken());
                    int noa = Integer.parseInt(st.nextToken());
                    String s4 = st.nextToken();
                    String s5 = st.nextToken();
                    String s6 = st.nextToken();
                    Continent c1 = this.getMissionContinentfromString(s4);
                    Continent c2 = this.getMissionContinentfromString(s5);
                    Continent c3 = this.getMissionContinentfromString(s6);
                    String missioncode = s1 + "-" + noc + "-" + noa + "-" + s4 + "-" + s5 + "-" + s6;
                    String string = description = rawLoad ? null : MapTranslator.getTranslatedMissionName(missioncode);
                    if (description == null) {
                        description = "";
                        while (st.hasMoreElements()) {
                            description = description + ("".equals(description) ? "" : " ") + st.nextToken();
                        }
                    }
                    if (p != null && !rawLoad) {
                        String name = p.getName();
                        String color = "color." + ColorUtil.getStringForColor(p.getColor());
                        ResourceBundle trans = TranslationBundle.getBundle();
                        try {
                            name = trans.getString(color) + " " + name;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        String oldkey = "PLAYER" + s1;
                        String newkey = "{" + oldkey + "}";
                        if (description.indexOf(newkey) >= 0) {
                            description = RiskUtil.replaceAll(description, newkey, name);
                        } else if (description.indexOf(oldkey) >= 0) {
                            description = RiskUtil.replaceAll(description, oldkey, name);
                        } else {
                            System.err.println("newkey: " + newkey + " and oldkey: " + oldkey + " not found in mission: " + description);
                        }
                    }
                    if (rawLoad || s1 <= this.Players.size()) {
                        Mission mission = new Mission(p, noc, noa, c1, c2, c3, description);
                        this.Missions.add(mission);
                    }
                } else if (mode.equals("newsection")) {
                    mode = input.substring(1, input.length() - 1);
                    if (!mode.equals("cards") && !mode.equals("missions")) {
                        throw new Exception("unknown section found in cards file: " + mode);
                    }
                } else {
                    throw new Exception("unknown item found in cards file: " + input);
                }
            }
            input = bufferin.readLine();
        }
        bufferin.close();
    }

    private Continent getMissionContinentfromString(String a) {
        if (a.equals("*")) {
            return ANY_CONTINENT;
        }
        int s = Integer.parseInt(a);
        if (s == 0) {
            return null;
        }
        return this.Continents[s - 1];
    }

    public boolean setCardsfile(String f) throws Exception {
        StringTokenizer st = null;
        if (f.equals("default")) {
            f = defaultCards;
        }
        BufferedReader bufferin = RiskUtil.readMap(RiskUtil.openMapStream(f));
        String input = bufferin.readLine();
        String mode = "none";
        boolean yesmissions = false;
        boolean yescards = false;
        while (input != null) {
            if (!input.equals("") && input.charAt(0) != ';') {
                if (input.charAt(0) == '[' && input.charAt(input.length() - 1) == ']') {
                    mode = "newsection";
                } else {
                    st = new StringTokenizer(input);
                }
                if (mode.equals("newsection")) {
                    mode = input.substring(1, input.length() - 1);
                    if (mode.equals("cards")) {
                        yescards = true;
                    } else if (mode.equals("missions")) {
                        yesmissions = true;
                    }
                }
            }
            input = bufferin.readLine();
        }
        if (!yescards) {
            throw new Exception("error with cards file");
        }
        this.cardsfile = f;
        bufferin.close();
        MapTranslator.setCards(f);
        return yesmissions;
    }

    public List shuffleCountries() {
        Vector<Country> oldCountries = new Vector<Country>(Arrays.asList(this.Countries));
        Collections.shuffle(oldCountries);
        return oldCountries;
    }

    public static RiskGame loadGame(String file) throws Exception {
        RiskGame game = null;
        InputStream filein = RiskUtil.getLoadFileInputStream(file);
        ObjectInputStream objectin = new ObjectInputStream(filein);
        game = (RiskGame)objectin.readObject();
        objectin.close();
        return game;
    }

    public void saveGame(OutputStream file) throws Exception {
        RiskObjectOutputStream out = new RiskObjectOutputStream(file);
        out.writeObject(this);
        out.close();
    }

    public int getState() {
        return this.gameState;
    }

    public boolean NoEmptyCountries() {
        Country empty = null;
        for (int c = 0; c < this.Countries.length; ++c) {
            if (this.Countries[c].getOwner() != null) continue;
            empty = this.Countries[c];
            c = this.Countries.length;
        }
        return empty == null;
    }

    public boolean getSetup() {
        return this.setup == this.Players.size();
    }

    public boolean getTradeCap() {
        return this.tradeCap;
    }

    public int getGameMode() {
        return this.gameMode;
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public Vector getPlayers() {
        return this.Players;
    }

    public Vector getPlayersStats() {
        for (int c = 0; c < this.Players.size(); ++c) {
            this.workOutEndGoStats((Player)this.Players.elementAt(c));
        }
        return this.Players;
    }

    public Country getAttacker() {
        return this.attacker;
    }

    public Country getDefender() {
        return this.defender;
    }

    public String getImagePic() {
        return this.ImagePic;
    }

    public String getPreviewPic() {
        return this.previewPic;
    }

    public void setPreviewPic(String prv) {
        this.previewPic = prv;
    }

    public Map getProperties() {
        return this.properties;
    }

    int getIntProperty(String name, int defaultValue) {
        Object value = this.properties.get(name);
        if (value != null) {
            return Integer.parseInt(String.valueOf(value));
        }
        return defaultValue;
    }

    void setIntProperty(String name, int value, int defaultValue) {
        if (value == defaultValue) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, String.valueOf(value));
        }
    }

    public int getCircleSize() {
        return this.getIntProperty("circle", 20);
    }

    public void setCircleSize(int a) {
        this.setIntProperty("circle", a, 20);
    }

    public int getVersion() {
        return this.getIntProperty("ver", 1);
    }

    public void setVersion(int newVersion) {
        this.setIntProperty("ver", newVersion, 1);
    }

    public String getMapName() {
        return (String)this.properties.get("name");
    }

    public void setMapName(String name) {
        if (name == null) {
            this.properties.remove("name");
        } else {
            this.properties.put("name", name);
        }
    }

    public String getImageMap() {
        return this.ImageMap;
    }

    public String getCardsFile() {
        return this.cardsfile;
    }

    public String getMapFile() {
        return this.mapfile;
    }

    public Vector getCards() {
        return this.Cards;
    }

    public Vector getUsedCards() {
        return this.usedCards;
    }

    public int[] rollDice(int nod) {
        int[] dice = new int[nod];
        for (int j = 0; j < nod; ++j) {
            dice[j] = this.r.nextInt(6);
        }
        for (int i = 0; i < nod - 1; ++i) {
            int pos = i;
            for (int j = i + 1; j < nod; ++j) {
                if (dice[j] <= dice[pos]) continue;
                pos = j;
            }
            int temp = dice[i];
            dice[i] = dice[pos];
            dice[pos] = temp;
        }
        return dice;
    }

    public int getNoContinentsOwned(Player p) {
        int total = 0;
        for (int c = 0; c < this.Continents.length; ++c) {
            if (!this.Continents[c].isOwned(p)) continue;
            ++total;
        }
        return total;
    }

    public Country getCountryInt(int color) {
        if (color <= 0 || color > this.Countries.length) {
            return null;
        }
        return this.Countries[color - 1];
    }

    public Card[] getCards(String name1, String name2, String name3) {
        Card[] c = new Card[3];
        Vector playersCards = new Vector(this.currentPlayer.getCards());
        block0: for (int a = 0; a < 3; ++a) {
            String name = a == 0 ? name1 : (a == 1 ? name2 : name3);
            for (int b = 0; b < playersCards.size(); ++b) {
                if (name.equals("wildcard") && name.equals(((Card)playersCards.elementAt(b)).getName())) {
                    c[a] = (Card)playersCards.remove(b);
                    continue block0;
                }
                if (((Card)playersCards.elementAt(b)).getCountry() == null || !name.equals(((Card)playersCards.elementAt(b)).getCountry().getColor() + "")) continue;
                c[a] = (Card)playersCards.remove(b);
                continue block0;
            }
        }
        return c;
    }

    public Card findCardAndRemoveIt(String name) {
        int cardIndex = -1;
        for (int c = 0; c < this.Cards.size(); ++c) {
            Card theCard = (Card)this.Cards.elementAt(c);
            if (name.equals("wildcard") && name.equals(theCard.getName())) {
                cardIndex = c;
                break;
            }
            if (theCard.getCountry() == null || !name.equals(String.valueOf(theCard.getCountry().getColor()))) continue;
            cardIndex = c;
            break;
        }
        Card theCard = (Card)this.Cards.remove(cardIndex);
        this.Cards.trimToSize();
        if (this.Cards.isEmpty() && this.recycleCards) {
            Vector used = this.getUsedCards();
            this.Cards.addAll(used);
            used.clear();
        }
        return theCard;
    }

    public static int getNumber(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public int getNoPlayers() {
        return this.Players.size();
    }

    public Country[] getCountries() {
        return this.Countries;
    }

    public Continent[] getContinents() {
        return this.Continents;
    }

    public int getNoCountries() {
        return this.Countries.length;
    }

    public int getNoContinents() {
        return this.Continents.length;
    }

    public Vector getMissions() {
        return this.Missions;
    }

    public int getNoMissions() {
        return this.Missions.size();
    }

    public int getNoCards() {
        return this.Cards.size();
    }

    public boolean isRecycleCards() {
        return this.recycleCards;
    }

    public static void setDefaultMapAndCards(String a, String b) {
        defaultMap = a;
        defaultCards = b;
    }

    public static String getDefaultMap() {
        return defaultMap;
    }

    public static String getDefaultCards() {
        return defaultCards;
    }

    public int getCardMode() {
        return this.cardMode;
    }

    public static int getRandomColor() {
        return RiskGame.HSBtoRGB((float)Math.random(), 0.5f, 1.0f);
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public int getNoAttackDice() {
        if (this.attacker.getArmies() > 4) {
            return 3;
        }
        return this.attacker.getArmies() - 1;
    }

    public int getNoDefendDice() {
        if (this.defender.getArmies() > this.maxDefendDice) {
            return this.maxDefendDice;
        }
        return this.defender.getArmies();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.mapfile != null && this.gameState != 0) {
            try {
                this.loadMap(false, null);
            }
            catch (Exception e1) {
                throw new IOException(e1);
            }
        }
    }

    private static class IntermediateResult {
        String[] types;

        private IntermediateResult() {
        }

        public int hashCode() {
            return Arrays.hashCode(this.types);
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.types, ((IntermediateResult)obj).types);
        }
    }
}

