/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.guishared;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.core.Player;

public class StatsPanel
extends JPanel {
    private Risk risk;
    private BufferedImage graph;
    private boolean tooBig;
    private int ZeroX;
    private int ZeroY;
    private int gridSizeX;
    private int gridSizeY;

    public StatsPanel(Risk r) {
        this.risk = r;
    }

    public void paintComponent(Graphics g) {
        if (this.graph != null) {
            g.drawImage(this.graph, 0, 0, this);
        } else {
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void repaintStats(int a) {
        BufferedImage tempgraph = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Vector players = this.risk.getGame().getPlayersStats();
        int graphScale = 0;
        int maxTurns = 0;
        for (int i = 0; i < players.size(); ++i) {
            Player p = (Player)players.get(i);
            int[] pstats = p.getStatistics(a);
            int max = pstats.length;
            if (max > maxTurns) {
                maxTurns = max;
            }
            int temp = 0;
            for (int j = 0; j < pstats.length; ++j) {
                if (a == 1 || a == 2 || a == 0 || a == 6 || a == 7) {
                    if (pstats[j] <= graphScale) continue;
                    graphScale = pstats[j];
                    continue;
                }
                temp += pstats[j];
            }
            if (temp > graphScale) {
                graphScale = temp;
            }
            temp = 0;
        }
        Graphics2D g2 = tempgraph.createGraphics();
        int xOffset = 30;
        int yOffset = 30;
        this.gridSizeX = ((int)this.getSize().getWidth() - xOffset - 20) / ++maxTurns;
        this.gridSizeY = ((int)this.getSize().getHeight() - yOffset - 20) / ++graphScale;
        this.ZeroX = xOffset;
        this.ZeroY = (int)this.getSize().getHeight() - yOffset;
        if (this.gridSizeY == 0) {
            this.gridSizeY = 1;
            this.tooBig = true;
            graphScale /= 2;
        } else {
            this.tooBig = false;
        }
        int bob = Math.round(15.0f / (float)this.gridSizeY);
        for (int i = 0; i <= graphScale; ++i) {
            if (i != graphScale && bob != 0 && i % bob != 0) continue;
            g2.setColor(Color.gray);
            g2.drawLine(this.ZeroX, this.ZeroY - i * this.gridSizeY, maxTurns * this.gridSizeX + this.ZeroX, this.ZeroY - i * this.gridSizeY);
            g2.setColor(Color.white);
            String label = this.tooBig ? String.valueOf(i * 2) : String.valueOf(i);
            g2.drawString(label, this.ZeroX - (6 + label.length() * 7), this.ZeroY - i * this.gridSizeY + 5);
        }
        int fred = Math.round(20.0f / (float)this.gridSizeX);
        for (int i = 0; i <= maxTurns; ++i) {
            g2.setColor(Color.gray);
            g2.drawLine(this.ZeroX + i * this.gridSizeX, this.ZeroY, this.ZeroX + i * this.gridSizeX, this.ZeroY - graphScale * this.gridSizeY);
            if (i != maxTurns && fred != 0 && i % fred != 0) continue;
            g2.setColor(Color.white);
            g2.drawString("" + i, i * this.gridSizeX + this.ZeroX - 3, this.ZeroY + 20);
        }
        g2.setColor(Color.white);
        g2.drawLine(this.ZeroX, this.ZeroY, this.ZeroX + maxTurns * this.gridSizeX, this.ZeroY);
        g2.drawLine(this.ZeroX, this.ZeroY, this.ZeroX, this.ZeroY - graphScale * this.gridSizeY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke bs = new BasicStroke(2.0f, 1, 0);
        g2.setStroke(bs);
        for (int i = 0; i < players.size(); ++i) {
            this.drawPlayerGraph(a, (Player)players.get(i), g2);
        }
        g2.dispose();
        this.graph = tempgraph;
    }

    public void drawPlayerGraph(int a, Player p, Graphics2D g) {
        int[] PointToDraw = p.getStatistics(a);
        g.setColor(new Color(p.getColor()));
        int oldPoint = 0;
        int newPoint = 0;
        int i = 0;
        for (i = 0; i < PointToDraw.length; ++i) {
            newPoint = a == 1 || a == 2 || a == 0 || a == 6 || a == 7 ? (this.tooBig ? PointToDraw[i] / 2 : PointToDraw[i]) : (newPoint += this.tooBig ? PointToDraw[i] / 2 : PointToDraw[i]);
            int x1 = this.ZeroX + i * this.gridSizeX;
            int y1 = this.ZeroY - oldPoint * this.gridSizeY;
            int x2 = this.ZeroX + (i + 1) * this.gridSizeX;
            int y2 = this.ZeroY - newPoint * this.gridSizeY;
            Color color = g.getColor();
            Stroke stroke = g.getStroke();
            if (Color.BLACK.equals(color)) {
                g.setColor(Color.WHITE);
                g.setStroke(new BasicStroke(3.0f));
                g.drawLine(x1, y1, x2, y2);
                g.setColor(color);
                g.setStroke(stroke);
            }
            g.drawLine(x1, y1, x2, y2);
            oldPoint = newPoint;
        }
        int x = this.ZeroX + i * this.gridSizeX;
        int y = this.ZeroY - oldPoint * this.gridSizeY + 11;
        Color color = g.getColor();
        if (Color.BLACK.equals(color)) {
            g.setColor(Color.WHITE);
            g.drawString(p.getName(), x + 1, y + 1);
            g.drawString(p.getName(), x - 1, y - 1);
            g.drawString(p.getName(), x + 1, y - 1);
            g.drawString(p.getName(), x - 1, y + 1);
            g.setColor(color);
        }
        g.drawString(p.getName(), x, y);
    }
}

