/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.lobby.client.RiskMap;
import net.yura.domination.ui.flashgui.NewGameFrame;
import net.yura.lobby.model.Game;

public class GameSetupPanel
extends JPanel
implements ActionListener {
    private BufferedImage newgame;
    private BufferedImage game2;
    private BufferedImage card;
    private JLabel mapPic;
    private JPanel mapsMissions;
    private JButton start;
    private JButton cancel;
    private JRadioButton domination;
    private JRadioButton capital;
    private JRadioButton mission;
    private JRadioButton fixed;
    private JRadioButton increasing;
    private JRadioButton italian;
    private JCheckBox AutoPlaceAll;
    private JCheckBox recycle;
    private ResourceBundle resb = TranslationBundle.getBundle();
    private String options;
    private JList list;
    private JDialog dialog;
    private RiskMap riskmap;
    private JSpinner human;
    private JSpinner aieasy;
    private JSpinner aiaverage;
    private JSpinner aihard;
    private JTextField gamename;
    private JComboBox timeout;
    private String newGameOptions;
    private RiskMap[] maps;
    private static Map MapMap;

    public GameSetupPanel() {
        this.setLayout(null);
        Dimension d = new Dimension(700, 600);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        try {
            this.newgame = ImageIO.read(NewGameFrame.class.getResource("newgame.jpg"));
            this.game2 = ImageIO.read(this.getClass().getResource("game2.jpg"));
            this.card = this.game2.getSubimage(0, 247, 23, 35);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.mapPic = new JLabel();
        this.mapPic.setBounds(51, 51, 203, 127);
        this.add(this.mapPic);
        this.mapsMissions = new JPanel();
        this.mapsMissions.setOpaque(false);
        this.mapsMissions.setLayout(new BoxLayout(this.mapsMissions, 1));
        JScrollPane sp2 = new JScrollPane(this.mapsMissions);
        sp2.setBounds(340, 51, 309, 210);
        sp2.setBorder(null);
        sp2.setOpaque(false);
        sp2.getViewport().setOpaque(false);
        this.add(sp2);
        this.list = new JList();
        this.list.setCellRenderer(new RiskMapListCellRenderer());
        this.list.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setBounds(54, 192, 200, 260);
        scrollPane.setBorder(null);
        this.list.setOpaque(false);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        this.add(scrollPane);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                RiskMap it = (RiskMap)GameSetupPanel.this.list.getSelectedValue();
                if (it != null) {
                    GameSetupPanel.this.riskmap = it;
                    GameSetupPanel.this.mapPic.setIcon(GameSetupPanel.this.riskmap.getBigIcon());
                    GameSetupPanel.this.mapsMissions.removeAll();
                    String[] missions = GameSetupPanel.this.riskmap.getMissions();
                    for (int c = 0; c < missions.length; ++c) {
                        GameSetupPanel.this.mapsMissions.add(GameSetupPanel.this.makeNewMission(missions[c]));
                        GameSetupPanel.this.mapsMissions.add(Box.createVerticalStrut(3));
                    }
                    if (missions.length == 0) {
                        GameSetupPanel.this.mapsMissions.add(new JLabel(" No missions for this map."));
                        if (GameSetupPanel.this.mission.isSelected()) {
                            GameSetupPanel.this.domination.setSelected(true);
                            GameSetupPanel.this.AutoPlaceAll.setEnabled(true);
                        }
                    }
                    GameSetupPanel.this.mission.setEnabled(missions.length != 0);
                    GameSetupPanel.this.mapsMissions.revalidate();
                }
            }
        });
        this.human = new JSpinner(new SpinnerNumberModel(2, 1, 6, 1));
        this.aiaverage = new JSpinner(new SpinnerNumberModel(0, 0, 6, 1));
        this.aieasy = new JSpinner(new SpinnerNumberModel(2, 0, 6, 1));
        this.aihard = new JSpinner(new SpinnerNumberModel(2, 0, 6, 1));
        JPanel playernum = new JPanel();
        playernum.setBounds(300, 310, 400, 60);
        playernum.setOpaque(false);
        this.add(playernum);
        playernum.add(new JLabel(this.resb.getString("newgame.player.type.human")));
        playernum.add(this.human);
        playernum.add(new JLabel(this.resb.getString("newgame.player.type.easyai")));
        playernum.add(this.aieasy);
        JLabel aialabel = new JLabel(this.resb.getString("newgame.player.type.averageai"));
        playernum.add(aialabel);
        playernum.add(this.aiaverage);
        playernum.add(new JLabel(this.resb.getString("newgame.player.type.hardai")));
        playernum.add(this.aihard);
        this.aiaverage.setValue(0);
        this.aiaverage.setVisible(false);
        aialabel.setVisible(false);
        ButtonGroup GameTypeButtonGroup = new ButtonGroup();
        ButtonGroup CardTypeButtonGroup = new ButtonGroup();
        int bw1 = 119;
        int bw2 = 180;
        int bh = 25;
        this.domination = new JRadioButton(this.resb.getString("newgame.mode.domination"), true);
        NewGameFrame.sortOutButton(this.domination);
        this.domination.setBounds(380, 370, bw1, bh);
        this.domination.addActionListener(this);
        this.capital = new JRadioButton(this.resb.getString("newgame.mode.capital"));
        NewGameFrame.sortOutButton(this.capital);
        this.capital.setBounds(380, 390, bw1, bh);
        this.capital.addActionListener(this);
        this.mission = new JRadioButton(this.resb.getString("newgame.mode.mission"));
        NewGameFrame.sortOutButton(this.mission);
        this.mission.setBounds(380, 410, bw1, bh);
        this.mission.addActionListener(this);
        this.increasing = new JRadioButton(this.resb.getString("newgame.cardmode.increasing"), true);
        NewGameFrame.sortOutButton(this.increasing);
        this.increasing.setBounds(500, 370, bw2, bh);
        this.fixed = new JRadioButton(this.resb.getString("newgame.cardmode.fixed"));
        NewGameFrame.sortOutButton(this.fixed);
        this.fixed.setBounds(500, 390, bw2, bh);
        this.italian = new JRadioButton(this.resb.getString("newgame.cardmode.italianlike"));
        NewGameFrame.sortOutButton(this.italian);
        this.italian.setBounds(500, 410, bw2, bh);
        GameTypeButtonGroup.add(this.domination);
        GameTypeButtonGroup.add(this.capital);
        GameTypeButtonGroup.add(this.mission);
        CardTypeButtonGroup.add(this.fixed);
        CardTypeButtonGroup.add(this.increasing);
        CardTypeButtonGroup.add(this.italian);
        this.add(this.domination);
        this.add(this.capital);
        this.add(this.mission);
        this.add(this.fixed);
        this.add(this.increasing);
        this.add(this.italian);
        this.AutoPlaceAll = new JCheckBox(this.resb.getString("newgame.autoplace"));
        NewGameFrame.sortOutButton(this.AutoPlaceAll);
        this.AutoPlaceAll.setBounds(380, 440, bw1, bh);
        this.recycle = new JCheckBox(this.resb.getString("newgame.recycle"));
        NewGameFrame.sortOutButton(this.recycle);
        this.recycle.setBounds(500, 440, bw2, bh);
        this.add(this.AutoPlaceAll);
        this.add(this.recycle);
        int w = 115;
        int h = 31;
        this.cancel = new JButton(this.resb.getString("newgame.cancel"));
        NewGameFrame.sortOutButton(this.cancel, this.newgame.getSubimage(41, 528, w, h), this.newgame.getSubimage(700, 233, w, h), this.newgame.getSubimage(700, 264, w, h));
        this.cancel.addActionListener(this);
        this.cancel.setBounds(41, 528, 115, 31);
        JPanel bottompanel = new JPanel();
        bottompanel.setOpaque(false);
        bottompanel.add(new JLabel(this.resb.getString("newgame.label.name")));
        this.gamename = new JTextField();
        bottompanel.add(this.gamename);
        bottompanel.add(new JLabel(this.resb.getString("newgame.label.timeout")));
        int hour = 3600;
        Timeout[] timeouts = new Timeout[]{new Timeout("1min", 60), new Timeout("5min", 300), new Timeout("10min", 600), new Timeout("20min", 1200), new Timeout("30min", 1800), new Timeout("1hour", hour), new Timeout("2hours", hour * 2), new Timeout("6hours", hour * 6), new Timeout("12hours", hour * 12), new Timeout("24hours", hour * 24)};
        this.timeout = new JComboBox<Timeout>(timeouts);
        bottompanel.add(this.timeout);
        bottompanel.setBounds(150, 525, 400, 80);
        this.add(bottompanel);
        this.start = new JButton(this.resb.getString("newgame.startgame"));
        NewGameFrame.sortOutButton(this.start, this.newgame.getSubimage(544, 528, w, h), this.newgame.getSubimage(700, 295, w, h), this.newgame.getSubimage(700, 326, w, h));
        this.start.addActionListener(this);
        this.start.setBounds(544, 528, 115, 31);
        this.add(this.cancel);
        this.add(this.start);
        this.list.setFixedCellHeight(33);
    }

    public Game showDialog(Window parent, String serveroptions, String myname) {
        this.gamename.setText(myname + "'s " + RiskUtil.GAME_NAME + " Game");
        if (this.dialog == null) {
            this.dialog = parent instanceof Frame ? new JDialog((Frame)parent, "Game Options", true) : new JDialog((Dialog)parent, "Game Options", true);
            this.dialog.setContentPane(this);
            this.dialog.setResizable(false);
            this.dialog.pack();
        }
        if (serveroptions != null && !serveroptions.equals(this.newGameOptions)) {
            this.newGameOptions = serveroptions;
            String[] split = this.newGameOptions.split(",");
            this.maps = new RiskMap[split.length];
            for (int c = 0; c < split.length; ++c) {
                this.maps[c] = GameSetupPanel.getRiskMap(split[c]);
            }
            this.setMaps(this.maps);
            final JList list = this.getList();
            new Thread(){

                public void run() {
                    for (int c = 0; c < GameSetupPanel.this.maps.length; ++c) {
                        GameSetupPanel.this.maps[c].loadInfo();
                        if (c == 0) {
                            GameSetupPanel.this.setSelected(c);
                        }
                        list.repaint();
                    }
                }
            }.start();
        }
        this.reset();
        this.dialog.setVisible(true);
        String op = this.getOptions();
        if (op != null) {
            return new Game(this.getGameName(), op, this.getNumberOfHumanPlayers(), ((Timeout)this.timeout.getSelectedItem()).getTime());
        }
        return null;
    }

    public static RiskMap getRiskMap(String name) {
        RiskMap themap;
        if (MapMap == null) {
            MapMap = new HashMap();
        }
        if ((themap = (RiskMap)MapMap.get(name)) == null) {
            themap = new RiskMap(name);
            MapMap.put(name, themap);
        }
        return themap;
    }

    public void setMaps(RiskMap[] maps) {
        this.list.setListData(maps);
    }

    public JList getList() {
        return this.list;
    }

    public void setSelected(int a) {
        this.list.setSelectedIndex(a);
    }

    public JPanel makeNewMission(String a) {
        JPanel mission = new JPanel(){

            public void paintComponent(Graphics g) {
                g.setColor(new Color(255, 255, 255, 100));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        mission.setOpaque(false);
        mission.setLayout(new BorderLayout());
        JLabel cl = new JLabel(new ImageIcon(this.card));
        cl.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        mission.add((Component)cl, "West");
        JTextArea text = new JTextArea(a);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        text.setOpaque(false);
        mission.add(text);
        return mission;
    }

    public String getOptions() {
        return this.options;
    }

    public String getGameName() {
        return this.gamename.getText();
    }

    public int getNumberOfHumanPlayers() {
        return (Integer)this.human.getValue();
    }

    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(this.newgame, 0, 0, this);
        g.drawImage(this.game2.getSubimage(0, 0, 223, 155), 41, 185, this);
        g.drawImage(this.game2.getSubimage(25, 155, 169, 127), 391, 325, this);
        g.setColor(Color.black);
        g.drawString(this.resb.getString("newgame.label.map"), 55, 40);
        g.drawString("Missions:", 350, 40);
        g.drawString("Number of Players", 440, 300);
        g.drawString(this.resb.getString("newgame.label.gametype"), 400, 365);
        g.drawString(this.resb.getString("newgame.label.cardsoptions"), 515, 365);
    }

    public void reset() {
        this.options = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.start) {
            int d;
            int a = (Integer)this.human.getValue();
            int b = (Integer)this.aiaverage.getValue();
            int c = (Integer)this.aieasy.getValue();
            int sum = a + c + (d = ((Integer)this.aihard.getValue()).intValue());
            if (sum >= 2 && sum <= 6) {
                int gameMode = this.domination.isSelected() ? 0 : (this.capital.isSelected() ? 2 : 3);
                int cardsMode = this.increasing.isSelected() ? 0 : (this.fixed.isSelected() ? 1 : 2);
                this.options = RiskUtil.createGameString(b, c, d, gameMode, cardsMode, this.AutoPlaceAll.isSelected(), this.recycle.isSelected(), this.riskmap.getFileName());
                this.dialog.setVisible(false);
            } else {
                JOptionPane.showMessageDialog(this, this.resb.getString("newgame.error.numberofplayers"), this.resb.getString("newgame.error.title"), 0);
            }
        } else if (e.getSource() == this.cancel) {
            this.dialog.setVisible(false);
        } else if (e.getSource() == this.mission) {
            this.AutoPlaceAll.setEnabled(false);
        } else if (e.getSource() == this.domination) {
            this.AutoPlaceAll.setEnabled(true);
        } else if (e.getSource() == this.capital) {
            this.AutoPlaceAll.setEnabled(true);
        }
    }

    class RiskMapListCellRenderer
    extends DefaultListCellRenderer {
        RiskMapListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                this.setBackground(new Color(255, 255, 255, 100));
            } else {
                this.setBackground(new Color(0, 0, 0, 0));
            }
            this.setIcon(((RiskMap)value).getIcon());
            return retValue;
        }
    }

    class Timeout {
        String name;
        int time;

        Timeout(String name, int time) {
            this.name = GameSetupPanel.this.resb.getString("newgame.timeout." + name);
            this.time = time;
        }

        int getTime() {
            return this.time;
        }

        public String toString() {
            return this.name;
        }
    }
}

