/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.mini;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import net.yura.domination.engine.OnlineRisk;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mapstore.MapChooser;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.lobby.mini.MiniLobbyGame;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.util.Properties;
import net.yura.swingme.core.CoreUtil;

public abstract class MiniLobbyRisk
implements MiniLobbyGame,
OnlineRisk {
    private static final Logger logger = Logger.getLogger(MiniLobbyRisk.class.getName());
    private Risk myrisk;
    protected MiniLobbyClient lobby;
    private boolean openGame;
    WeakHashMap mapping = new WeakHashMap();

    public MiniLobbyRisk(Risk risk) {
        this.myrisk = risk;
    }

    public void addLobbyGameMoveListener(MiniLobbyClient lgl) {
        this.lobby = lgl;
    }

    public Properties getProperties() {
        return CoreUtil.wrap(TranslationBundle.getBundle());
    }

    public boolean isMyGameType(GameType gametype) {
        return RiskUtil.GAME_NAME.equals(gametype.getName());
    }

    public void objectForGame(Object object) {
        Map map = (Map)object;
        this.myrisk.lobbyMessage(map, this.lobby.whoAmI(), this);
        String command = (String)map.get("command");
        if ("game".equals(command)) {
            this.openGame = true;
        }
    }

    public void stringForGame(String message) {
        if (this.openGame) {
            this.myrisk.parserFromNetwork(message);
        } else {
            logger.info("GAME NOT OPEN SO IGNORING: " + message);
        }
    }

    public void renamePlayer(String oldname, String newname) {
        this.myrisk.renamePlayer(oldname, newname);
    }

    public void disconnected() {
        this.myrisk.disconnected();
    }

    public Icon getIconForGame(Game game) {
        net.yura.domination.mapstore.Map map = MapChooser.createMap(RiskUtil.getMapNameFromLobbyStartGameOption(game.getOptions()));
        this.mapping.put(game, map);
        return MapChooser.getLocalIconForMap(map);
    }

    public String getGameDescription(Game game) {
        return RiskUtil.getGameDescriptionFromLobbyStartGameOption(game.getOptions());
    }

    public void sendUserCommand(String messagefromgui) {
        this.lobby.sendGameMessage(messagefromgui);
    }

    public void sendGameCommand(String mtemp) {
        logger.info("ignore GameCommand " + mtemp);
    }

    public void closeGame() {
        this.openGame = false;
        this.lobby.closeGame();
    }
}

