/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.yura.grasshopper.BugManager;
import net.yura.grasshopper.BugSubmitter;
import net.yura.grasshopper.BugSystemInfo;

public class PopupBug
extends Writer {
    static PopupBug instance;
    private JDialog errFrame;
    private JTextArea debugText = new JTextArea();
    private BugManager simplePrintStream;
    private String cause;

    private PopupBug() {
        this.debugText.setEditable(false);
        this.simplePrintStream = new BugManager(){

            protected void action(String thecause) {
                PopupBug.this.cause = thecause;
                PopupBug.this.openPopup();
            }
        };
        BugManager.interceptAndAlert(this, this.simplePrintStream);
        instance = this;
    }

    public static void initSimple(String appname, String version, String locale) {
        if (instance == null) {
            new PopupBug();
        }
        BugSystemInfo.appName = appname;
        BugSystemInfo.version = version;
        BugSystemInfo.locale = locale;
    }

    public static void log(String text) {
        PopupBug.instance.debugText.append(text);
    }

    public static void clearLog() {
        if (!PopupBug.instance.simplePrintStream.hasHappened()) {
            PopupBug.instance.debugText.setText("");
        }
    }

    private void openPopup() {
        if (this.errFrame == null) {
            this.errFrame = new JDialog((Frame)null, "an error has occurred!!!", true);
            this.errFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent winEvt) {
                    PopupBug.this.errFrame.setVisible(false);
                    PopupBug.this.doSubmit("closed");
                }
            });
            JScrollPane errScroll = new JScrollPane(this.debugText);
            Dimension size = new Dimension(400, 400);
            errScroll.setMaximumSize(size);
            errScroll.setPreferredSize(size);
            errScroll.setMinimumSize(size);
            JLabel label = new JLabel("an error happened, please click on the button at the bottom to send it");
            label.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, Color.RED));
            JButton saveErr = new JButton("click here to send");
            saveErr.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    String email = JOptionPane.showInputDialog(PopupBug.this.errFrame, (Object)"tell me your e-mail please, in case i have questons about this bug");
                    if (email == null) {
                        email = "not-given";
                    }
                    PopupBug.this.errFrame.setVisible(false);
                    try {
                        PopupBug.this.doSubmit(email);
                        JOptionPane.showMessageDialog(null, "SENT!");
                    }
                    catch (Throwable ex) {
                        JOptionPane.showMessageDialog(null, "ERROR: " + ex.getMessage());
                    }
                }
            });
            this.errFrame.getContentPane().add((Component)label, "North");
            this.errFrame.getContentPane().add((Component)errScroll, "Center");
            this.errFrame.getContentPane().add((Component)saveErr, "South");
            this.errFrame.pack();
        }
        this.errFrame.setVisible(true);
    }

    private void doSubmit(String email) {
        BugSubmitter.submitBug(this.debugText.getText(), email, this.cause);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.debugText.append(String.valueOf(cbuf, off, len));
    }

    public void flush() {
    }

    public void close() {
    }
}

