/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io.file;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemListener;

public class FileSystemRegistry {
    static String[] listenRoots = null;
    static FileSystemListener fslistener;
    public static final Hashtable remap;

    private FileSystemRegistry() {
    }

    private static void initRoots() {
        String roots = System.getProperty("fconn.listenroots");
        if (roots != null) {
            StringTokenizer tokens = new StringTokenizer(roots, ";");
            listenRoots = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                FileSystemRegistry.listenRoots[i++] = tokens.nextToken();
            }
        } else {
            File[] fileroots = File.listRoots();
            listenRoots = new String[fileroots.length];
            for (int c = 0; c < fileroots.length; ++c) {
                FileSystemRegistry.listenRoots[c] = fileroots[c].getAbsolutePath();
            }
            File filesystem = new File(System.getProperty("user.home"), "j2mewtk/2.5.2/appdb/DefaultColorPhone/filesystem");
            if (filesystem.exists() && filesystem.isDirectory()) {
                File[] files = filesystem.listFiles();
                Vector<String> dirs = new Vector<String>();
                for (int c = 0; c < files.length; ++c) {
                    if (!files[c].isDirectory()) continue;
                    String name = files[c].getName() + "/";
                    remap.put("file:///" + name, files[c].getAbsolutePath() + "/");
                    dirs.add(name);
                }
                String[] old = listenRoots;
                listenRoots = new String[old.length + dirs.size()];
                System.arraycopy(old, 0, listenRoots, 0, old.length);
                for (int c = old.length; c < listenRoots.length; ++c) {
                    FileSystemRegistry.listenRoots[c] = (String)dirs.elementAt(c - old.length);
                }
            }
            for (int c = 0; c < listenRoots.length; ++c) {
                FileSystemRegistry.listenRoots[c] = listenRoots[c].replaceAll("\\\\", "/");
            }
        }
    }

    public static boolean addFileSystemListener(FileSystemListener listener) {
        if (fslistener != null) {
            return false;
        }
        if (listenRoots == null) {
            FileSystemRegistry.initRoots();
        }
        fslistener = listener;
        new ListenThread().start();
        return true;
    }

    public static Enumeration listRoots() {
        if (listenRoots == null) {
            FileSystemRegistry.initRoots();
        }
        if (listenRoots != null) {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < listenRoots.length; ++i) {
                try {
                    FileConnection fc = (FileConnection)Connector.open("file:///" + listenRoots[i], 1);
                    if (!fc.exists()) continue;
                    v.addElement(listenRoots[i]);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            String[] roots = new String[v.size()];
            for (int i = 0; i < roots.length; ++i) {
                String root = (String)v.elementAt(i);
                roots[i] = root = root.substring(0, root.length());
            }
            return new FileRootEnumeration(roots);
        }
        return new FileRootEnumeration(null);
    }

    public static boolean removeFileSystemListener(FileSystemListener listener) {
        listener = null;
        return true;
    }

    static {
        remap = new Hashtable();
    }

    static class ListenThread
    extends Thread {
        Hashtable roots = new Hashtable();

        ListenThread() {
        }

        public void run() {
            String element;
            FileRootEnumeration list = (FileRootEnumeration)FileSystemRegistry.listRoots();
            while (list.hasMoreElements()) {
                element = (String)list.nextElement();
                this.roots.put(element, element);
            }
            while (fslistener != null) {
                list = (FileRootEnumeration)FileSystemRegistry.listRoots();
                if (list.size() > this.roots.size()) {
                    while (list.hasMoreElements()) {
                        element = (String)list.nextElement();
                        if (this.roots.get(element) != null) continue;
                        this.roots.put(element, element);
                        fslistener.rootChanged(0, element);
                        break;
                    }
                } else if (list.size() < this.roots.size()) {
                    while (list.hasMoreElements()) {
                        this.roots.remove(list.nextElement());
                    }
                    String removedRoot = (String)this.roots.elements().nextElement();
                    fslistener.rootChanged(1, removedRoot);
                    this.roots = new Hashtable();
                    list = (FileRootEnumeration)FileSystemRegistry.listRoots();
                    while (list.hasMoreElements()) {
                        String element2 = (String)list.nextElement();
                        this.roots.put(element2, element2);
                    }
                }
                try {
                    ListenThread.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    static class FileRootEnumeration
    implements Enumeration {
        String[] list = null;
        int idx = 0;

        public FileRootEnumeration(String[] list) {
            this.list = list;
        }

        public int size() {
            if (this.list != null) {
                return this.list.length;
            }
            return 0;
        }

        public boolean hasMoreElements() {
            if (this.list == null) {
                return false;
            }
            return this.idx < this.list.length;
        }

        public Object nextElement() {
            return this.list[this.idx++];
        }
    }
}

