/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ScmCanvas;
import javax.microedition.lcdui.ScmDisplayable;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.Log;

public abstract class Canvas
extends Displayable {
    Command centerCommand;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int UP = 1;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_POUND = 35;
    public static final int KEY_STAR = 42;
    ScmCanvas component = new ScmCanvas(this);
    boolean hasPointerEvents = !"false".equalsIgnoreCase(ApplicationManager.getInstance().getProperty("touch_screen"));
    protected boolean _fullScreenMode = ApplicationManager.getInstance().getFlag("canvasHideSoftButtons");
    Image videoFrameImage;
    int videoFrameX;
    int videoFrameY;
    int oldH = this.getHeight();
    int oldW = this.getWidth();

    protected Canvas() {
        Display.check();
        this.container = new ScmDisplayable(this);
        this.container.setMain(this.component, false);
        if (ApplicationManager.getInstance().getFlag("SiemensCK")) {
            this.centerCommand = new Command("CenterBlocker", 1, -15);
            this.centerCommand.type = 0;
            this.addCommand(this.centerCommand);
        }
    }

    public void _showNotify() {
        this.component.requestFocus();
        this.showNotify();
        this.repaint();
    }

    public void _hideNotify() {
        this.hideNotify();
    }

    public void _setVideoControlData(int x, int y, Image img) {
        this.videoFrameX = x;
        this.videoFrameY = y;
        this.videoFrameImage = img;
        this.repaint();
    }

    protected abstract void paint(Graphics var1);

    public int getGameAction(int keyCode) {
        return ApplicationManager.getInstance().getGameAction(keyCode);
    }

    public int getKeyCode(int game) {
        String name;
        switch (game) {
            case 1: {
                name = "UP";
                break;
            }
            case 6: {
                name = "DOWN";
                break;
            }
            case 2: {
                name = "LEFT";
                break;
            }
            case 5: {
                name = "RIGHT";
                break;
            }
            case 8: {
                name = "SELECT";
                break;
            }
            default: {
                return game;
            }
        }
        return ApplicationManager.getInstance().getDeviceKeyCode(name);
    }

    public String getKeyName(int keyCode) {
        return keyCode > 0 ? "" + (char)keyCode : KeyEvent.getKeyText(-keyCode);
    }

    public int getHeight() {
        return this.component.getHeight();
    }

    public int getWidth() {
        return this.component.getWidth();
    }

    public boolean hasPointerEvents() {
        return this.hasPointerEvents;
    }

    public boolean hasPointerMotionEvents() {
        return this.hasPointerEvents();
    }

    public boolean hasRepeatEvents() {
        return true;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    protected void hideNotify() {
    }

    protected void keyPressed(int code) {
    }

    protected void keyReleased(int code) {
    }

    protected void keyRepeated(int code) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    public void repaint() {
        this.component.repaintPending = true;
        this.component.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRepaints() {
        Log.log(1, "serviceRepaint() entered");
        if (this.component.repaintPending) {
            if (EventQueue.isDispatchThread()) {
                Object object = this.component.repaintLock;
                synchronized (object) {
                    java.awt.Graphics g = this.component.getGraphics();
                    if (g != null) {
                        this.component.paint(g);
                    }
                }
            } else {
                for (int i = 0; i < 20 && this.component.repaintPending; ++i) {
                    try {
                        System.out.println("DOING SLEEP 50");
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        Log.log(1, "serviceRepaint() left");
    }

    public void repaint(int x, int y, int w, int h) {
        this.component.repaintPending = true;
        this.component.repaint(x, y, w, h);
    }

    protected void showNotify() {
    }

    protected void sizeChanged(int w, int h) {
    }

    public void setFullScreenMode(boolean mode) {
        if (mode == this._fullScreenMode) {
            return;
        }
        this.oldW = this.getWidth();
        this.oldH = this.getHeight();
        this._fullScreenMode = mode;
        this.container.init();
        this.container.setMain(this.component, false);
        this.container.doLayout();
        this.container.updateButtons();
    }

    public void multitouchEvent(int[] type, int[] x, int[] y) {
    }

    public void pointerMoved(int x, int y) {
    }
}

