/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import android.graphics.ColorMatrix;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.lcdui.PhysicalFont;

public class Graphics {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    public int translateX = 0;
    public int translateY = 0;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    public int strokeStyle = 0;
    private java.awt.Graphics awtGraphics;
    Font font;
    public int _argbColor;
    Canvas canvas;
    BufferedImage image;
    BufferedImage tmpImg;
    ColorMatrix colorMatrix;

    public Graphics(java.awt.Graphics g) {
        this(null, null, g);
    }

    Graphics(Canvas canvas, BufferedImage image, java.awt.Graphics g) {
        this.awtGraphics = g;
        this.canvas = canvas;
        this.image = image;
        this.setFont(Font.getDefaultFont());
    }

    public java.awt.Graphics _getAwtGraphics() {
        if (this.awtGraphics == null) {
            this.awtGraphics = this.image.getGraphics();
        }
        return this.awtGraphics;
    }

    public BufferedImage _getAwtImage(int[] xy0) {
        return this.image;
    }

    public void drawArc(int x, int y, int w, int h, int sa, int aa) {
        this._getAwtGraphics().drawArc(x, y, w, h, sa, aa);
    }

    public void drawChars(char[] chars, int ofs, int len, int x, int y, int align) {
        this.drawString(new String(chars, ofs, len), x, y, align);
    }

    public void drawImage(Image img, int x, int y, int align) {
        ApplicationManager manager = ApplicationManager.getInstance();
        int w = img._image.getWidth();
        int h = img._image.getHeight();
        x = this.normalizeX(x, w, align);
        y = this.normalizeY(y, h, align);
        this._getAwtGraphics().drawImage(this.getImageToDraw(img), x, y, null);
    }

    public java.awt.Image getImageToDraw(Image img) {
        if (this.colorMatrix != null) {
            FilteredImageSource filteredSrc = new FilteredImageSource(img._image.getSource(), this.colorMatrix);
            java.awt.Image i = Toolkit.getDefaultToolkit().createImage(filteredSrc);
            return i;
        }
        return img._image;
    }

    public void drawLine(int x0, int y0, int x1, int y1) {
        if (this.strokeStyle == 0) {
            this._getAwtGraphics().drawLine(x0, y0, x1, y1);
        } else {
            int dx = x1 - x0;
            int dy = y1 - y0;
            int steps = Math.max(Math.abs(dx), Math.abs(dy)) / 4;
            dx = (dx << 16) / steps;
            dy = (dy << 16) / steps;
            x0 <<= 16;
            y0 <<= 16;
            while (steps > 0) {
                this._getAwtGraphics().drawLine(x0 >> 16, y0 >> 16, x0 + dx >> 16, y0 + dy >> 16);
                x0 += dx + dx;
                y0 += dy + dy;
                steps -= 2;
            }
        }
    }

    public void drawString(String text, int x, int y, int align) {
        int va = align & 0x70;
        int ha = align & 0xD;
        if (va != 0 && ha == 0 || va == 0 && ha != 0) {
            throw new IllegalArgumentException("Graphics: Invalid Anchor. Both anchors (v and h)  must be set. Anchor is: " + align);
        }
        if (text == null) {
            return;
        }
        PhysicalFont fm = this.font.info.font;
        int cut = text.indexOf(10);
        if (cut != -1) {
            this.drawString(text.substring(cut + 1), x, y + fm.height, align);
            text = text.substring(0, cut);
        }
        switch (align & 0x70) {
            case 0: 
            case 16: {
                y += fm.ascent;
                break;
            }
            case 64: {
                break;
            }
            case 32: {
                y -= fm.descent;
                break;
            }
            default: {
                throw new IllegalArgumentException("Graphics: Invalid Anchor. Anchor is: " + align);
            }
        }
        this.font.info.drawString(this._getAwtGraphics(), text, this.normalizeX(x, fm.stringWidth(text), align), y);
    }

    public void drawRect(int x, int y, int w, int h) {
        this._getAwtGraphics().drawRect(x, y, w, h);
    }

    public void drawRoundRect(int x, int y, int w, int h, int r1, int r2) {
        this._getAwtGraphics().drawRoundRect(x, y, w, h, r1, r2);
    }

    public void fillArc(int x, int y, int w, int h, int sa, int aa) {
        this._getAwtGraphics().fillArc(x, y, w, h, sa, aa);
    }

    public void fillRect(int x, int y, int w, int h) {
        this._getAwtGraphics().fillRect(x, y, w, h);
    }

    public void fillRoundRect(int x, int y, int w, int h, int r1, int r2) {
        this._getAwtGraphics().fillRoundRect(x, y, w, h, r1, r2);
    }

    public Font getFont() {
        return this.font;
    }

    public int getClipX() {
        Rectangle r = this._getAwtGraphics().getClipBounds();
        return r == null ? -this.translateX : r.x;
    }

    public int getClipY() {
        Rectangle r = this._getAwtGraphics().getClipBounds();
        return r == null ? -this.translateY : r.y;
    }

    public int getClipWidth() {
        Rectangle r = this._getAwtGraphics().getClipBounds();
        return r == null ? (int)((double)(this.canvas == null ? this.image.getWidth() : this.canvas.getWidth()) / this.scaleX) : r.width;
    }

    public int getClipHeight() {
        Rectangle r = this._getAwtGraphics().getClipBounds();
        return r == null ? (int)((double)(this.canvas == null ? this.image.getHeight() : this.canvas.getHeight()) / this.scaleY) : r.height;
    }

    public int getColor() {
        return this._getAwtGraphics().getColor().getRGB();
    }

    public void setFont(Font font) {
        if (font == null) {
            font = Font.getDefaultFont();
        }
        this.font = font;
    }

    public void translate(int x, int y) {
        this.translateX += x;
        this.translateY += y;
        this._getAwtGraphics().translate(x, y);
    }

    public void clipRect(int x, int y, int w, int h) {
        this._getAwtGraphics().clipRect(x, y, w, h);
    }

    public void setClip(int x, int y, int w, int h) {
        this._getAwtGraphics().setClip(x, y, w, h);
    }

    public void setColor(int c) {
        this._getAwtGraphics().setColor(new Color(c, true));
    }

    public void setColor(int cr, int cg, int cb) {
        this.setColor(cr << 16 | cg << 8 | cb);
    }

    public void setGrayScale(int gsc) {
        this.setColor(gsc, gsc, gsc);
    }

    public void drawSubstring(String str, int offset, int len, int x, int y, int anchor) {
        this.drawString(str.substring(offset, offset + len), x, y, anchor);
    }

    public void drawChar(char character, int x, int y, int anchor) {
        char[] characters = new char[]{character};
        this.drawString(new String(characters), x, y, anchor);
    }

    public int getBlueComponent() {
        return this._getAwtGraphics().getColor().getBlue();
    }

    public int getGreenComponent() {
        return this._getAwtGraphics().getColor().getGreen();
    }

    public int getRedComponent() {
        return this._getAwtGraphics().getColor().getRed();
    }

    public int getGrayScale() {
        return this.getRedComponent();
    }

    public int getTranslateX() {
        return this.translateX;
    }

    public int getTranslateY() {
        return this.translateY;
    }

    public void setStrokeStyle(int style) {
        this.strokeStyle = style;
    }

    public int getStrokeStyle() {
        return this.strokeStyle;
    }

    private int normalizeX(int x, int w, int anchor) {
        switch (anchor & 0xD) {
            case 0: 
            case 4: {
                return x;
            }
            case 8: {
                return x - w;
            }
            case 1: {
                return x - w / 2;
            }
        }
        throw new IllegalArgumentException();
    }

    private int normalizeY(int y, int h, int anchor) {
        switch (anchor & 0x72) {
            case 0: 
            case 16: {
                return y;
            }
            case 32: {
                return y - h;
            }
            case 2: {
                return y - h / 2;
            }
        }
        throw new IllegalArgumentException();
    }

    public void drawRegion(Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        if (transform == 0) {
            x_dest = this.normalizeX(x_dest, width, anchor);
            y_dest = this.normalizeY(y_dest, height, anchor);
            int cx = this.getClipX();
            int cy = this.getClipY();
            int cw = this.getClipWidth();
            int ch = this.getClipHeight();
            this.clipRect(x_dest, y_dest, width, height);
            this.drawImage(src, x_dest - x_src, y_dest - y_src, 0);
            this.setClip(cx, cy, cw, ch);
        } else {
            Image trans = Image.createImage(src, x_src, y_src, width, height, transform);
            this.drawImage(trans, x_dest, y_dest, anchor);
        }
    }

    public void copyArea(int x_src, int y_src, int width, int height, int x_dest, int y_dest, int anchor) {
        if (this.image == null) {
            throw new RuntimeException("Only valid for images");
        }
        this._getAwtGraphics().copyArea(x_src, y_src, width, height, this.normalizeX(x_dest, width, anchor), this.normalizeY(y_dest, height, anchor));
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this._getAwtGraphics().fillPolygon(new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
    }

    public synchronized void drawRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
        if (width == 0 || height == 0) {
            return;
        }
        if (this.tmpImg == null || this.tmpImg.getWidth() < width || this.tmpImg.getHeight() < height) {
            this.tmpImg = new BufferedImage(width, height, 2);
        }
        this.tmpImg.setRGB(0, 0, width, height, rgbData, offset, scanlength);
        java.awt.Graphics g = this._getAwtGraphics();
        Shape clip = g.getClip();
        g.clipRect(x, y, width, height);
        g.drawImage(this.tmpImg, x, y, null);
        g.setClip(clip);
    }

    public int getDisplayColor(int color) {
        return ApplicationManager.getInstance().getDeviceColor(color);
    }

    public void scale(double sx, double sy) {
        ((Graphics2D)this._getAwtGraphics()).scale(sx, sy);
        this.scaleX *= sx;
        this.scaleY *= sy;
        this.translateX = (int)((double)this.translateX / this.scaleX);
        this.translateY = (int)((double)this.translateY / this.scaleY);
    }

    public void setColorMarix(ColorMatrix cm) {
        this.colorMatrix = cm;
    }

    public int getStrokeWidth() {
        Graphics2D g2;
        Stroke stroke;
        if (this.awtGraphics instanceof Graphics2D && (stroke = (g2 = (Graphics2D)this.awtGraphics).getStroke()) instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            return (int)bs.getLineWidth();
        }
        return 1;
    }

    public void setStrokeWidth(int i) {
        if (this.awtGraphics instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.awtGraphics;
            g2.setStroke(new BasicStroke(i));
        }
    }
}

