/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.impl.lcdui;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Hashtable;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.lcdui.AwtFont;
import org.me4se.impl.lcdui.PhysicalFont;

public class FontInfo {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int CENTER = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int BORDER = 15;
    public static final int ROUND = 16;
    public static final int SHADOW = 32;
    public static final int COMPACT = 64;
    public static final int UNDERLINE_CHARS = 256;
    String type;
    public PhysicalFont font;
    public Color foreground;
    public Color border;
    public Color shadow;
    public Color background;
    public int align = 2;
    public int decoration;
    public int height;
    public static Hashtable infoCache = new Hashtable();
    public static Hashtable physicalCache = new Hashtable();

    public static FontInfo getFontInfo(String type) {
        FontInfo result = (FontInfo)infoCache.get(type = type.toLowerCase());
        if (result == null) {
            result = new FontInfo(type);
            infoCache.put(type, result);
        }
        return result;
    }

    int getIntProperty(String t, String p, int dflt) {
        String v = this.getProperty(t, p);
        return v == null ? dflt : Integer.decode(v);
    }

    String getProperty(String type, String property) {
        int cut;
        String fullName = property == null ? type : (property.equals("font") ? "font." + type : type + "." + property);
        String v = ApplicationManager.getInstance().getProperty(fullName);
        if (v != null) {
            return v;
        }
        boolean focus = type.endsWith(".focus");
        if (focus) {
            type = type.substring(0, type.length() - 6);
        }
        if ((cut = type.lastIndexOf(46)) == -1) {
            if (type.equals("default") && !focus) {
                return null;
            }
            type = focus ? "focus" : "default";
            focus = false;
        } else {
            type = type.substring(0, cut);
        }
        if (focus) {
            type = type + ".focus";
        }
        return this.getProperty(type, property);
    }

    protected FontInfo(String type) {
        this.type = type.toLowerCase();
        ApplicationManager manager = ApplicationManager.getInstance();
        this.height = this.getIntProperty(type, "height", -1);
        int bg = this.getIntProperty(type, "background", -1);
        int fg = this.getIntProperty(type, "foreground", (bg ^ 0xFFFFFF) & 0xFFFFFF);
        int bc = this.getIntProperty(type, "border", 0);
        int sc = this.getIntProperty(type, "shadow", 0xAAAAAA);
        this.foreground = new Color(manager.getDeviceColor(fg & 0xFFFFFF));
        if (bg != -1) {
            this.background = new Color(manager.getDeviceColor(bg & 0xFFFFFF));
        }
        this.shadow = new Color(manager.getDeviceColor(sc & 0xFFFFFF));
        this.border = new Color(manager.getDeviceColor(bc & 0xFFFFFF));
        String alignS = this.getProperty(type, "align");
        if (alignS == null) {
            this.align = type.startsWith("softbutton") ? 3 : 1;
        } else if ("right".equals(alignS)) {
            this.align = 2;
        } else if ("center".equals(alignS)) {
            this.align = 3;
        } else if ("left".equals(alignS)) {
            this.align = 1;
        } else if ("border".equals(alignS)) {
            this.align = 15;
        }
        String decorationStr = this.getProperty(type, "decoration");
        if (decorationStr == null) {
            if (type.equals("item.focus") && bg == -1) {
                this.decoration = 15;
            } else if (type.equals("title")) {
                this.decoration = 8;
            } else if (type.equals("hyperlink")) {
                this.decoration = 256;
            } else if (type.equals("button")) {
                this.decoration = 47;
            }
        } else {
            if ((decorationStr = decorationStr.toLowerCase()).indexOf("shadow") != -1) {
                this.decoration |= 0x20;
            }
            if (decorationStr.indexOf("underline") != -1) {
                this.decoration |= 8;
            }
            if (decorationStr.indexOf("overline") != -1) {
                this.decoration |= 4;
            }
            if (decorationStr.indexOf("round") != -1) {
                this.decoration |= 0x10;
            }
            if (decorationStr.indexOf("border") != -1) {
                this.decoration |= 0xF;
            }
            if (decorationStr.indexOf("underlinechars") != -1) {
                this.decoration |= 0x100;
            }
            if (decorationStr.indexOf("compact") != -1) {
                this.decoration |= 0x40;
            }
        }
        String description = this.getProperty(type, "font");
        if (description != null) {
            this.font = (PhysicalFont)physicalCache.get(description);
            if (this.font == null) {
                this.font = description.endsWith(".properties") ? this.getAwtFont() : new AwtFont(description);
                physicalCache.put(description, this.font);
            }
        } else {
            this.font = this.getAwtFont();
        }
        if (this.height == -1) {
            this.height = this.font.height;
        }
    }

    public AwtFont getAwtFont() {
        boolean underlined;
        boolean bold = this.type.startsWith("softbutton") || "title".equals(this.type) || this.type.indexOf(".bold") != -1 || this.type.indexOf(".focus") != -1;
        boolean italic = this.type.indexOf(".italic") != -1;
        boolean bl = underlined = this.type.indexOf(".underlined") != -1;
        int height = "ME4SE-iPhoneEmulator".equals(ApplicationManager.getInstance().getProperty("microedition.platform")) ? (this.font != null ? this.font.height : (this.type.indexOf(".small") != -1 ? 20 : (this.type.indexOf(".large") != -1 ? 28 : 24))) : (this.font != null ? this.font.height : (this.type.indexOf(".small") != -1 ? 14 : (this.type.indexOf(".large") != -1 ? 18 : 16)));
        return new AwtFont(height, bold, italic, underlined);
    }

    public void drawString(Graphics g, String s, int x, int y) {
        this.font.drawString(g, s, x, y);
        if ((this.decoration & 0x100) != 0) {
            g.drawLine(x, y + 1, x + this.font.stringWidth(s), y + 1);
        }
    }
}

