/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.impl.skins;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.System;
import org.me4se.impl.lcdui.BitmapFont;
import org.me4se.impl.lcdui.FontInfo;
import org.me4se.scm.ScmComponent;
import org.me4se.scm.ScmContainer;

public class Skin
extends ScmContainer {
    private Image defaultImage;
    private Image pressedButtonsImage;
    private Image highlightedImage;
    public Panel panel;
    boolean sized = false;
    private SkinButton pressing = null;
    private SkinButton over = null;
    private String skinUrl;
    private static Hashtable keyCodes = new Hashtable();

    private static void registerKey(String name, int value) {
        keyCodes.put(name, new Integer(value));
    }

    public int getInt(String name, int dflt) {
        return ApplicationManager.getInstance().getIntProperty(name, dflt);
    }

    public String getName(String name) {
        return ApplicationManager.concatPath(this.skinUrl, name);
    }

    public void paint(Graphics g) {
        g.drawImage(this.defaultImage, 0, 0, null);
        super.paint(g);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.defaultImage.getWidth(null), this.defaultImage.getHeight(null));
    }

    public Skin() {
        ApplicationManager manager = ApplicationManager.getInstance();
        this.skinUrl = manager.getProperty("skin");
        try {
            String s;
            BufferedReader reader = new BufferedReader(new InputStreamReader(manager.openInputStream(this.skinUrl)));
            while ((s = reader.readLine()) != null) {
                if (s.startsWith(":")) continue;
                int cut = s.indexOf(61);
                if (cut == -1) {
                    cut = s.indexOf(58);
                }
                if (cut == -1) continue;
                String key = s.substring(0, cut).trim().toLowerCase();
                String value = s.substring(cut + 1).trim();
                try {
                    if (key.equals("default_image")) {
                        this.defaultImage = manager.getImage(this.getName(value));
                        continue;
                    }
                    if (key.equals("pressed_buttons_image")) {
                        this.pressedButtonsImage = manager.getImage(this.getName(value));
                        continue;
                    }
                    if (key.equals("highlighted_image")) {
                        this.highlightedImage = manager.getImage(this.getName(value));
                        continue;
                    }
                    manager.properties.put(key, value);
                    if (!key.startsWith("microedition.")) continue;
                    if (manager.applet == null) {
                        java.lang.System.setProperty(key, value);
                        continue;
                    }
                    System.properties.setProperty(key, value);
                }
                catch (Exception e) {
                    java.lang.System.err.println("exception " + e + " in property line: " + s);
                }
            }
            Enumeration<Object> e = manager.properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = manager.getProperty(key);
                try {
                    if (key.startsWith("font.") && value.endsWith(".properties")) {
                        String type = key.substring(5);
                        if (FontInfo.physicalCache.get(value) != null) continue;
                        FontInfo.physicalCache.put(value, new BitmapFont(this, value));
                        continue;
                    }
                    if (key.startsWith("button.")) {
                        int cut0 = value.indexOf(44);
                        int cut1 = value.indexOf(44, cut0 + 1);
                        int cut2 = value.indexOf(44, cut1 + 1);
                        int cut3 = value.indexOf(44, cut2 + 1);
                        if (cut3 == -1) {
                            cut3 = value.length();
                        }
                        this.add(new SkinButton(key.substring(7).toUpperCase(), Integer.parseInt(value.substring(0, cut0).trim()), Integer.parseInt(value.substring(cut0 + 1, cut1).trim()), Integer.parseInt(value.substring(cut1 + 1, cut2).trim()), Integer.parseInt(value.substring(cut2 + 1, cut3).trim())));
                        continue;
                    }
                    if (key.startsWith("key.")) {
                        String buttonName = key.substring(4).toUpperCase();
                        String[] vCodes = ApplicationManager.split(value);
                        for (int i = 0; i < vCodes.length; ++i) {
                            Integer ib = (Integer)keyCodes.get(vCodes[i]);
                            if (ib == null) continue;
                            manager.virtualKeyMap.put(ib, buttonName);
                        }
                        continue;
                    }
                    if (key.startsWith("game.")) {
                        int gameCode;
                        String f = key.substring(5).toUpperCase();
                        if (f.equals("UP")) {
                            gameCode = 1;
                        } else if (f.equals("DOWN")) {
                            gameCode = 6;
                        } else if (f.equals("LEFT")) {
                            gameCode = 2;
                        } else if (f.equals("RIGHT")) {
                            gameCode = 5;
                        } else {
                            if (!f.equals("FIRE") && !f.equals("SELECT")) continue;
                            gameCode = 8;
                        }
                        String[] buttons = ApplicationManager.split(value);
                        Integer gc = new Integer(gameCode);
                        for (int i = 0; i < buttons.length; ++i) {
                            manager.gameActions.put(buttons[i], gc);
                        }
                        continue;
                    }
                    if (!key.startsWith("keycode.")) continue;
                    String buttonName = key.substring(8);
                    Integer keyCode = new Integer(value);
                    manager.keyCodeToButtonName.put(keyCode, buttonName);
                }
                catch (Exception x) {
                    java.lang.System.err.println("exception " + x + " evaluating property line: " + key + "=" + value);
                }
            }
            manager.bgColor = new Color(this.getInt("screenBGColor", 0xFFFFFF));
            manager.isColor = manager.properties.getProperty("iscolor", "true").equals("true");
            manager.colorCount = this.getInt("colorcount", 0x1000000);
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Skin.registerKey("VK_UP", 38);
        Skin.registerKey("VK_DOWN", 40);
        Skin.registerKey("VK_LEFT", 37);
        Skin.registerKey("VK_RIGHT", 39);
        Skin.registerKey("VK_HOME", 36);
        Skin.registerKey("VK_END", 35);
        Skin.registerKey("VK_ESCAPE", 27);
        Skin.registerKey("VK_ENTER", 10);
        Skin.registerKey("VK_SPACE", 32);
        Skin.registerKey("VK_F1", 112);
        Skin.registerKey("VK_F2", 113);
        Skin.registerKey("VK_F3", 114);
        Skin.registerKey("VK_F4", 115);
        Skin.registerKey("VK_F5", 116);
        Skin.registerKey("VK_F6", 117);
        Skin.registerKey("VK_F7", 118);
        Skin.registerKey("VK_F8", 119);
        Skin.registerKey("VK_F9", 120);
        Skin.registerKey("VK_F10", 121);
        Skin.registerKey("VK_F11", 122);
        Skin.registerKey("VK_F12", 123);
    }

    class SkinButton
    extends ScmComponent {
        private int x;
        private int y;
        private String name;

        public SkinButton(String name, int x, int y, int w, int h) {
            this.name = name;
            this.setBounds(x, y, w, h);
            this.x = x;
            this.y = y;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paint(Graphics g) {
            if (Skin.this.over == this) {
                if (Skin.this.pressing == this) {
                    g.drawImage(Skin.this.pressedButtonsImage, -this.x, -this.y, null);
                } else {
                    g.drawImage(Skin.this.highlightedImage, -this.x, -this.y, null);
                }
            }
        }

        public boolean mousePressed(int button, int x, int y, int mask) {
            if (button != 1) {
                return false;
            }
            Skin.this.over = this;
            SkinButton old = Skin.this.pressing;
            Skin.this.pressing = this;
            this.repaint();
            if (old != null) {
                old.repaint();
            }
            ApplicationManager.getInstance().displayContainer.keyPressed(this.name);
            return true;
        }

        public boolean mouseDragged(int x, int y, int mask) {
            if (Skin.this.over == this == (x < 0 || x > this.getWidth() || y < 0 || y > this.getHeight())) {
                Skin.this.over = Skin.this.over == this ? null : this;
                this.repaint();
                return true;
            }
            return false;
        }

        public boolean mouseReleased(int button, int x, int y, int mask) {
            if (button != 1) {
                return false;
            }
            Skin.this.pressing = null;
            this.getParent().repaint();
            ApplicationManager.getInstance().displayContainer.keyReleased(this.name);
            return true;
        }

        public void mouseEntered() {
            if (Skin.this.pressing == null) {
                Skin.this.over = this;
            }
            this.getParent().repaint();
        }

        public void mouseExited() {
            if (Skin.this.over == this) {
                Skin.this.over = null;
            }
            this.getParent().repaint();
        }
    }
}

