/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui;

import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.logging.Logger;

public class Animation
extends Thread {
    static Animation animation;
    public static int FPS;
    final Vector components = new Vector();
    final Hashtable lastcall = new Hashtable();

    public Animation() {
        super("SwingMe-Animation-Two");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            try {
                long lastWait = System.currentTimeMillis();
                int sleep = 1000 / FPS;
                while (true) {
                    Vector vector = this.components;
                    synchronized (vector) {
                        if (this.components.isEmpty()) {
                            this.components.wait();
                            lastWait = System.currentTimeMillis();
                        }
                    }
                    for (int c = this.components.size() - 1; c >= 0; --c) {
                        Component cmp = (Component)this.components.elementAt(c);
                        long lastPaint = (Long)this.lastcall.get(cmp);
                        if (lastWait - lastPaint > 1000L) {
                            Animation.deregisterAnimated(cmp);
                            continue;
                        }
                        if (DesktopPane.getDesktopPane() != null) {
                            cmp.animate();
                            continue;
                        }
                        break block10;
                    }
                    lastWait = Animation.workoutSleep(sleep, lastWait);
                }
            }
            catch (Throwable th) {
                Logger.warn(th);
            }
        }
        animation = null;
    }

    public static long workoutSleep(int sleep, long lastWait) throws InterruptedException {
        long time = System.currentTimeMillis();
        long wait = Math.min((long)sleep, Math.max(0L, (long)sleep - (time - lastWait)));
        Thread.sleep(wait);
        return time + wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAnimated(Component cmp) {
        if (animation == null) {
            animation = new Animation();
            animation.start();
        }
        Animation ani = animation;
        ani.lastcall.put(cmp, new Long(System.currentTimeMillis()));
        Vector vector = ani.components;
        synchronized (vector) {
            if (!ani.components.contains(cmp)) {
                Logger.info("[Animation] registerAnimated " + cmp + "@" + System.identityHashCode(cmp));
                ani.components.addElement(cmp);
                ani.components.notify();
            }
        }
    }

    public static void deregisterAnimated(Component cmp) {
        Logger.info("[Animation] deregisterAnimated " + cmp + "@" + System.identityHashCode(cmp));
        Animation ani = animation;
        if (ani != null) {
            ani.components.removeElement(cmp);
            ani.lastcall.remove(cmp);
        }
    }

    static {
        FPS = 10;
    }
}

